# -*- coding: utf-8 -*-
#
#  setup.py
#  cjktools_data
# 
#  Created by Lars Yencken on 08-04-2009.
#  Copyright 2009 Lars Yencken. All rights reserved.
#

from setuptools import setup

VERSION = '0.2.1-2010-07-29'

f = open('data/__version__.py', 'w')
f.write('# Autogenerated by setup.py\n')
f.write('version = "%s"\n' % VERSION)
f.close()

setup(
    name='cjktools-data',
    author='Lars Yencken',
    author_email='lljy@csse.unimelb.edu.au',
    version=VERSION,
    url='http://bitbucket.org/lars512/cjktools-data/',
    download_url='http://files.gakusha.info/index.html',
    description='A collection of Japanese data files from the EDRDG.',
    long_description=\
'This package is a data bundle of common and popular data files compiled by the EDRDG, including EDICT, KANJIDIC and several others.',
    setup_requires=['setuptools_hg'],
    package_dir={'cjktools_data': 'data'},
    packages=['cjktools_data'],
    include_package_data=True,
    zip_safe=False,
)

# vim: ts=4 sw=4 sts=4 et tw=78:

