this.ckan.module('resource-upload-field',function(jQuery,_,i18n){return{options:{form:{method:'POST',file:'file',params:[]},i18n:{label:_('Upload a file'),errorTitle:_('An Error Occurred'),uploadSuccess:_('Resource uploaded'),uploadError:_('Unable to upload file'),authError:_('Unable to authenticate upload'),metadataError:_('Unable to get data for uploaded file')},template:['<span class="resource-upload-field">','<i class="ckan-icon ckan-icon-link-plugin"></i>','<input type="file" />','<input id="field-resource-type-upload" type="radio" name="resource_type" value="file.upload" />','<label class="radio inline" for="field-resource-type-upload"></label>','</span>'].join('\n')},initialize:function(){jQuery.proxyAll(this,/_on/);this.upload=jQuery(this.options.template);this.setupFileUpload();this.el.append(this.upload);},setupFileUpload:function(){var options=this.options;this.upload.find('label').text(this.i18n('label'));this.upload.find('input[type=file]').fileupload({type:options.form.method,paramName:options.form.file,forceIframeTransport:true,replaceFileInput:true,autoUpload:false,add:this._onUploadAdd,send:this._onUploadSend,done:this._onUploadDone,fail:this._onUploadFail,always:this._onUploadComplete});},loading:function(show){this.upload.toggleClass('loading',show);},authenticate:function(key,data){data.key=key;var request=this.sandbox.client.getStorageAuth(key);var onSuccess=jQuery.proxy(this._onAuthSuccess,this,data);return request.then(onSuccess,this._onAuthError);},lookupMetadata:function(key,data){var request=this.sandbox.client.getStorageMetadata(key);var onSuccess=jQuery.proxy(this._onMetadataSuccess,this,data);return request.then(onSuccess,this._onMetadataError);},notify:function(message,type){var title=this.i18n('errorTitle');this.sandbox.notify(title,message,type);},generateKey:function(filename){var parts=filename.split('.');var extension=jQuery.url.slugify(parts.pop());filename=jQuery.url.slugify(parts.join('.'))+'.'+extension;return jQuery.date.toISOString()+'/'+filename;},_onUploadAdd:function(event,data){if(data.files&&data.files.length){var key=this.generateKey(data.files[0].name);this.authenticate(key,data);}},_onUploadFail:function(){this.sandbox.notify(this.i18n('uploadError'));},_onUploadSend:function(){this.loading();},_onUploadDone:function(event,data){var result=data.result;if(result&&!(jQuery.isPlainObject(result)&&result.error)){this.lookupMetadata(data.key,data);}else{this._onUploadFail(event,data);}},_onUploadComplete:function(){this.loading(false);},_onAuthSuccess:function(data,response){data.url=response.action;data.formData=this.options.form.params.concat(response.fields);data.submit();},_onAuthError:function(event,data){this.sandbox.notify(this.i18n('authError'));this._onUploadComplete();},_onMetadataSuccess:function(data,response){var resource=this.sandbox.client.convertStorageMetadataToResource(response);this.sandbox.notify(this.i18n('uploadSuccess'),'','success');this.sandbox.publish('resource:uploaded',resource);},_onMetadataError:function(){this.sandbox.notify(this.i18n('metadataError'));this._onUploadComplete();}};});