(function(window,undefined){L.MarkerClusterGroup=L.FeatureGroup.extend({options:{maxClusterRadius:80,iconCreateFunction:null,spiderfyOnMaxZoom:true,showCoverageOnHover:true,zoomToBoundsOnClick:true,singleMarkerMode:false,disableClusteringAtZoom:null,skipDuplicateAddTesting:false,animateAddingMarkers:false},initialize:function(options){L.Util.setOptions(this,options);if(!this.options.iconCreateFunction){this.options.iconCreateFunction=this._defaultIconCreateFunction;}
L.FeatureGroup.prototype.initialize.call(this,[]);this._inZoomAnimation=0;this._needsClustering=[];this._currentShownBounds=null;},addLayer:function(layer){if(layer instanceof L.LayerGroup){for(var i in layer._layers){if(layer._layers.hasOwnProperty(i)){this.addLayer(layer._layers[i]);}}
return this;}
if(this.options.singleMarkerMode){layer.options.icon=this.options.iconCreateFunction({getChildCount:function(){return 1;},getAllChildMarkers:function(){return[layer];}});}
if(!this._map){this._needsClustering.push(layer);return this;}
if(!this.options.skipDuplicateAddTesting&&this.hasLayer(layer)){return this;}
if(this._unspiderfy){this._unspiderfy();}
this._addLayer(layer,this._maxZoom);var visibleLayer=layer,currentZoom=this._map.getZoom();if(layer.__parent){while(visibleLayer.__parent._zoom>=currentZoom){visibleLayer=visibleLayer.__parent;}}
if(this.options.animateAddingMarkers){this._animationAddLayer(layer,visibleLayer);}else{this._animationAddLayerNonAnimated(layer,visibleLayer);}
return this;},removeLayer:function(layer){if(!layer.__parent){return this;}
if(this._unspiderfy){this._unspiderfy();this._unspiderfyLayer(layer);}
this._removeLayer(layer,true);if(layer._icon){L.FeatureGroup.prototype.removeLayer.call(this,layer);}
return this;},clearLayers:function(){if(!this._map){this._needsClustering=[];return this;}
if(this._unspiderfy){this._unspiderfy();}
for(var i in this._layers){if(this._layers.hasOwnProperty(i)){L.FeatureGroup.prototype.removeLayer.call(this,this._layers[i]);}}
this._generateInitialClusters();return this;},hasLayer:function(layer){var res=false;this._topClusterLevel._recursively(new L.LatLngBounds([layer.getLatLng()]),0,this._map.getMaxZoom()+1,function(cluster){for(var i=cluster._markers.length-1;i>=0&&!res;i--){if(cluster._markers[i]===layer){res=true;}}},null);return res;},zoomToShowLayer:function(layer,callback){var showMarker=function(){if((layer._icon||layer.__parent._icon)&&!this._inZoomAnimation){this._map.off('moveend',showMarker,this);this.off('animationend',showMarker,this);if(layer._icon){callback();}else if(layer.__parent._icon){var afterSpiderfy=function(){this.off('spiderfied',afterSpiderfy,this);callback();};this.on('spiderfied',afterSpiderfy,this);layer.__parent.spiderfy();}}};if((layer._icon||layer.__parent._icon)&&this._map.getBounds().contains(layer.__parent._latlng)){showMarker.call(this);}else{this._map.on('moveend',showMarker,this);this.on('animationend',showMarker,this);layer.__parent.zoomToBounds();}},onAdd:function(map){L.FeatureGroup.prototype.onAdd.call(this,map);if(!this._gridClusters){this._generateInitialClusters();}
for(var i=0,l=this._needsClustering.length;i<l;i++){this._addLayer(this._needsClustering[i],this._maxZoom);}
this._needsClustering=[];this._map.on('zoomend',this._zoomEnd,this);this._map.on('moveend',this._moveEnd,this);if(this._spiderfierOnAdd){this._spiderfierOnAdd();}
this._bindEvents();this._zoom=this._map.getZoom();this._currentShownBounds=this._getExpandedVisibleBounds();this._topClusterLevel._recursivelyAddChildrenToMap(null,this._zoom,this._currentShownBounds);},onRemove:function(map){this._map.off('zoomend',this._zoomEnd,this);this._map.off('moveend',this._moveEnd,this);this._map._mapPane.className=this._map._mapPane.className.replace(' leaflet-cluster-anim','');if(this._spiderfierOnRemove){this._spiderfierOnRemove();}
L.FeatureGroup.prototype.onRemove.call(this,map);},_arraySplice:function(anArray,obj){for(var i=anArray.length-1;i>=0;i--){if(anArray[i]===obj){anArray.splice(i,1);return;}}},_removeLayer:function(marker,removeFromDistanceGrid){var gridClusters=this._gridClusters,gridUnclustered=this._gridUnclustered,map=this._map;if(removeFromDistanceGrid){for(var z=this._maxZoom;z>=0;z--){if(!gridUnclustered[z].removeObject(marker,map.project(marker.getLatLng(),z))){break;}}}
var cluster=marker.__parent,markers=cluster._markers,otherMarker;this._arraySplice(markers,marker);while(cluster){cluster._childCount--;if(cluster._zoom<0){break;}else if(removeFromDistanceGrid&&cluster._childCount<=1){otherMarker=cluster._markers[0]===marker?cluster._markers[1]:cluster._markers[0];gridClusters[cluster._zoom].removeObject(cluster,map.project(cluster._cLatLng,cluster._zoom));gridUnclustered[cluster._zoom].addObject(otherMarker,map.project(otherMarker.getLatLng(),cluster._zoom));this._arraySplice(cluster.__parent._childClusters,cluster);cluster.__parent._markers.push(otherMarker);otherMarker.__parent=cluster.__parent;if(cluster._icon){L.FeatureGroup.prototype.removeLayer.call(this,cluster);L.FeatureGroup.prototype.addLayer.call(this,otherMarker);}}else{cluster._recalculateBounds();cluster._updateIcon();}
cluster=cluster.__parent;}},_propagateEvent:function(e){if(e.target instanceof L.MarkerCluster){e.type='cluster'+e.type;}
L.FeatureGroup.prototype._propagateEvent.call(this,e);},_defaultIconCreateFunction:function(cluster){var childCount=cluster.getChildCount();var c=' marker-cluster-';if(childCount<10){c+='small';}else if(childCount<100){c+='medium';}else{c+='large';}
return new L.DivIcon({html:'<div><span>'+childCount+'</span></div>',className:'marker-cluster'+c,iconSize:new L.Point(40,40)});},_bindEvents:function(){var shownPolygon=null,map=this._map,spiderfyOnMaxZoom=this.options.spiderfyOnMaxZoom,showCoverageOnHover=this.options.showCoverageOnHover,zoomToBoundsOnClick=this.options.zoomToBoundsOnClick;if(spiderfyOnMaxZoom||zoomToBoundsOnClick){this.on('clusterclick',function(a){if(map.getMaxZoom()===map.getZoom()){if(spiderfyOnMaxZoom){a.layer.spiderfy();}}else if(zoomToBoundsOnClick){a.layer.zoomToBounds();}},this);}
if(showCoverageOnHover){this.on('clustermouseover',function(a){if(this._inZoomAnimation){return;}
if(shownPolygon){map.removeLayer(shownPolygon);}
if(a.layer.getChildCount()>2){shownPolygon=new L.Polygon(a.layer.getConvexHull());map.addLayer(shownPolygon);}},this);this.on('clustermouseout',function(){if(shownPolygon){map.removeLayer(shownPolygon);shownPolygon=null;}},this);map.on('zoomend',function(){if(shownPolygon){map.removeLayer(shownPolygon);shownPolygon=null;}},this);map.on('layerremove',function(opt){if(shownPolygon&&opt.layer===this){map.removeLayer(shownPolygon);shownPolygon=null;}},this);}},_zoomEnd:function(){if(!this._map){return;}
this._mergeSplitClusters();this._zoom=this._map._zoom;this._currentShownBounds=this._getExpandedVisibleBounds();},_moveEnd:function(){if(this._inZoomAnimation){return;}
var newBounds=this._getExpandedVisibleBounds();this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,this._zoom,newBounds);this._topClusterLevel._recursivelyAddChildrenToMap(null,this._zoom,newBounds);this._currentShownBounds=newBounds;return;},_generateInitialClusters:function(){var maxZoom=this._map.getMaxZoom(),radius=this.options.maxClusterRadius;if(this.options.disableClusteringAtZoom){maxZoom=this.options.disableClusteringAtZoom-1;}
this._maxZoom=maxZoom;this._gridClusters={};this._gridUnclustered={};for(var zoom=maxZoom;zoom>=0;zoom--){this._gridClusters[zoom]=new L.DistanceGrid(radius);this._gridUnclustered[zoom]=new L.DistanceGrid(radius);}
this._topClusterLevel=new L.MarkerCluster(this,-1);},_addLayer:function(layer,zoom){var gridClusters=this._gridClusters,gridUnclustered=this._gridUnclustered,markerPoint,z;for(;zoom>=0;zoom--){markerPoint=this._map.project(layer.getLatLng(),zoom);var closest=gridClusters[zoom].getNearObject(markerPoint);if(closest){closest._addChild(layer);layer.__parent=closest;return;}
closest=gridUnclustered[zoom].getNearObject(markerPoint);if(closest){if(closest.__parent){this._removeLayer(closest,false);}
var parent=closest.__parent||this._topClusterLevel;var newCluster=new L.MarkerCluster(this,zoom,closest,layer);gridClusters[zoom].addObject(newCluster,this._map.project(newCluster._cLatLng,zoom));closest.__parent=newCluster;layer.__parent=newCluster;var lastParent=newCluster;for(z=zoom-1;z>parent._zoom;z--){lastParent=new L.MarkerCluster(this,z,lastParent);gridClusters[z].addObject(lastParent,this._map.project(closest.getLatLng(),z));}
parent._addChild(lastParent);for(z=zoom;z>=0;z--){if(!gridUnclustered[z].removeObject(closest,this._map.project(closest.getLatLng(),z))){break;}}
return;}
gridUnclustered[zoom].addObject(layer,markerPoint);}
return;},_mergeSplitClusters:function(){if(this._zoom<this._map._zoom){this._animationStart();this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,this._zoom,this._getExpandedVisibleBounds());this._animationZoomIn(this._zoom,this._map._zoom);}else if(this._zoom>this._map._zoom){this._animationStart();this._animationZoomOut(this._zoom,this._map._zoom);}else{this._moveEnd();}},_getExpandedVisibleBounds:function(){var map=this._map,bounds=map.getPixelBounds(),width=L.Browser.mobile?0:Math.abs(bounds.max.x-bounds.min.x),height=L.Browser.mobile?0:Math.abs(bounds.max.y-bounds.min.y),sw=map.unproject(new L.Point(bounds.min.x-width,bounds.min.y-height)),ne=map.unproject(new L.Point(bounds.max.x+width,bounds.max.y+height));return new L.LatLngBounds(sw,ne);},_animationAddLayerNonAnimated:function(layer,newCluster){if(newCluster===layer){L.FeatureGroup.prototype.addLayer.call(this,layer);}else if(newCluster._childCount===2){newCluster._addToMap();var markers=newCluster.getAllChildMarkers();L.FeatureGroup.prototype.removeLayer.call(this,markers[0]);L.FeatureGroup.prototype.removeLayer.call(this,markers[1]);}else{newCluster._updateIcon();}}});L.MarkerClusterGroup.include(!L.DomUtil.TRANSITION?{_animationStart:function(){},_animationZoomIn:function(previousZoomLevel,newZoomLevel){this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,previousZoomLevel);this._topClusterLevel._recursivelyAddChildrenToMap(null,newZoomLevel,this._getExpandedVisibleBounds());},_animationZoomOut:function(previousZoomLevel,newZoomLevel){this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds,previousZoomLevel);this._topClusterLevel._recursivelyAddChildrenToMap(null,newZoomLevel,this._getExpandedVisibleBounds());},_animationAddLayer:function(layer,newCluster){this._animationAddLayerNonAnimated(layer,newCluster);}}:{_animationStart:function(){this._map._mapPane.className+=' leaflet-cluster-anim';this._inZoomAnimation++;},_animationEnd:function(){if(this._map){this._map._mapPane.className=this._map._mapPane.className.replace(' leaflet-cluster-anim','');}
this._inZoomAnimation--;this.fire('animationend');},_animationZoomIn:function(previousZoomLevel,newZoomLevel){var me=this,bounds=this._getExpandedVisibleBounds(),i;this._topClusterLevel._recursively(bounds,previousZoomLevel,0,function(c){var startPos=c._latlng,markers=c._markers,m;if(c._isSingleParent()&&previousZoomLevel+1===newZoomLevel){L.FeatureGroup.prototype.removeLayer.call(me,c);c._recursivelyAddChildrenToMap(null,newZoomLevel,bounds);}else{c.setOpacity(0);c._recursivelyAddChildrenToMap(startPos,newZoomLevel,bounds);}
for(i=markers.length-1;i>=0;i--){m=markers[i];if(!bounds.contains(m._latlng)){L.FeatureGroup.prototype.removeLayer.call(me,m);}}});this._forceLayout();var j,n;me._topClusterLevel._recursivelyBecomeVisible(bounds,newZoomLevel);for(j in me._layers){if(me._layers.hasOwnProperty(j)){n=me._layers[j];if(!(n instanceof L.MarkerCluster)&&n._icon){n.setOpacity(1);}}}
me._topClusterLevel._recursively(bounds,previousZoomLevel,newZoomLevel,function(c){c._recursivelyRestoreChildPositions(newZoomLevel);});setTimeout(function(){me._topClusterLevel._recursively(bounds,previousZoomLevel,0,function(c){L.FeatureGroup.prototype.removeLayer.call(me,c);});me._animationEnd();},250);},_animationZoomOut:function(previousZoomLevel,newZoomLevel){this._animationZoomOutSingle(this._topClusterLevel,previousZoomLevel,newZoomLevel);this._topClusterLevel._recursivelyAddChildrenToMap(null,newZoomLevel,this._getExpandedVisibleBounds());},_animationZoomOutSingle:function(marker,previousZoomLevel,newZoomLevel){var bounds=this._getExpandedVisibleBounds();marker._recursivelyAnimateChildrenInAndAddSelfToMap(bounds,previousZoomLevel,newZoomLevel);var me=this;this._forceLayout();marker._recursivelyBecomeVisible(bounds,newZoomLevel);setTimeout(function(){marker._recursively(bounds,newZoomLevel,0,function(c){c._recursivelyRemoveChildrenFromMap(bounds,previousZoomLevel);});me._animationEnd();},250);},_animationAddLayer:function(layer,newCluster){var me=this;L.FeatureGroup.prototype.addLayer.call(this,layer);if(newCluster!==layer){if(newCluster._childCount>2){newCluster._updateIcon();this._forceLayout();this._animationStart();layer._setPos(this._map.latLngToLayerPoint(newCluster.getLatLng()));layer.setOpacity(0);setTimeout(function(){L.FeatureGroup.prototype.removeLayer.call(me,layer);layer.setOpacity(1);me._animationEnd();},250);}else{this._forceLayout();me._animationStart();me._animationZoomOutSingle(newCluster,this._map.getMaxZoom(),this._map.getZoom());}}},_forceLayout:function(){L.Util.falseFn(document.body.offsetWidth);}});L.MarkerCluster=L.Marker.extend({initialize:function(group,zoom,a,b){L.Marker.prototype.initialize.call(this,a?(a._cLatLng||a.getLatLng()):new L.LatLng(0,0),{icon:this});this._group=group;this._zoom=zoom;this._markers=[];this._childClusters=[];this._childCount=0;this._iconNeedsUpdate=true;this._bounds=new L.LatLngBounds();if(a){this._addChild(a);}
if(b){this._addChild(b);}},getAllChildMarkers:function(storageArray){storageArray=storageArray||[];for(var i=this._childClusters.length-1;i>=0;i--){this._childClusters[i].getAllChildMarkers(storageArray);}
for(var j=this._markers.length-1;j>=0;j--){storageArray.push(this._markers[j]);}
return storageArray;},getChildCount:function(){return this._childCount;},zoomToBounds:function(){this._group._map.fitBounds(this._bounds);},_updateIcon:function(){this._iconNeedsUpdate=true;if(this._icon){this.setIcon(this);}},createIcon:function(){if(this._iconNeedsUpdate){this._iconObj=this._group.options.iconCreateFunction(this);this._iconNeedsUpdate=false;}
return this._iconObj.createIcon();},createShadow:function(){return this._iconObj.createShadow();},_addChild:function(new1,isNotificationFromChild){this._iconNeedsUpdate=true;this._expandBounds(new1);if(new1 instanceof L.MarkerCluster){if(!isNotificationFromChild){this._childClusters.push(new1);new1.__parent=this;}
this._childCount+=new1._childCount;}else{if(!isNotificationFromChild){this._markers.push(new1);}
this._childCount++;}
if(this.__parent){this.__parent._addChild(new1,true);}},_expandBounds:function(marker){var addedCount,addedLatLng=marker._wLatLng||marker._latlng;if(marker instanceof L.MarkerCluster){this._bounds.extend(marker._bounds);addedCount=marker._childCount;}else{this._bounds.extend(addedLatLng);addedCount=1;}
if(!this._cLatLng){this._cLatLng=marker._cLatLng||addedLatLng;}
var totalCount=this._childCount+addedCount;if(!this._wLatLng){this._latlng=this._wLatLng=new L.LatLng(addedLatLng.lat,addedLatLng.lng);}else{this._wLatLng.lat=(addedLatLng.lat*addedCount+this._wLatLng.lat*this._childCount)/totalCount;this._wLatLng.lng=(addedLatLng.lng*addedCount+this._wLatLng.lng*this._childCount)/totalCount;}},_addToMap:function(startPos){if(startPos){this._backupLatlng=this._latlng;this.setLatLng(startPos);}
L.FeatureGroup.prototype.addLayer.call(this._group,this);},_recursivelyAnimateChildrenIn:function(bounds,center,depth){this._recursively(bounds,0,depth-1,function(c){var markers=c._markers,i,m;for(i=markers.length-1;i>=0;i--){m=markers[i];if(m._icon){m._setPos(center);m.setOpacity(0);}}},function(c){var childClusters=c._childClusters,j,cm;for(j=childClusters.length-1;j>=0;j--){cm=childClusters[j];if(cm._icon){cm._setPos(center);cm.setOpacity(0);}}});},_recursivelyAnimateChildrenInAndAddSelfToMap:function(bounds,previousZoomLevel,newZoomLevel){this._recursively(bounds,newZoomLevel,0,function(c){c._recursivelyAnimateChildrenIn(bounds,c._group._map.latLngToLayerPoint(c.getLatLng()).round(),previousZoomLevel);if(c._isSingleParent()&&previousZoomLevel-1===newZoomLevel){c.setOpacity(1);c._recursivelyRemoveChildrenFromMap(bounds,previousZoomLevel);}else{c.setOpacity(0);}
c._addToMap();});},_recursivelyBecomeVisible:function(bounds,zoomLevel){this._recursively(bounds,0,zoomLevel,null,function(c){c.setOpacity(1);});},_recursivelyAddChildrenToMap:function(startPos,zoomLevel,bounds){this._recursively(bounds,0,zoomLevel,function(c){if(zoomLevel===c._zoom){return;}
for(var i=c._markers.length-1;i>=0;i--){var nm=c._markers[i];if(!bounds.contains(nm._latlng)){continue;}
if(startPos){nm._backupLatlng=nm.getLatLng();nm.setLatLng(startPos);nm.setOpacity(0);}
L.FeatureGroup.prototype.addLayer.call(c._group,nm);}},function(c){c._addToMap(startPos);});},_recursivelyRestoreChildPositions:function(zoomLevel){for(var i=this._markers.length-1;i>=0;i--){var nm=this._markers[i];if(nm._backupLatlng){nm.setLatLng(nm._backupLatlng);delete nm._backupLatlng;}}
if(zoomLevel-1===this._zoom){for(var j=this._childClusters.length-1;j>=0;j--){this._childClusters[j]._restorePosition();}}else{for(var k=this._childClusters.length-1;k>=0;k--){this._childClusters[k]._recursivelyRestoreChildPositions(zoomLevel);}}},_restorePosition:function(){if(this._backupLatlng){this.setLatLng(this._backupLatlng);delete this._backupLatlng;}},_recursivelyRemoveChildrenFromMap:function(previousBounds,zoomLevel,exceptBounds){var m,i;this._recursively(previousBounds,-1,zoomLevel-1,function(c){for(i=c._markers.length-1;i>=0;i--){m=c._markers[i];if(!exceptBounds||!exceptBounds.contains(m._latlng)){L.FeatureGroup.prototype.removeLayer.call(c._group,m);m.setOpacity(1);}}},function(c){for(i=c._childClusters.length-1;i>=0;i--){m=c._childClusters[i];if(!exceptBounds||!exceptBounds.contains(m._latlng)){L.FeatureGroup.prototype.removeLayer.call(c._group,m);m.setOpacity(1);}}});},_recursively:function(boundsToApplyTo,zoomLevelToStart,zoomLevelToStop,runAtEveryLevel,runAtBottomLevel){var childClusters=this._childClusters,zoom=this._zoom,i,c;if(zoomLevelToStart>zoom){for(i=childClusters.length-1;i>=0;i--){c=childClusters[i];if(boundsToApplyTo.intersects(c._bounds)){c._recursively(boundsToApplyTo,zoomLevelToStart,zoomLevelToStop,runAtEveryLevel,runAtBottomLevel);}}}else{if(runAtEveryLevel){runAtEveryLevel(this);}
if(runAtBottomLevel&&this._zoom===zoomLevelToStop){runAtBottomLevel(this);}
if(zoomLevelToStop>zoom){for(i=childClusters.length-1;i>=0;i--){c=childClusters[i];if(boundsToApplyTo.intersects(c._bounds)){c._recursively(boundsToApplyTo,zoomLevelToStart,zoomLevelToStop,runAtEveryLevel,runAtBottomLevel);}}}}},_recalculateBounds:function(){var markers=this._markers,childClusters=this._childClusters,i;this._bounds=new L.LatLngBounds();delete this._wLatLng;for(i=markers.length-1;i>=0;i--){this._expandBounds(markers[i]);}
for(i=childClusters.length-1;i>=0;i--){this._expandBounds(childClusters[i]);}},_isSingleParent:function(){return this._childClusters.length>0&&this._childClusters[0]._childCount===this._childCount;}});L.DistanceGrid=function(cellSize){this._cellSize=cellSize;this._sqCellSize=cellSize*cellSize;this._grid={};this._objectPoint={};};L.DistanceGrid.prototype={addObject:function(obj,point){var x=this._getCoord(point.x),y=this._getCoord(point.y),grid=this._grid,row=grid[y]=grid[y]||{},cell=row[x]=row[x]||[],stamp=L.Util.stamp(obj);this._objectPoint[stamp]=point;cell.push(obj);},updateObject:function(obj,point){this.removeObject(obj);this.addObject(obj,point);},removeObject:function(obj,point){var x=this._getCoord(point.x),y=this._getCoord(point.y),grid=this._grid,row=grid[y]=grid[y]||{},cell=row[x]=row[x]||[],i,len;delete this._objectPoint[L.Util.stamp(obj)];for(i=0,len=cell.length;i<len;i++){if(cell[i]===obj){cell.splice(i,1);if(len===1){delete row[x];}
return true;}}},eachObject:function(fn,context){var i,j,k,len,row,cell,removed,grid=this._grid;for(i in grid){if(grid.hasOwnProperty(i)){row=grid[i];for(j in row){if(row.hasOwnProperty(j)){cell=row[j];for(k=0,len=cell.length;k<len;k++){removed=fn.call(context,cell[k]);if(removed){k--;len--;}}}}}}},getNearObject:function(point){var x=this._getCoord(point.x),y=this._getCoord(point.y),i,j,k,row,cell,len,obj,dist,objectPoint=this._objectPoint,closestDistSq=this._sqCellSize,closest=null;for(i=y-1;i<=y+1;i++){row=this._grid[i];if(row){for(j=x-1;j<=x+1;j++){cell=row[j];if(cell){for(k=0,len=cell.length;k<len;k++){obj=cell[k];dist=this._sqDist(objectPoint[L.Util.stamp(obj)],point);if(dist<closestDistSq){closestDistSq=dist;closest=obj;}}}}}}
return closest;},_getCoord:function(x){return Math.floor(x/this._cellSize);},_sqDist:function(p,p2){var dx=p2.x-p.x,dy=p2.y-p.y;return dx*dx+dy*dy;}};(function(){L.QuickHull={getDistant:function(cpt,bl){var vY=bl[1].lat-bl[0].lat,vX=bl[0].lng-bl[1].lng;return(vX*(cpt.lat-bl[0].lat)+vY*(cpt.lng-bl[0].lng));},findMostDistantPointFromBaseLine:function(baseLine,latLngs){var maxD=0,maxPt=null,newPoints=[],i,pt,d;for(i=latLngs.length-1;i>=0;i--){pt=latLngs[i];d=this.getDistant(pt,baseLine);if(d>0){newPoints.push(pt);}else{continue;}
if(d>maxD){maxD=d;maxPt=pt;}}
return{'maxPoint':maxPt,'newPoints':newPoints};},buildConvexHull:function(baseLine,latLngs){var convexHullBaseLines=[],t=this.findMostDistantPointFromBaseLine(baseLine,latLngs);if(t.maxPoint){convexHullBaseLines=convexHullBaseLines.concat(this.buildConvexHull([baseLine[0],t.maxPoint],t.newPoints));convexHullBaseLines=convexHullBaseLines.concat(this.buildConvexHull([t.maxPoint,baseLine[1]],t.newPoints));return convexHullBaseLines;}else{return[baseLine];}},getConvexHull:function(latLngs){var maxLat=false,minLat=false,maxPt=null,minPt=null,i;for(i=latLngs.length-1;i>=0;i--){var pt=latLngs[i];if(maxLat===false||pt.lat>maxLat){maxPt=pt;maxLat=pt.lat;}
if(minLat===false||pt.lat<minLat){minPt=pt;minLat=pt.lat;}}
var ch=[].concat(this.buildConvexHull([minPt,maxPt],latLngs),this.buildConvexHull([maxPt,minPt],latLngs));return ch;}};}());L.MarkerCluster.include({getConvexHull:function(){var childMarkers=this.getAllChildMarkers(),points=[],hullLatLng=[],hull,p,i;for(i=childMarkers.length-1;i>=0;i--){p=childMarkers[i].getLatLng();points.push(p);}
hull=L.QuickHull.getConvexHull(points);for(i=hull.length-1;i>=0;i--){hullLatLng.push(hull[i][0]);}
return hullLatLng;}});L.MarkerCluster.include({_2PI:Math.PI*2,_circleFootSeparation:25,_circleStartAngle:Math.PI/6,_spiralFootSeparation:28,_spiralLengthStart:11,_spiralLengthFactor:5,_circleSpiralSwitchover:9,spiderfy:function(){if(this._group._spiderfied===this||this._group._inZoomAnimation){return;}
var childMarkers=this.getAllChildMarkers(),group=this._group,map=group._map,center=map.latLngToLayerPoint(this._latlng),positions;this._group._unspiderfy();this._group._spiderfied=this;if(childMarkers.length>=this._circleSpiralSwitchover){positions=this._generatePointsSpiral(childMarkers.length,center);}else{center.y+=10;positions=this._generatePointsCircle(childMarkers.length,center);}
this._animationSpiderfy(childMarkers,positions);},unspiderfy:function(zoomDetails){if(this._group._inZoomAnimation){return;}
this._animationUnspiderfy(zoomDetails);this._group._spiderfied=null;},_generatePointsCircle:function(count,centerPt){var circumference=this._circleFootSeparation*(2+count),legLength=circumference/this._2PI,angleStep=this._2PI/count,res=[],i,angle;res.length=count;for(i=count-1;i>=0;i--){angle=this._circleStartAngle+i*angleStep;res[i]=new L.Point(centerPt.x+legLength*Math.cos(angle),centerPt.y+legLength*Math.sin(angle))._round();}
return res;},_generatePointsSpiral:function(count,centerPt){var legLength=this._spiralLengthStart,angle=0,res=[],i;res.length=count;for(i=count-1;i>=0;i--){angle+=this._spiralFootSeparation/legLength+i*0.0005;res[i]=new L.Point(centerPt.x+legLength*Math.cos(angle),centerPt.y+legLength*Math.sin(angle))._round();legLength+=this._2PI*this._spiralLengthFactor/angle;}
return res;}});L.MarkerCluster.include(!L.DomUtil.TRANSITION?{_animationSpiderfy:function(childMarkers,positions){var group=this._group,map=group._map,i,m,leg,newPos;for(i=childMarkers.length-1;i>=0;i--){newPos=map.layerPointToLatLng(positions[i]);m=childMarkers[i];m._preSpiderfyLatlng=m._latlng;m.setLatLng(newPos);m.setZIndexOffset(1000000);L.FeatureGroup.prototype.addLayer.call(group,m);leg=new L.Polyline([this._latlng,newPos],{weight:1.5,color:'#222'});map.addLayer(leg);m._spiderLeg=leg;}
this.setOpacity(0.3);group.fire('spiderfied');},_animationUnspiderfy:function(){var group=this._group,map=group._map,childMarkers=this.getAllChildMarkers(),m,i;this.setOpacity(1);for(i=childMarkers.length-1;i>=0;i--){m=childMarkers[i];L.FeatureGroup.prototype.removeLayer.call(group,m);m.setLatLng(m._preSpiderfyLatlng);delete m._preSpiderfyLatlng;m.setZIndexOffset(0);map.removeLayer(m._spiderLeg);delete m._spiderLeg;}}}:{_animationSpiderfy:function(childMarkers,positions){var me=this,group=this._group,map=group._map,thisLayerPos=map.latLngToLayerPoint(this._latlng),i,m,leg,newPos;for(i=childMarkers.length-1;i>=0;i--){m=childMarkers[i];m.setZIndexOffset(1000000);m.setOpacity(0);L.FeatureGroup.prototype.addLayer.call(group,m);m._setPos(thisLayerPos);}
group._forceLayout();group._animationStart();var initialLegOpacity=L.Browser.svg?0:0.3,xmlns=L.Path.SVG_NS;for(i=childMarkers.length-1;i>=0;i--){newPos=map.layerPointToLatLng(positions[i]);m=childMarkers[i];m._preSpiderfyLatlng=m._latlng;m.setLatLng(newPos);m.setOpacity(1);leg=new L.Polyline([me._latlng,newPos],{weight:1.5,color:'#222',opacity:initialLegOpacity});map.addLayer(leg);m._spiderLeg=leg;if(!L.Browser.svg){continue;}
var length=leg._path.getTotalLength();leg._path.setAttribute("stroke-dasharray",length+","+length);var anim=document.createElementNS(xmlns,"animate");anim.setAttribute("attributeName","stroke-dashoffset");anim.setAttribute("begin","indefinite");anim.setAttribute("from",length);anim.setAttribute("to",0);anim.setAttribute("dur",0.25);leg._path.appendChild(anim);anim.beginElement();anim=document.createElementNS(xmlns,"animate");anim.setAttribute("attributeName","stroke-opacity");anim.setAttribute("attributeName","stroke-opacity");anim.setAttribute("begin","indefinite");anim.setAttribute("from",0);anim.setAttribute("to",0.5);anim.setAttribute("dur",0.25);leg._path.appendChild(anim);anim.beginElement();}
me.setOpacity(0.3);if(L.Browser.svg){this._group._forceLayout();for(i=childMarkers.length-1;i>=0;i--){m=childMarkers[i]._spiderLeg;m.options.opacity=0.5;m._path.setAttribute('stroke-opacity',0.5);}}
setTimeout(function(){group._animationEnd();group.fire('spiderfied');},250);},_animationUnspiderfy:function(zoomDetails){var group=this._group,map=group._map,thisLayerPos=zoomDetails?map._latLngToNewLayerPoint(this._latlng,zoomDetails.zoom,zoomDetails.center):map.latLngToLayerPoint(this._latlng),childMarkers=this.getAllChildMarkers(),svg=L.Browser.svg,m,i,a;group._animationStart();this.setOpacity(1);for(i=childMarkers.length-1;i>=0;i--){m=childMarkers[i];m.setLatLng(m._preSpiderfyLatlng);delete m._preSpiderfyLatlng;m._setPos(thisLayerPos);m.setOpacity(0);if(svg){a=m._spiderLeg._path.childNodes[0];a.setAttribute('to',a.getAttribute('from'));a.setAttribute('from',0);a.beginElement();a=m._spiderLeg._path.childNodes[1];a.setAttribute('from',0.5);a.setAttribute('to',0);a.setAttribute('stroke-opacity',0);a.beginElement();m._spiderLeg._path.setAttribute('stroke-opacity',0);}}
setTimeout(function(){var stillThereChildCount=0;for(i=childMarkers.length-1;i>=0;i--){m=childMarkers[i];if(m._spiderLeg){stillThereChildCount++;}}
for(i=childMarkers.length-1;i>=0;i--){m=childMarkers[i];if(!m._spiderLeg){continue;}
m.setOpacity(1);m.setZIndexOffset(0);if(stillThereChildCount>1){L.FeatureGroup.prototype.removeLayer.call(group,m);}
map.removeLayer(m._spiderLeg);delete m._spiderLeg;}
group._animationEnd();},250);}});L.MarkerClusterGroup.include({_spiderfied:null,_spiderfierOnAdd:function(){this._map.on('click',this._unspiderfyWrapper,this);if(this._map.options.zoomAnimation){this._map.on('zoomstart',this._unspiderfyZoomStart,this);}else{this._map.on('zoomend',this._unspiderfyWrapper,this);}
if(L.Browser.svg&&!L.Browser.touch){this._map._initPathRoot();}},_spiderfierOnRemove:function(){this._map.off('click',this._unspiderfyWrapper,this);this._map.off('zoomstart',this._unspiderfyZoomStart,this);this._map.off('zoomanim',this._unspiderfyZoomAnim,this);this._unspiderfy();},_unspiderfyZoomStart:function(){if(!this._map){return;}
this._map.on('zoomanim',this._unspiderfyZoomAnim,this);},_unspiderfyZoomAnim:function(zoomDetails){if(L.DomUtil.hasClass(this._map._mapPane,'leaflet-touching')){return;}
this._map.off('zoomanim',this._unspiderfyZoomAnim,this);this._unspiderfy(zoomDetails);},_unspiderfyWrapper:function(){this._unspiderfy();},_unspiderfy:function(zoomDetails){if(this._spiderfied){this._spiderfied.unspiderfy(zoomDetails);}},_unspiderfyLayer:function(layer){if(layer._spiderLeg){L.FeatureGroup.prototype.removeLayer.call(this,layer);layer.setOpacity(1);layer.setZIndexOffset(0);this._map.removeLayer(layer._spiderLeg);delete layer._spiderLeg;}}});}(this));