c
c
c     ==================================================================
      subroutine flux3(ixyz,maxm,meqn,maux,       mbc,mx,
     &                 q1d,dtdx1d,dtdy,dtdz,aux1,aux2,aux3,
     &                 faddm,faddp,gadd,hadd,cfl1d,
     &                 fwave,s,amdq,apdq,cqxx,
     &                 bmamdq,bmapdq,bpamdq,bpapdq,
     &                 cmamdq,cmapdq,cpamdq,cpapdq,
     &                 cmamdq2,cmapdq2,cpamdq2,cpapdq2,
     &                 bmcqxxm,bmcqxxp,bpcqxxm,bpcqxxp,
     &                 cmcqxxm,cmcqxxp,cpcqxxm,cpcqxxp,
     &                 bmcmamdq,bmcmapdq,bpcmamdq,bpcmapdq,
     &                 bmcpamdq,bmcpapdq,bpcpamdq,bpcpapdq,
     &                 rpn3,rpt3, rptt3)
c     ==================================================================
c
c     # clawpack routine ...  modified for AMRCLAW
c
c--------------------------------------------------------------------
c     # flux3fw is a modified version of flux3 to use fwave instead of wave.
c     # A modified Riemann solver rp3n must be used in conjunction with this
c     # routine, which returns fwave's instead of wave's.
c     # See http://amath.washington.edu/~claw/fwave.html
c
c     # Limiters are applied to the fwave's, and the only significant
c     # modification of this code is in the "do 119" loop, for the
c     # second order corrections.
c
c--------------------------------------------------------------------

c
c     # Compute the modification to fluxes f, g and h that are generated by
c     # all interfaces along a 1D slice of the 3D grid.
c     #    ixyz = 1  if it is a slice in x
c     #           2  if it is a slice in y
c     #           3  if it is a slice in z
c     # This value is passed into the Riemann solvers. The flux modifications
c     # go into the arrays fadd, gadd and hadd.  The notation is written
c     # assuming we are solving along a 1D slice in the x-direction.
c
c     # fadd(i,.) modifies F to the left of cell i
c     # gadd(i,.,1,slice) modifies G below cell i (in the z-direction)
c     # gadd(i,.,2,slice) modifies G above cell i
c     #                   The G flux in the surrounding slices may
c     #                   also be updated.
c     #                   slice  =  -1     The slice below in y-direction
c     #                   slice  =   0     The slice used in the 2D method
c     #                   slice  =   1     The slice above in y-direction
c     # hadd(i,.,1,slice) modifies H below cell i (in the y-direction)
c     # hadd(i,.,2,slice) modifies H above cell i
c     #                   The H flux in the surrounding slices may
c     #                   also be updated.
c     #                   slice  =  -1     The slice below in z-direction
c     #                   slice  =   0     The slice used in the 2D method
c     #                   slice  =   1     The slice above in z-direction
c     #
c     # The method used is specified by method(2) and method(3):
c
c        method(2) = 1 No correction waves
c                  = 2 if second order correction terms are to be added, with
c                      a flux limiter as specified by mthlim.  No transverse
c                      propagation of these waves.
c
c         method(3) specify how the transverse wave propagation
c         of the increment wave and the correction wave are performed.
c         Note that method(3) is given by a two digit number, in
c         contrast to what is the case for claw2. It is convenient
c         to define the scheme using the pair (method(2),method(3)).
c
c         method(3) <  0 Gives dimensional splitting using Godunov
c                        splitting, i.e. formally first order
c                        accurate.
c                      0 Gives the Donor cell method. No transverse
c                        propagation of neither the increment wave
c                        nor the correction wave.
c                   = 10 Transverse propagation of the increment wave
c                        as in 2D. Note that method (2,10) is
c                        unconditionally unstable.
c                   = 11 Corner transport upwind of the increment
c                        wave. Note that method (2,11) also is
c                        unconditionally unstable.
c                   = 20 Both the increment wave and the correction
c                        wave propagate as in the 2D case. Only to
c                        be used with method(2) = 2.
c                   = 21 Corner transport upwind of the increment wave,
c                        and the correction wave propagates as in 2D.
c                        Only to be used with method(2) = 2.
c                   = 22 3D propagation of both the increment wave and
c                        the correction wave. Only to be used with
c                        method(2) = 2.
c
c         Recommended settings:   First order schemes:
c                                       (1,10) Stable for CFL < 1/2
c                                       (1,11) Stable for CFL < 1
c                                 Second order schemes:
c                                        (2,20) Stable for CFL < 1/2
c                                        (2,22) Stable for CFL < 1
c
c         WARNING! The schemes (2,10), (2,11) are unconditionally
c                  unstable.
c
c                       ----------------------------------
c
c     Note that if method(6)=1 then the capa array comes into the second
c     order correction terms, and is already included in dtdx1d:
c     If ixyz = 1 then
c        dtdx1d(i) = dt/dx                      if method(6) = 0
c                  = dt/(dx*capa(i,jcom,kcom))  if method(6) = 1
c     If ixyz = 2 then
c        dtdx1d(j) = dt/dy                      if method(6) = 0
c                  = dt/(dy*capa(icom,j,kcom))  if method(6) = 1
c     If ixyz = 3 then
c        dtdx1d(k) = dt/dz                      if method(6) = 0
c                  = dt/(dz*capa(icom,jcom,k))  if method(6) = 1
c
c     Notation:
c        The jump in q (q1d(i,:)-q1d(i-1,:))  is split by rpn3 into
c            amdq =  the left-going flux difference  A^- Delta q
c            apdq = the right-going flux difference  A^+ Delta q
c        Each of these is split by rpt3 into
c            bmasdq = the down-going transverse flux difference B^- A^* Delta q
c            bpasdq =   the up-going transverse flux difference B^+ A^* Delta q
c        where A^* represents either A^- or A^+.
c
c        Finally, each bsasdq is split by rptt3 into :
c            cmbsasdq = C^- B^* A^* Dq
c            cpbsasdq = C^+ B^* A^* Dq
c
c
      use amr_module
      implicit double precision(a-h,o-z)

      external rpn3,rpt3, rptt3

      dimension     q1d(1-mbc:maxm+mbc, meqn)
      dimension    amdq(1-mbc:maxm+mbc, meqn)
      dimension    apdq(1-mbc:maxm+mbc, meqn)
      dimension  bmamdq(1-mbc:maxm+mbc, meqn)
      dimension  bmapdq(1-mbc:maxm+mbc, meqn)
      dimension  bpamdq(1-mbc:maxm+mbc, meqn)
      dimension  bpapdq(1-mbc:maxm+mbc, meqn)
      dimension   cqxx(1-mbc:maxm+mbc, meqn)
      dimension   faddm(1-mbc:maxm+mbc, meqn)
      dimension   faddp(1-mbc:maxm+mbc, meqn)
      dimension   gadd(1-mbc:maxm+mbc, meqn, 2, -1:1)
      dimension   hadd(1-mbc:maxm+mbc, meqn, 2, -1:1)
c
      dimension  cmamdq(1-mbc:maxm+mbc, meqn)
      dimension  cmapdq(1-mbc:maxm+mbc, meqn)
      dimension  cpamdq(1-mbc:maxm+mbc, meqn)
      dimension  cpapdq(1-mbc:maxm+mbc, meqn)
c
      dimension  cmamdq2(1-mbc:maxm+mbc, meqn)
      dimension  cmapdq2(1-mbc:maxm+mbc, meqn)
      dimension  cpamdq2(1-mbc:maxm+mbc, meqn)
      dimension  cpapdq2(1-mbc:maxm+mbc, meqn)
c
      dimension  bmcqxxm(1-mbc:maxm+mbc, meqn)
      dimension  bpcqxxm(1-mbc:maxm+mbc, meqn)
      dimension  bmcqxxp(1-mbc:maxm+mbc, meqn)
      dimension  bpcqxxp(1-mbc:maxm+mbc, meqn)
c
      dimension  cmcqxxm(1-mbc:maxm+mbc, meqn)
      dimension  cpcqxxm(1-mbc:maxm+mbc, meqn)
      dimension  cmcqxxp(1-mbc:maxm+mbc, meqn)
      dimension  cpcqxxp(1-mbc:maxm+mbc, meqn)

      dimension  bpcmamdq(1-mbc:maxm+mbc, meqn)
      dimension  bpcmapdq(1-mbc:maxm+mbc, meqn)
      dimension  bpcpamdq(1-mbc:maxm+mbc, meqn)
      dimension  bpcpapdq(1-mbc:maxm+mbc, meqn)
      dimension  bmcmamdq(1-mbc:maxm+mbc, meqn)
      dimension  bmcmapdq(1-mbc:maxm+mbc, meqn)
      dimension  bmcpamdq(1-mbc:maxm+mbc, meqn)
      dimension  bmcpapdq(1-mbc:maxm+mbc, meqn)
c
      dimension dtdx1d(1-mbc:maxm+mbc)
      dimension aux1(1-mbc:maxm+mbc, maux, 3)
      dimension aux2(1-mbc:maxm+mbc, maux, 3)
      dimension aux3(1-mbc:maxm+mbc, maux, 3)
c
      dimension    s(1-mbc:maxm+mbc, mwaves)
      dimension  fwave(1-mbc:maxm+mbc, meqn, mwaves)
c
      logical limit
      common/comxyzt/dtcom,dxcom,dycom,dzcom,tcom,icom,jcom,kcom



      limit = .false.
      do 5 mw=1,mwaves
	 if (mthlim(mw) .gt. 0) limit = .true.
   5     continue
c
c     # initialize flux increments:
c     -----------------------------
c
      do 10 m=1,meqn
	 do 10 i = 1-mbc, mx+mbc
	    faddm(i,m) = 0.d0
	    faddp(i,m) = 0.d0
	    gadd(i,m,1,-1) = 0.d0
            gadd(i,m,1, 0) = 0.d0
	    gadd(i,m,1, 1) = 0.d0
	    hadd(i,m,1,-1) = 0.d0
	    hadd(i,m,1, 0) = 0.d0
	    hadd(i,m,1, 1) = 0.d0
            gadd(i,m,2,-1) = 0.d0
	    gadd(i,m,2, 0) = 0.d0
	    gadd(i,m,2, 1) = 0.d0
	    hadd(i,m,2,-1) = 0.d0
	    hadd(i,m,2, 0) = 0.d0
	    hadd(i,m,2, 1) = 0.d0
   10    continue
c
c     # local method parameters
      if (method(3) .lt. 0) then
         m3 = -1
         m4 = 0
      else
         m3 = method(3)/10
         m4 = method(3) - 10*m3
      endif
c
c     -----------------------------------------------------------
c     # solve normal Riemann problem and compute Godunov updates
c     -----------------------------------------------------------
c
c     # aux2(1-mbc,1,2) is the start of a 1d array now used by rpn3
c
      call rpn3(ixyz,maxm,meqn,mwaves,maux,mbc,mx,q1d,q1d,
     &      aux2(1-mbc,1,2),aux2(1-mbc,1,2),
     &      fwave,s,amdq,apdq)
c
c     # Set fadd for the donor-cell upwind method (Godunov)
      do 40 i=1,mx+1
         do 40 m=1,meqn
            faddp(i,m) = faddp(i,m) - apdq(i,m)
            faddm(i,m) = faddm(i,m) + amdq(i,m)
   40    continue
c
c     # compute maximum wave speed for checking Courant number:
      cfl1d = 0.d0
      do 50 mw=1,mwaves
	 do 50 i=1,mx+1
	    cfl1d = dmax1(cfl1d,dtdx1d(i)*dabs(s(i,mw)))
   50       continue
c
      if (method(2).eq.1) go to 130
c
c     # modify F fluxes for second order q_{xx} correction terms:
c     -----------------------------------------------------------
c
c     # apply limiter to fwaves:
      if (limit) call limiter(maxm,meqn,mwaves,mbc,mx,fwave,s,mthlim)
c
      do 120 i = 1, mx+1
c
c        # For correction terms below, need average of dtdx in cell
c        # i-1 and i.  Compute these and overwrite dtdx1d:
c
 	 dtdx1d(i-1) = 0.5d0 * (dtdx1d(i-1) + dtdx1d(i))
c
	 do 120 m=1,meqn
	    cqxx(i,m) = 0.d0
	    do 119 mw=1,mwaves
	       cqxx(i,m) = cqxx(i,m) + 0.5d0 * dsign(1.d0,s(i,mw))
     &	         * (1.d0 - dabs(s(i,mw))*dtdx1d(i-1)) * fwave(i,m,mw)
  119          continue
            faddm(i,m) = faddm(i,m) + cqxx(i,m)
            faddp(i,m) = faddp(i,m) + cqxx(i,m)
  120       continue
c
  130 continue
c
      if( m3 .le. 0) return
c
c     --------------------------------------------
c     # TRANSVERSE PROPAGATION
c     --------------------------------------------
c
c     # split the left-going flux difference into down-going and up-going
c     # flux differences (in the y-direction).
c
      call rpt3(ixyz,2,1,maxm,meqn,mwaves,maux,mbc,mx,
     &          q1d,q1d,aux1,aux2,aux3,amdq,bmamdq,bpamdq)
c
c     # split the right-going flux difference into down-going and up-going
c     # flux differences (in the y-direction).
c
      call rpt3(ixyz,2,2,maxm,meqn,mwaves,maux,mbc,mx,
     &          q1d,q1d,aux1,aux2,aux3,apdq,bmapdq,bpapdq)
c
c     # split the left-going flux difference into down-going and up-going
c     # flux differences (in the z-direction).
c
      call rpt3(ixyz,3,1,maxm,meqn,mwaves,maux,mbc,mx,
     &          q1d,q1d,aux1,aux2,aux3,amdq,cmamdq,cpamdq)
c
c     # split the right-going flux difference into down-going and up-going
c     # flux differences (in the y-direction).
c
      call rpt3(ixyz,3,2,maxm,meqn,mwaves,maux,mbc,mx,
     &          q1d,q1d,aux1,aux2,aux3,apdq,cmapdq,cpapdq)
c
c     # Split the correction wave into transverse propagating waves
c     # in the y-direction and z-direction.
c
      if (m3.eq.2) then
         if (maux .gt. 0) then
c            # The corrections cqxx affect both cell i-1 to left and cell i
c            # to right of interface.  Transverse splitting will affect
c            # fluxes on both sides.
c            # If there are aux arrays, then we must split cqxx twice in
c            # each transverse direction, once with imp=1 and once with imp=2:

c            # imp = 1 or 2 is used to indicate whether we are propagating
c            # amdq or apdq, i.e. cqxxm or cqxxp


c            # in the y-like direction with imp=1
             call rpt3(ixyz,2,1,maxm,meqn,mwaves,maux,mbc,mx,
     &                 q1d,q1d,aux1,aux2,aux3,cqxx,bmcqxxm,bpcqxxm)

c            # in the y-like direction with imp=2
              call rpt3(ixyz,2,2,maxm,meqn,mwaves,maux,mbc,mx,
     &                  q1d,q1d,aux1,aux2,aux3,cqxx,bmcqxxp,bpcqxxp)

c            # in the z-like direction with imp=1
              call rpt3(ixyz,3,1,axm,meqn,mwaves,maux,mbc,mx,
     &                  q1d,q1d,aux1,aux2,aux3,cqxx,cmcqxxm,cpcqxxm)

c            # in the z-like direction with imp=2
              call rpt3(ixyz,3,2,axm,meqn,mwaves,maux,mbc,mx,
     &                  q1d,q1d,aux1,aux2,aux3,cqxx,cmcqxxp,cpcqxxp)
           else
c            # aux arrays aren't being used, so we only need to split
c            # cqxx once in each transverse direction and the same result can
c            # presumably be used to left and right.
c            # Set imp = 0 since this shouldn't be needed in rpt3 in this case.

c            # in the y-like direction
              call rpt3(ixyz,2,0,maxm,meqn,mwaves,maux,mbc,mx,
     &              q1d,q1d,aux1,aux2,aux3,cqxx,bmcqxxm,bpcqxxm)

c            # in the z-like direction
              call rpt3(ixyz,3,0,maxm,meqn,mwaves,maux,mbc,mx,
     &              q1d,q1d,aux1,aux2,aux3,cqxx,cmcqxxm,cpcqxxm)

c             # use the same splitting to left and right:
              do m = 1,meqn
                 do i = 0,mx+2
                    bmcqxxp(i,m) = bmcqxxm(i,m)
                    bpcqxxp(i,m) = bpcqxxm(i,m)
                    cmcqxxp(i,m) = cmcqxxm(i,m)
                    cpcqxxp(i,m) = cpcqxxm(i,m)
                 enddo
              enddo
           endif
        endif

c      --------------------------------------------
c      # modify G fluxes in the y-like direction
c      --------------------------------------------
c
c     # If the correction wave also propagates in a 3D sense, incorporate
c     # cpcqxx,... into cmamdq, cpamdq, ... so that it is split also.
c
      if(m4 .eq. 1)then
         do 145 m = 1, meqn
            do 145 i = 0, mx+2
               cpapdq2(i,m) = cpapdq(i,m)
               cpamdq2(i,m) = cpamdq(i,m)
               cmapdq2(i,m) = cmapdq(i,m)
               cmamdq2(i,m) = cmamdq(i,m)
 145         continue
      else if(m4 .eq. 2)then
         do 146 m = 1, meqn
            do 146 i = 0, mx+2
               cpapdq2(i,m) = cpapdq(i,m) - 3.d0*cpcqxxp(i,m)
               cpamdq2(i,m) = cpamdq(i,m) + 3.d0*cpcqxxm(i,m)
               cmapdq2(i,m) = cmapdq(i,m) - 3.d0*cmcqxxp(i,m)
               cmamdq2(i,m) = cmamdq(i,m) + 3.d0*cmcqxxm(i,m)
 146        continue
      endif
c
c     # The transverse flux differences in the z-direction are split
c     # into waves propagating in the y-direction. If m4 = 2,
c     # then the transverse propagating correction waves in the z-direction
c     # are also split. This yields terms of the form BCAu_{xzy} and
c     # BCAAu_{xxzy}.
c
      if( m4.gt.0 )then
          call rptt3(ixyz,2,2,2,maxm,meqn,mwaves,mwaves,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,cpapdq2,bmcpapdq,bpcpapdq)
          call rptt3(ixyz,2,1,2,maxm,meqn,mwaves,mwaves,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,cpamdq2,bmcpamdq,bpcpamdq)
          call rptt3(ixyz,2,2,1,maxm,meqn,mwaves,mwaves,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,cmapdq2,bmcmapdq,bpcmapdq)
          call rptt3(ixyz,2,1,1,maxm,meqn,mwaves,mwaves,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,cmamdq2,bmcmamdq,bpcmamdq)
      endif
c
c     -----------------------------
c     # The updates for G fluxes :
c     -----------------------------
c
      do 180 m=1,meqn
         do 180 i = 1, mx+1
c
c           # Transverse propagation of the increment waves
c           # between cells sharing interfaces, i.e. the 2D approach.
c           # Yields BAu_{xy}.
c
            gadd(i-1,m,1,0) = gadd(i-1,m,1,0)
     &		            - 0.5d0*dtdx1d(i-1)*bmamdq(i,m)
            gadd(i-1,m,2,0) = gadd(i-1,m,2,0)
     &		            - 0.5d0*dtdx1d(i-1)*bpamdq(i,m)
            gadd(i,m,1,0)   = gadd(i,m,1,0)
     &		            - 0.5d0*dtdx1d(i-1)*bmapdq(i,m)
            gadd(i,m,2,0)   = gadd(i,m,2,0)
     &		            - 0.5d0*dtdx1d(i-1)*bpapdq(i,m)
c
c           # Transverse propagation of the increment wave (and the
c           # correction wave if m4=2) between cells
c           # only having a corner or edge in common. Yields terms of the
c           # BCAu_{xzy} and BCAAu_{xxzy}.
c
            if( m4.gt.0 )then
c
                gadd(i,m,2,0) = gadd(i,m,2,0)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * (bpcpapdq(i,m) - bpcmapdq(i,m))
                gadd(i,m,1,0) = gadd(i,m,1,0)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * (bmcpapdq(i,m) - bmcmapdq(i,m))
                gadd(i,m,2,1) = gadd(i,m,2,1)
     &                          - (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bpcpapdq(i,m)
                gadd(i,m,1,1) = gadd(i,m,1,1)
     &                          - (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bmcpapdq(i,m)
                gadd(i,m,2,-1) = gadd(i,m,2,-1)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bpcmapdq(i,m)
                gadd(i,m,1,-1) = gadd(i,m,1,-1)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bmcmapdq(i,m)
c
                gadd(i-1,m,2,0) = gadd(i-1,m,2,0)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * (bpcpamdq(i,m) - bpcmamdq(i,m))
                gadd(i-1,m,1,0) = gadd(i-1,m,1,0)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * (bmcpamdq(i,m) - bmcmamdq(i,m))
                gadd(i-1,m,2,1) = gadd(i-1,m,2,1)
     &                          - (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bpcpamdq(i,m)
                gadd(i-1,m,1,1) = gadd(i-1,m,1,1)
     &                          - (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bmcpamdq(i,m)
                gadd(i-1,m,2,-1) = gadd(i-1,m,2,-1)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bpcmamdq(i,m)
                gadd(i-1,m,1,-1) = gadd(i-1,m,1,-1)
     &                          + (1.d0/6.d0)*dtdx1d(i-1)*dtdz
     &                          * bmcmamdq(i,m)
c
            endif
c
c           # Transverse propagation of the correction wave between
c           # cells sharing faces. This gives BAAu_{xxy}.
c
            if(m3.lt.2) go to 180
               gadd(i,m,2,0)   = gadd(i,m,2,0)
     &                         + dtdx1d(i-1)*bpcqxxp(i,m)
               gadd(i,m,1,0)   = gadd(i,m,1,0)
     &                         + dtdx1d(i-1)*bmcqxxp(i,m)
               gadd(i-1,m,2,0) = gadd(i-1,m,2,0)
     &                         - dtdx1d(i-1)*bpcqxxm(i,m)
               gadd(i-1,m,1,0) = gadd(i-1,m,1,0)
     &                         - dtdx1d(i-1)*bmcqxxm(i,m)
c
  180       continue
c
c
c      --------------------------------------------
c      # modify H fluxes in the z-like direction
c      --------------------------------------------
c
c     # If the correction wave also propagates in a 3D sense, incorporate
c     # cqxx into bmamdq, bpamdq, ... so that is is split also.
c
      if(m4 .eq. 2)then
         do 155 m = 1, meqn
            do 155 i = 0, mx+2
               bpapdq(i,m) = bpapdq(i,m) - 3.d0*bpcqxxp(i,m)
               bpamdq(i,m) = bpamdq(i,m) + 3.d0*bpcqxxm(i,m)
               bmapdq(i,m) = bmapdq(i,m) - 3.d0*bmcqxxp(i,m)
               bmamdq(i,m) = bmamdq(i,m) + 3.d0*bmcqxxm(i,m)
155         continue
      endif
c
c     # The transverse flux differences in the y-direction are split
c     # into waves propagating in the z-direction. If m4 = 2,
c     # then the transverse propagating correction waves in the y-direction
c     # are also split. This yields terms of the form BCAu_{xzy} and
c     # BCAAu_{xxzy}.
c
c     # Note that the output to rptt3 below should logically be named
c     # cmbsasdq and cpbsasdq rather than bmcsasdq and bpcsasdq, but
c     # we are re-using the previous storage rather than requiring new arrays.
c
      if( m4.gt.0 )then
          call rptt3(ixyz,3,2,2,maxm,meqn,mwaves,maux,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,bpapdq,bmcpapdq,bpcpapdq)
          call rptt3(ixyz,3,1,2,maxm,meqn,mwaves,maux,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,bpamdq,bmcpamdq,bpcpamdq)
          call rptt3(ixyz,3,2,1,maxm,meqn,mwaves,maux,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,bmapdq,bmcmapdq,bpcmapdq)
          call rptt3(ixyz,3,1,1,maxm,meqn,mwaves,maux,mbc,mx,
     &               q1d,q1d,aux1,aux2,aux3,bmamdq,bmcmamdq,bpcmamdq)
      endif
c
c     -----------------------------
c     # The updates for H fluxes :
c     -----------------------------
c
      do 200 m=1,meqn
         do 200 i = 1, mx+1
c
c           # Transverse propagation of the increment waves
c           # between cells sharing interfaces, i.e. the 2D approach.
c           # Yields CAu_{xy}.
c
            hadd(i-1,m,1,0) = hadd(i-1,m,1,0)
     &		            - 0.5d0*dtdx1d(i-1)*cmamdq(i,m)
            hadd(i-1,m,2,0) = hadd(i-1,m,2,0)
     &		            - 0.5d0*dtdx1d(i-1)*cpamdq(i,m)
            hadd(i,m,1,0)   = hadd(i,m,1,0)
     &		            - 0.5d0*dtdx1d(i-1)*cmapdq(i,m)
            hadd(i,m,2,0)   = hadd(i,m,2,0)
     &		            - 0.5d0*dtdx1d(i-1)*cpapdq(i,m)
c
c           # Transverse propagation of the increment wave (and the
c           # correction wave if m4=2) between cells
c           # only having a corner or edge in common. Yields terms of the
c           # CBAu_{xzy} and CBAAu_{xxzy}.
c
            if( m4.gt.0 )then
c
                hadd(i,m,2,0)  = hadd(i,m,2,0)
     &                         + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                         * (bpcpapdq(i,m) - bpcmapdq(i,m))
                hadd(i,m,1,0)  = hadd(i,m,1,0)
     &                         + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                         * (bmcpapdq(i,m) - bmcmapdq(i,m))
                hadd(i,m,2,1)  = hadd(i,m,2,1)
     &                         - (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                         * bpcpapdq(i,m)
                hadd(i,m,1,1)  = hadd(i,m,1,1)
     &                         - (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                         * bmcpapdq(i,m)
                hadd(i,m,2,-1) = hadd(i,m,2,-1)
     &                         + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                         * bpcmapdq(i,m)
                hadd(i,m,1,-1) = hadd(i,m,1,-1)
     &                         + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                         * bmcmapdq(i,m)
c
                hadd(i-1,m,2,0)  = hadd(i-1,m,2,0)
     &                           + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                           * (bpcpamdq(i,m) - bpcmamdq(i,m))
                hadd(i-1,m,1,0)  = hadd(i-1,m,1,0)
     &                           + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                           * (bmcpamdq(i,m) - bmcmamdq(i,m))
                hadd(i-1,m,2,1)  = hadd(i-1,m,2,1)
     &                           - (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                           * bpcpamdq(i,m)
                hadd(i-1,m,1,1)  = hadd(i-1,m,1,1)
     &                           - (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                           * bmcpamdq(i,m)
                hadd(i-1,m,2,-1) = hadd(i-1,m,2,-1)
     &                           + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                           * bpcmamdq(i,m)
                hadd(i-1,m,1,-1) = hadd(i-1,m,1,-1)
     &                           + (1.d0/6.d0)*dtdx1d(i-1)*dtdy
     &                           * bmcmamdq(i,m)
c
            endif
c
c           # Transverse propagation of the correction wave between
c           # cells sharing faces. This gives CAAu_{xxy}.
c
            if(m3.lt.2) go to 200
               hadd(i,m,2,0)   = hadd(i,m,2,0)
     &                         + dtdx1d(i-1)*cpcqxxp(i,m)
               hadd(i,m,1,0)   = hadd(i,m,1,0)
     &                         + dtdx1d(i-1)*cmcqxxp(i,m)
               hadd(i-1,m,2,0) = hadd(i-1,m,2,0)
     &                         - dtdx1d(i-1)*cpcqxxm(i,m)
               hadd(i-1,m,1,0) = hadd(i-1,m,1,0)
     &                         - dtdx1d(i-1)*cmcqxxm(i,m)
c
  200    continue
c
      return
      end
