c     =====================================================
      subroutine qinit(maxmx,maxmy,meqn,mbc,mx,my,xlower,ylower,
     &     dx,dy,q,maux,aux)
c     =====================================================
c
c     # Set initial conditions for q.
c     # Sample scalar equation with data that is piecewise constant with
c     # q = 1.0  if  0.1 < x < 0.6   and   0.1 < y < 0.6
c     #     0.1  otherwise
c
      implicit double precision (a-h,o-z)
      dimension q(meqn, 1-mbc:maxmx+mbc, 1-mbc:maxmy+mbc)

c     # set concentration profile
c     ---------------------------
      do 20 j=1,my
         yj = ylower + (j-0.5d0)*dy
         do 20 i=1,mx
            xi = xlower + (i-0.5d0)*dx
            if (xi.gt.0.499d0 .and. xi.lt.0.501d0 .and.
     &            yj.gt.0.499d0 .and. yj.lt.0.501d0) then
               q(1,i,j) = 1.
            else
               q(1,i,j) = 0.1d0
            endif
   20    continue


      return
      end
