// Generated by CoffeeScript 1.7.1
var escapeDiv, escapeElement, href, _ref,
  __slice = [].slice,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

href = document.location.protocol + '//' + document.location.host + document.location.pathname;

escapeDiv = document.createElement('div');

escapeElement = document.createTextNode('');

escapeDiv.appendChild(escapeElement);

window.cldoc = $.extend($.extend({
  host: href.substring(0, href.lastIndexOf('/'))
}, (_ref = window.cldoc) != null ? _ref : {}), {
  tag: function(node) {
    return $.map(node, function(e) {
      return e.tagName.toLowerCase();
    });
  },
  startswith: function(s, prefix) {
    return s.indexOf(prefix) === 0;
  },
  html_escape: function(s) {
    escapeElement.data = s;
    return escapeDiv.innerHTML;
  },
  new_timer: function() {
    var ret;
    ret = {
      start: new Date()
    };
    ret.tick = function(s) {
      var end;
      end = new Date();
      return ret.start = end;
    };
    return ret;
  },
  xml_attr: function(e, a) {
    return e.getAttribute(a);
  }
});

$(document).ready(function() {
  cldoc.Sidebar.init();
  return cldoc.Page.route();
});

cldoc.SearchWorker = function() {
  var bsearch, db, load_db, log, search_term;
  db = null;
  log = function(msg) {
    return self.postMessage({
      type: 'log',
      message: msg
    });
  };
  load_db = function(host) {
    var xhr;
    xhr = new XMLHttpRequest();
    xhr.open('GET', host + '/search.json?' + new Date().getTime(), false);
    xhr.send();
    return JSON.parse(xhr.responseText);
  };
  bsearch = (function(_this) {
    return function(term, l, r, sel) {
      var mid, rec, suf, suffix_record, _ref1;
      suffix_record = function(i) {
        return db.suffixes[i][0];
      };
      while (l < r) {
        mid = Math.floor((l + r) / 2);
        rec = suffix_record(mid);
        suf = db.records[rec[0]][0].substring(rec[1]);
        _ref1 = sel(suf) ? [mid + 1, r] : [l, mid], l = _ref1[0], r = _ref1[1];
      }
      return [l, r];
    };
  })(this);
  search_term = (function(_this) {
    return function(term) {
      var end, l, r, start, t, _, _ref1, _ref2;
      if (term.length < 3) {
        return [0, 0];
      }
      l = 0;
      r = db.suffixes.length;
      t = term.toLowerCase();
      _ref1 = bsearch(t, 0, db.suffixes.length, function(suf) {
        return t > suf;
      }), start = _ref1[0], _ = _ref1[1];
      _ref2 = bsearch(t, start, db.suffixes.length, function(suf) {
        return suf.indexOf(t) === 0;
      }), _ = _ref2[0], end = _ref2[1];
      return [start, end];
    };
  })(this);
  return self.onmessage = (function(_this) {
    return function(ev) {
      var end, i, items, m, rec, recid, records, ret, rr, start, word, words, _i, _j, _k, _len, _len1, _ref1, _ref2;
      m = ev.data;
      if (db === null) {
        db = load_db(m.host);
      }
      words = m.q.split(/\s+/);
      records = {};
      ret = {
        type: 'result',
        id: m.id,
        q: m.q,
        words: words,
        records: []
      };
      for (_i = 0, _len = words.length; _i < _len; _i++) {
        word = words[_i];
        _ref1 = search_term(word), start = _ref1[0], end = _ref1[1];
        for (i = _j = start, _ref2 = end - 1; _j <= _ref2; i = _j += 1) {
          items = db.suffixes[i];
          for (_k = 0, _len1 = items.length; _k < _len1; _k++) {
            rec = items[_k];
            recid = rec[0];
            if (!(recid in records)) {
              rr = {
                name: db.records[recid][0],
                id: db.records[recid][1],
                score: 0,
                results: [],
                suffixhash: {}
              };
              ret.records.push(rr);
              records[recid] = rr;
            } else {
              rr = records[recid];
            }
            if (!(rec[1] in rr.suffixhash)) {
              rr.score += 1;
              rr.results.push([rec[1], rec[1] + word.length]);
              rr.suffixhash[rec[1]] = true;
            }
          }
        }
      }
      ret.records.sort(function(a, b) {
        var _ref3, _ref4;
        return (_ref3 = a.score > b.score) != null ? _ref3 : (_ref4 = a.score < b.score) != null ? _ref4 : -{
          1: 0
        };
      });
      return self.postMessage(ret);
    };
  })(this);
};

cldoc.SearchDb = (function() {
  function SearchDb() {
    var blob, wurl, _ref1;
    this.searchid = 0;
    this.searchcb = null;
    wurl = (_ref1 = window.webkitURL) != null ? _ref1 : window.URL;
    blob = new Blob(['worker = ' + cldoc.SearchWorker.toString() + '; worker();'], {
      type: 'text/javascript'
    });
    this.worker = new Worker(wurl.createObjectURL(blob));
    this.worker.onmessage = (function(_this) {
      return function(msg) {
        var m;
        m = msg.data;
        if (m.type === 'log') {
          return console.log(m.message);
        } else if (m.type === 'result') {
          if (m.id !== _this.searchid) {
            return;
          }
          _this.searchid = 0;
          return _this.searchcb(m);
        }
      };
    })(this);
  }

  SearchDb.prototype.search = function(q, cb) {
    this.searchid += 1;
    this.searchcb = cb;
    return this.worker.postMessage({
      type: 'search',
      q: q,
      id: this.searchid,
      host: cldoc.host
    });
  };

  return SearchDb;

})();

cldoc.Page = (function() {
  function Page() {}

  Page.pages = {};

  Page.current_page = null;

  Page.first = true;

  Page.search = {
    db: null
  };

  Page.request_page = function(page, cb) {
    var url;
    if (page in this.pages) {
      cb(this.pages[page]);
      return;
    }
    url = cldoc.host + '/xml/' + page + '.xml';
    return $.ajax({
      url: url,
      cache: false,
      success: (function(_this) {
        return function(data) {
          _this.pages[page] = {
            xml: $(data),
            html: null
          };
          return cb(_this.pages[page]);
        };
      })(this)
    });
  };

  Page.load = function(page, scrollto, updatenav) {
    cldoc.Sidebar.exit_search();
    if (page === null || page === 'undefined') {
      page = this.current_page;
    }
    if (!page) {
      page = 'index';
    }
    if (updatenav) {
      this.push_nav(page, scrollto);
    }
    if (this.current_page !== page) {
      return this.request_page(page, (function(_this) {
        return function() {
          return _this.load_page(page, scrollto);
        };
      })(this));
    } else {
      return this.scroll(page, scrollto);
    }
  };

  Page.make_link = function(ref, name, attrs) {
    var e, k, r, ret, v;
    if (attrs == null) {
      attrs = {};
    }
    e = cldoc.html_escape;
    r = this.make_internal_ref(ref);
    ret = '<a href="' + e(r) + '"';
    for (k in attrs) {
      v = attrs[k];
      ret += ' ' + k + '="' + e(v) + '"';
    }
    return ret + '>' + e(name) + '</a>';
  };

  Page.load_page = function(page, scrollto) {
    var brief, content, cpage, data, html, root, sidebar, start, title;
    this.first = this.current_page === null;
    start = new Date();
    this.current_page = page;
    cpage = this.pages[page];
    data = cpage.xml;
    html = cpage.html;
    $('#cldoc #cldoc_content').children().detach();
    root = data.children(':first');
    if (html) {
      $('#cldoc #cldoc_content').append(html.content);
      cldoc.Sidebar.load_html(html.sidebar);
    } else {
      sidebar = cldoc.Sidebar.load(root);
      content = this.load_contents(root);
      cpage.html = {
        sidebar: sidebar,
        content: content
      };
    }
    title = root.attr('name');
    if (!title) {
      brief = root.children('brief');
      if (brief.length > 0) {
        title = brief.text();
        if (title[title.length - 1] === '.') {
          title = title.substring(0, title.length - 1);
        }
      }
    }
    if (!title) {
      title = 'Documentation';
    }
    document.title = title;
    this.scroll(page, scrollto, true);
    return $('#cldoc').triggerHandler('page-loaded', [root]);
  };

  Page.make_external_ref = function(page, id) {
    if (page[0] === '#') {
      page = page.substring(1);
    }
    if (!id) {
      return page.replace('/', '#');
    } else {
      return page + '#' + id;
    }
  };

  Page.make_internal_ref = function(page, id) {
    if (!page) {
      return '#index';
    }
    if (!id) {
      return '#' + page.replace('#', '/');
    } else {
      return '#' + page + '/' + id;
    }
  };

  Page.split_ref = function(ref) {
    var id, page, _ref1;
    _ref1 = ref.split('#', 2), page = _ref1[0], id = _ref1[1];
    if (!page) {
      page = 'index';
    }
    return [page, id];
  };

  Page.load_ref = function(ref) {
    var r;
    r = this.split_ref(ref);
    return this.load(r[0], r[1], true);
  };

  Page.make_header = function(item) {
    var e, id, name, obj, ret, title, type;
    id = item.attr('id');
    e = cldoc.html_escape;
    if (id) {
      ret = '<span>';
      type = this.node_type(item);
      title = item.attr('title');
      if (type) {
        ret += '<span class="keyword">' + e(type.title[0]) + '</span>';
        obj = new type(item);
        name = obj.full_name_for_display();
      } else {
        name = item.attr('name');
      }
      if (title) {
        ret += '<span>' + e(title) + '</span>';
      } else {
        if (name) {
          ret += '<span>' + e(name) + '</span>';
        } else {
          ret += '<span>' + e(id) + '</span>';
        }
      }
      return ret;
    } else {
      return '';
    }
  };

  Page.load_description = function(page, content) {
    var desc, doc, h1, id;
    doc = cldoc.Doc.either(page);
    id = page.attr('id');
    if (id) {
      h1 = $('<h1/>').appendTo(content);
      h1.attr('id', id);
      h1.append(this.make_header(page));
    }
    if (doc) {
      desc = $('<div class="description"/>');
      desc.append(doc);
      return content.append(desc);
    }
  };

  Page.node_type = function(item) {
    var typename;
    typename = cldoc.tag(item)[0];
    if (!(typename in cldoc.Node.types)) {
      return null;
    }
    return cldoc.Node.types[typename];
  };

  Page.load_items = function(page) {
    var all, container, content, e, group, item, itemcontents, items, ret, tp, type, _i, _j, _len, _len1, _ref1;
    all = page.children();
    content = '';
    e = cldoc.html_escape;
    _ref1 = cldoc.Node.groups;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      group = _ref1[_i];
      items = all.filter(group);
      if (items.length === 0) {
        continue;
      }
      type = this.node_type(items);
      if (!type || type === cldoc.Node.types.report) {
        continue;
      }
      content += '<h2 data-cldoc-dynamic="1" id="' + e(type.title[1].toLowerCase()) + '">' + e(type.title[1]) + '</h2>';
      container = type.render_container();
      itemcontents = '';
      for (_j = 0, _len1 = items.length; _j < _len1; _j++) {
        item = items[_j];
        item = $(item);
        if (cldoc.tag(item)[0] !== cldoc.tag(items)[0]) {
          tp = this.node_type(item);
        } else {
          tp = type;
        }
        if (tp) {
          ret = new tp($(item)).render();
          if (ret) {
            itemcontents += ret;
          }
        }
      }
      if (container) {
        content += container[0] + itemcontents + container[1];
      } else {
        content += itemcontents;
      }
    }
    return content;
  };

  Page.bind_links = function(container) {
    return container.find('a').on('click', (function(_this) {
      return function(e) {
        var ref;
        ref = $(e.delegateTarget).attr('href');
        if (ref[0] === '#') {
          _this.load_ref(_this.make_external_ref(ref));
          return false;
        } else {
          return true;
        }
      };
    })(this));
  };

  Page.load_pagenav = function(page, content) {
    var h2cnt, h2li, h2ol, h3cnt, pagenav, ul;
    if (this.node_type(page) !== cldoc.Category) {
      return;
    }
    pagenav = $('#cldoc_sidebar_pagenav');
    ul = $('<ol/>');
    h2cnt = 0;
    h2li = null;
    h2ol = null;
    h3cnt = 0;
    content.find('h2,h3').each((function(_this) {
      return function(i, e) {
        var a, h, id, ish2, li, t;
        h = $(e);
        if (h.attr('data-cldoc-dynamic')) {
          return;
        }
        id = h.text();
        ish2 = e.tagName === 'H2';
        if (ish2) {
          h2cnt += 1;
          t = h2cnt + '. ' + id;
        } else {
          h3cnt += 1;
          t = h2cnt + '.' + h3cnt + '. ' + id;
        }
        h.text(t);
        h.attr('id', id);
        a = $('<a/>', {
          href: _this.make_internal_ref(_this.current_page, id)
        }).text(t);
        li = $('<li/>').append(a);
        if (!ish2 && h2li !== null) {
          if (h2ol === null) {
            h2ol = $('<ol/>').appendTo(h2li);
          }
          return h2ol.append(li);
        } else {
          if (ish2 && h2li === null) {
            h2li = li;
            h2ol = null;
          }
          return li.appendTo(ul);
        }
      };
    })(this));
    this.bind_links(ul);
    return pagenav.append(ul);
  };

  Page.load_contents = function(page) {
    var content, items;
    content = $('#cldoc #cldoc_content');
    content.children().detach();
    this.load_description(page, content);
    items = $(this.load_items(page));
    content.append(items);
    this.bind_links(content);
    this.load_pagenav(page, content);
    return content.children();
  };

  Page.push_nav = function(page, scrollto) {
    var hash, prevpage, prevscrollto, _ref1;
    hash = document.location.hash;
    _ref1 = this.split_ref(this.make_external_ref(hash)), prevpage = _ref1[0], prevscrollto = _ref1[1];
    return history.pushState({
      page: prevpage,
      scrollto: prevscrollto
    }, page, this.make_internal_ref(page, scrollto));
  };

  Page.route = function() {
    var hash, m, page, route, scrollto;
    hash = document.location.hash.substr(1);
    route = new RegExp('^([^/]+)(/(.*))?$');
    m = route.exec(hash);
    page = '';
    scrollto = '';
    if (!m) {
      page = 'index';
    } else {
      page = m[1];
      scrollto = m[3];
    }
    $(window).on('popstate', (function(_this) {
      return function(e) {
        var state;
        if (e.originalEvent.state) {
          state = e.originalEvent.state;
          if (state.page !== _this.current_page) {
            return _this.load(state.page, state.scrollto, false);
          } else {
            return _this.select(state.scrollto, false);
          }
        }
      };
    })(this));
    return this.load(page, scrollto);
  };

  Page.select = function(scrollto, doanimate) {
    var inopts, outopts;
    scrollto = $(scrollto);
    if (!scrollto && !this.selected_element) {
      return;
    }
    if (scrollto && this.selected_element && scrollto.attr('id') === this.selected_element.attr('id')) {
      return;
    }
    if (doanimate) {
      inopts = {
        'duration': 2000,
        'easing': 'easeInOutExpo'
      };
      outopts = {
        'duration': 100,
        'easing': 'easeInOutExpo'
      };
    } else {
      inopts = {
        'duration': 0
      };
      outopts = {
        'duration': 0
      };
    }
    if (this.selected_element) {
      this.selected_element.removeClass('selected', outopts);
      this.selected_element = null;
    }
    if (scrollto) {
      this.selected_element = $(scrollto);
      return this.selected_element.addClass('selected', inopts);
    }
  };

  Page.scroll = function(page, scrollto, newpage) {
    var e, istopandnew, top;
    if (!scrollto) {
      return;
    }
    if (page === null) {
      page = this.current_page;
    }
    e = $(document).find('#' + scrollto.replace(/([:() +])/g, '\\$1')).first();
    if (e && e.length > 0) {
      e = $(e);
      top = e.offset().top - 10;
      istopandnew = newpage && e.is('h1');
      if (this.first || istopandnew) {
        if (!istopandnew) {
          this.select(e);
        } else {
          this.select();
        }
        $('html, body').scrollTop(top);
      } else {
        this.select(e, true);
        $('html, body').animate({
          scrollTop: top
        }, 1000, 'easeInOutExpo');
      }
    } else {
      this.select(null, true);
    }
    return this.first = false;
  };

  Page.render_search = function(result) {
    var a, content, cpage, data, end, item, page, pageid, pageidesc, parts, prev, records, res, sortfunc, start, t, tag, _i, _j, _k, _len, _len1, _len2, _ref1, _ref2, _ref3, _ref4;
    content = $('#cldoc_content');
    content.children().detach();
    $('<h1><span class="keyword">Search</span> </h1>').append(result.q).appendTo(content);
    if (result.records.length === 0) {
      $('<span class="info">There were no results for this search query.</span>').appendTo(content);
      cldoc.Sidebar.render_search([]);
      $('html, body').scrollTop(0);
      return;
    }
    records = [];
    _ref1 = result.records;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      res = _ref1[_i];
      _ref2 = this.split_ref(res.id), page = _ref2[0], pageid = _ref2[1];
      if (!page in this.pages) {
        continue;
      }
      cpage = this.pages[page];
      data = cpage.xml;
      pageidesc = pageid.replace(/([:() ])/g, '\\$1');
      item = data.find('#' + pageidesc);
      if (item.length !== 1) {
        continue;
      }
      tag = cldoc.tag(item)[0];
      res.type = tag;
      res.brief = new cldoc.Doc(item.children('brief'));
      res.page = page;
      res.qid = pageid;
      records.push(res);
    }
    sortfunc = function(a, b) {
      var ai, bi;
      if (a.score !== b.score) {
        if (a.score > b.score) {
          return -1;
        } else {
          return 1;
        }
      }
      if (a.type !== b.type) {
        ai = cldoc.Node.order[a.type];
        bi = cldoc.Node.order[b.type];
        if (ai !== bi) {
          if (ai < bi) {
            return -1;
          } else {
            return 1;
          }
        }
      }
      if (a.name < b.name) {
        return -1;
      } else {
        return 1;
      }
    };
    records.sort(sortfunc);
    t = $('<table class="search_results"/>').appendTo(content);
    for (_j = 0, _len1 = records.length; _j < _len1; _j++) {
      res = records[_j];
      res.results.sort(function(a, b) {
        if (a[0] !== b[0]) {
          if (a[0] < b[0]) {
            return -1;
          } else {
            return 1;
          }
        }
        if (a[1] > b[1]) {
          return -1;
        }
        if (a[1] < b[1]) {
          return 1;
        }
        return 0;
      });
      prev = 0;
      parts = [];
      _ref3 = res.results;
      for (_k = 0, _len2 = _ref3.length; _k < _len2; _k++) {
        _ref4 = _ref3[_k], start = _ref4[0], end = _ref4[1];
        if (start < prev) {
          continue;
        }
        parts.push(res.qid.substring(prev, start));
        parts.push($('<span class="search_result"/>').text(res.qid.substring(start, end)));
        prev = end;
      }
      parts.push(res.qid.substring(prev, res.qid.length));
      a = $('<a/>', {
        href: this.make_internal_ref(res.id)
      }).html(parts);
      a.on('click', (function(_this) {
        return function(res) {
          return function() {
            return _this.load_ref(res.id);
          };
        };
      })(this)(res));
      $('<tr/>').append($('<td class="keyword"/>').text(res.type)).append($('<td class="identifier"/>').html(a)).appendTo(t);
      $('<tr/>').append($('<td/>')).append($('<td/>').html(res.brief.render())).appendTo(t);
    }
    cldoc.Sidebar.render_search(records);
    return $('html, body').scrollTop(0);
  };

  Page.search_result = function(result) {
    var page, pageid, pagereqcount, pages, record, _i, _len, _ref1, _ref2, _results;
    pagereqcount = 0;
    pages = {};
    _ref1 = result.records;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      record = _ref1[_i];
      _ref2 = this.split_ref(record.id), page = _ref2[0], pageid = _ref2[1];
      if (page in pages) {
        continue;
      }
      pagereqcount += 1;
      pages[page] = true;
    }
    if (pagereqcount === 0) {
      this.render_search(result);
    }
    _results = [];
    for (page in pages) {
      _results.push(this.request_page(page, (function(_this) {
        return function() {
          pagereqcount -= 1;
          if (pagereqcount === 0) {
            return _this.render_search(result);
          }
        };
      })(this)));
    }
    return _results;
  };

  Page.search = function(q) {
    if (q.length < 3) {
      return false;
    }
    if (!this.search.db) {
      this.search.db = new cldoc.SearchDb();
    }
    this.search.db.search(q, (function(_this) {
      return function(res) {
        return _this.search_result(res);
      };
    })(this));
    return true;
  };

  Page.exit_search = function() {
    var ref;
    ref = Page.make_external_ref(document.location.hash.substring(1));
    cldoc.Sidebar.exit_search();
    this.current_page = null;
    return this.load_ref(ref);
  };

  return Page;

})();

cldoc.Sidebar = (function() {
  function Sidebar() {}

  Sidebar.init = function() {
    var close, div, exitsearch, icon, input, it, items, sidebar;
    sidebar = $('#cldoc #cldoc_sidebar');
    if (!sidebar) {
      return;
    }
    items = $('<div/>').attr('id', 'cldoc_sidebar_items');
    it = items[0];
    items.on('DOMSubtreeModified', (function(_this) {
      return function(e) {
        if (it.scrollHeight > it.clientHeight) {
          return $(it).removeClass('hide_scrollbar');
        } else {
          return $(it).addClass('hide_scrollbar');
        }
      };
    })(this));
    sidebar.append(items);
    div = $('<div/>').attr('id', 'cldoc_search');
    icon = $('<div class="icon"/>');
    close = $('<div class="close" title="Cancel search"/>');
    input = $('<input type="text" accesskey="s" title="Search documentation (Alt+S)"/>');
    items = $().add(div).add(icon).add(close);
    input.on('focus', function(e) {
      return items.addClass('focus');
    });
    $('body').on('keydown', function(e) {
      if (e.altKey && e.keyCode === 83) {
        input.focus();
        input.select();
        return true;
      }
    });
    input.on('blur', function() {
      return items.removeClass('focus');
    });
    icon.on('click', function() {
      return input.focus();
    });
    exitsearch = function() {
      input.val('');
      input.blur();
      return cldoc.Page.exit_search();
    };
    close.on('click', exitsearch);
    input.on('keypress', function(e) {
      if (e.which === 13) {
        cldoc.Page.search(input.val());
        return true;
      }
    });
    input.on('keydown', function(e) {
      if (e.keyCode === 27) {
        return exitsearch();
      }
    });
    div.append(icon);
    div.append(input);
    div.append(close);
    return sidebar.append(div);
  };

  Sidebar.render_search = function(results) {
    return $('#cldoc_sidebar').addClass('search');
  };

  Sidebar.exit_search = function() {
    return $('#cldoc_sidebar').removeClass('search');
  };

  Sidebar.load_html = function(html) {
    var items;
    items = $('#cldoc #cldoc_sidebar #cldoc_sidebar_items');
    items.children().detach();
    return items.append(html);
  };

  Sidebar.load = function(page) {
    var c, div, e, group, head, id, items, l, ln, name, onpage, parts, _i, _len, _ref1;
    items = $('#cldoc #cldoc_sidebar #cldoc_sidebar_items');
    e = cldoc.html_escape;
    if (items.length === 0) {
      return null;
    }
    items.children().detach();
    head = cldoc.Page.make_header(page);
    if (head) {
      div = '<div class="back"><div class="name">';
      div += head;
      id = page.attr('id');
      parts = id.split('::');
      l = parts.slice(0, parts.length - 1).join('::');
      name = '<span class="arrow">&crarr;</span> ';
      if (parts.length === 1) {
        name += '<span>Index</span>';
      } else {
        name += '<span>' + e(parts[parts.length - 2]) + '</span>';
      }
      ln = cldoc.Page.make_internal_ref(l);
      div += '</div><a href="' + e(ln) + '">' + name + '</a></div>';
      items.append($(div));
    }
    items.append($('<div id="cldoc_sidebar_pagenav"/>'));
    onpage = page.children();
    c = '';
    _ref1 = cldoc.Node.groups;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      group = _ref1[_i];
      c += this.load_group(page, onpage.filter(group));
    }
    items.append($(c));
    cldoc.Page.bind_links(items);
    return $('#cldoc_sidebar_items').children();
  };

  Sidebar.load_group = function(page, items) {
    var brief, e, ftag, isprot, isstat, isvirt, item, nm, ret, tp, type, _i, _len;
    if (items.length === 0) {
      return '';
    }
    ftag = cldoc.tag($(items[0]))[0];
    type = cldoc.Page.node_type(items);
    if (!type) {
      return '';
    }
    e = cldoc.html_escape;
    ret = '<div class="subtitle">' + e(type.title[1]) + '</div>';
    ret += '<ul>';
    for (_i = 0, _len = items.length; _i < _len; _i++) {
      item = items[_i];
      item = $(item);
      if (cldoc.tag(item)[0] !== ftag) {
        tp = cldoc.Page.node_type(item);
      } else {
        tp = type;
      }
      if (!tp) {
        continue;
      }
      item = new tp(item);
      if ('render_sidebar' in item) {
        ret += item.render_sidebar();
        continue;
      }
      ret += '<li>';
      nm = item.sidebar_name();
      if (item.ref) {
        href = cldoc.Page.make_internal_ref(item.ref);
      } else {
        href = cldoc.Page.make_internal_ref(cldoc.Page.current_page, item.id);
      }
      ret += '<a href="' + e(href) + '">' + e(nm) + '<span class="counter"></span></a>';
      isvirt = item.node.attr('virtual');
      isprot = item.node.attr('access') === 'protected';
      isstat = item.node.attr('static');
      if (isprot && isvirt) {
        ret += '<span class="protected virtual">p&nbsp;v</span>';
      } else if (isprot && isstat) {
        ret += '<span class="static protected">s&nbsp;p</span>';
      } else if (isprot) {
        ret += '<span class="protected">p</span>';
      } else if (isstat) {
        ret += '<span class="static">s</span>';
      } else if (isvirt) {
        ret += '<span class="virtual">v</span>';
      }
      brief = new cldoc.Doc(item.brief).render();
      if (brief) {
        ret += brief;
      }
      ret += '</li>';
    }
    return ret + '</ul>';
  };

  return Sidebar;

})();

cldoc.Mixin = function() {
  var base, mixin, mixins, _i;
  base = arguments[0], mixins = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
  for (_i = mixins.length - 1; _i >= 0; _i += -1) {
    mixin = mixins[_i];
    base = mixin(base);
  }
  return base;
};

cldoc.Node = (function() {
  Node.types = {};

  Node.groups = ['coverage', 'arguments', 'references', 'category', 'namespace', 'templatetypeparameter, templatenontypeparameter', 'base', 'implements', 'subclass', 'implementedby', 'typedef', 'class, classtemplate', 'gobject\\:class', 'gobject\\:interface', 'gobject\\:boxed', 'struct, structtemplate', 'enum', 'field, union', 'variable', 'gobject\\:property', 'constructor', 'destructor', 'method, methodtemplate', 'function, functiontemplate', 'report'];

  Node.order = {
    'category': 0,
    'namespace': 1,
    'templatetypeparameter': 2,
    'templatenontypeparameter': 2,
    'base': 3,
    'implements': 3,
    'subclass': 4,
    'implementedby': 4,
    'typedef': 5,
    'class': 6,
    'classtemplate': 6,
    'gobjectclass': 6,
    'gobjectinterface': 7,
    'struct': 8,
    'structtemplate': 8,
    'gobjectboxed': 8,
    'enum': 9,
    'enumvalue': 10,
    'field': 11,
    'union': 12,
    'variable': 13,
    'gobjectproperty': 13,
    'constructor': 14,
    'destructor': 15,
    'method': 16,
    'methodtemplate': 16,
    'function': 17,
    'functiontemplate': 17
  };

  Node.render_container_tag = 'div';

  function Node(node) {
    this.node = node;
    if (!this.node) {
      return;
    }
    if (this.node.length === 0) {
      this.node = null;
      return;
    }
    this.name = this.node.attr('name');
    this.id = this.node.attr('id');
    this.ref = this.node.attr('ref');
    if (this.ref && !this.id) {
      this.id = this.ref.replace('#', '+');
    }
    this.brief = node.children('brief').first();
    this.doc = node.children('doc').first();
  }

  Node.prototype.full_name_for_display = function() {
    return null;
  };

  Node.prototype.sidebar_name = function() {
    return this.name;
  };

  Node.render_container = function() {
    return ['<' + this.render_container_tag + ' class="' + cldoc.html_escape(this.title[1].toLowerCase().replace(/[ ]/g, '_')) + '">', '</' + this.render_container_tag + '>'];
  };

  Node.prototype.render = function() {
    return null;
  };

  return Node;

})();

cldoc.Type = (function(_super) {
  __extends(Type, _super);

  function Type(node) {
    var a, builtincls, e, name, q, qc, subtype;
    this.node = node;
    Type.__super__.constructor.call(this, this.node);
    this.qualifier = this.node.attr('qualifier');
    this.size = this.node.attr('size');
    this.transfer_ownership = this.node.attr('transfer-ownership') || 'none';
    this.allow_none = this.node.attr('allow-none') === 'yes';
    this.typeparts = [];
    this.typeparts_text = [];
    subtype = this.node.children('type');
    e = cldoc.html_escape;
    if (subtype.length > 0) {
      this.subtype = new Type(subtype);
      this.typeparts = this.typeparts.concat(this.subtype.typeparts);
      this.typeparts_text = this.typeparts_text.contact(this.subtype.typeparts_text);
    }
    if (this.name) {
      if (this.node.attr('builtin')) {
        builtincls = 'builtin';
      } else {
        builtincls = '';
      }
      if (this.ref) {
        a = cldoc.Page.make_link(this.ref, this.name);
        name = '<span class="name ' + builtincls + '">' + a + '</span>';
      } else {
        name = '<span class="name ' + builtincls + '">' + e(this.name) + '</span>';
      }
      this.typeparts.push(name);
      this.typeparts_text.push(this.name);
    }
    if (this.qualifier) {
      qc = e(this.qualifier).replace(/const/g, '<span class="keyword">const</span>');
      q = '<span class="qualifier"> ' + qc + '</span>';
      this.typeparts.push('<span class="qualifier">' + q + '</span>');
      this.typeparts_text.push(this.qualifier);
    }
    if (this.size) {
      this.typeparts.push('<span class="array_size">' + '[' + this.size + ']' + '</span>');
      this.typeparts_text.push('[' + this.size + ']');
    }
  }

  Type.prototype.as_text = function() {
    return this.typeparts_text.join('');
  };

  Type.prototype.render = function() {
    var item, ret, _i, _len, _ref1;
    ret = '<span class="type">';
    _ref1 = this.typeparts;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      item = _ref1[_i];
      ret += item;
    }
    return ret;
  };

  return Type;

})(cldoc.Node);

cldoc.Node.types.type = cldoc.Type;

cldoc.Doc = (function(_super) {
  __extends(Doc, _super);

  Doc.magic_separator = '%~@@~%';

  function Doc(node) {
    this.node = node;
    Doc.__super__.constructor.call(this, this.node);
  }

  Doc.either = function(node) {
    var brief, doc;
    doc = this.doc(node);
    if (doc) {
      return doc;
    }
    brief = this.brief(node);
    if (brief) {
      return brief;
    }
    return '';
  };

  Doc.brief = function(node) {
    return new Doc(node.children('brief')).render();
  };

  Doc.doc = function(node) {
    return new Doc(node.children('doc')).render();
  };

  Doc.prototype.escape = function(text) {
    var r;
    r = /([*_\\`{}#+-.!\[\]])/g;
    return text.replace(r, function(m) {
      return "\\" + m;
    });
  };

  Doc.prototype.process_markdown = function(text) {
    var a, html, i, marked_options, parts, rethtml, _i, _ref1;
    marked_options = {
      highlight: function(code) {
        return hljs.highlightAuto(code).value;
      }
    };
    marked.setOptions(marked_options);
    html = marked(text);
    parts = html.split(Doc.magic_separator);
    rethtml = '';
    for (i = _i = 0, _ref1 = parts.length - 2; _i <= _ref1; i = _i += 3) {
      a = cldoc.Page.make_link(parts[i + 1], parts[i + 2]);
      rethtml += parts[i] + a;
    }
    return rethtml + parts[parts.length - 1];
  };

  Doc.prototype.process_code = function(code) {
    var c, e, ret, tag, _i, _len, _ref1;
    ret = '<pre><code>';
    e = cldoc.html_escape;
    _ref1 = $(code).contents();
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      c = _ref1[_i];
      if (c.nodeType === document.ELEMENT_NODE) {
        tag = c.tagName.toLowerCase();
        c = $(c);
        if (tag === 'ref') {
          ret += cldoc.Page.make_link(c.attr('ref'), c.attr('name'));
        } else {
          ret += '<span class="' + e(tag) + '">' + e(c.text()) + '</span>';
        }
      } else {
        ret += e($(c).text());
      }
    }
    return ret + '</code></pre>';
  };

  Doc.prototype.render = function() {
    var astext, c, contents, e, msep, ret, tag, _i, _len;
    if (!this.node) {
      return '';
    }
    e = cldoc.html_escape;
    ret = '<div class="' + e(cldoc.tag(this.node)[0]) + '">';
    contents = this.node.contents();
    astext = '';
    msep = Doc.magic_separator;
    for (_i = 0, _len = contents.length; _i < _len; _i++) {
      c = contents[_i];
      if (c.nodeType === document.ELEMENT_NODE) {
        tag = c.tagName.toLowerCase();
        if (tag === 'ref') {
          c = $(c);
          astext += this.escape(msep + c.attr('ref') + msep + c.text() + msep);
        } else if (tag === 'code') {
          if (astext) {
            ret += this.process_markdown(astext);
            astext = '';
          }
          ret += this.process_code(c);
        }
      } else {
        astext += $(c).text();
      }
    }
    if (astext) {
      ret += this.process_markdown(astext);
    }
    return ret + '</div>';
  };

  return Doc;

})(cldoc.Node);

cldoc.Node.types.doc = cldoc.Doc;

cldoc.Category = (function(_super) {
  __extends(Category, _super);

  Category.title = ['', 'Categories'];

  function Category(node) {
    this.node = node;
    Category.__super__.constructor.call(this, this.node);
  }

  Category.prototype.full_name_for_display = function() {
    return this.name;
  };

  Category.prototype.render = function() {
    var a, cat, categories, doc, ret, _i, _len;
    ret = '<div class="item">';
    ret += cldoc.Page.make_link(this.ref, this.name, {
      'id': this.id
    });
    ret += new cldoc.Doc(this.brief).render();
    categories = this.node.children('category');
    if (categories.length > 0) {
      ret += '<table class="category">';
      for (_i = 0, _len = categories.length; _i < _len; _i++) {
        cat = categories[_i];
        cat = $(cat);
        a = cldoc.Page.make_link(cat.attr('ref'), cat.attr('name'));
        doc = cldoc.Doc.either(cat);
        ret += '<tr><td>' + a + '</td><td class="doc">' + doc + '</td></tr>';
      }
      ret += '</table>';
    }
    return ret;
  };

  return Category;

})(cldoc.Node);

cldoc.Node.types.category = cldoc.Category;

cldoc.Enum = (function(_super) {
  __extends(Enum, _super);

  Enum.title = ['Enum', 'Enumerations'];

  function Enum(node) {
    this.node = node;
    Enum.__super__.constructor.call(this, this.node);
  }

  Enum.prototype.render = function() {
    var e, isprot, n, ret, value, _i, _len, _ref1;
    e = cldoc.html_escape;
    isprot = this.node.attr('access') === 'protected';
    if (isprot) {
      n = 'protected enum';
    } else {
      n = 'enum';
    }
    if (this.node.attr('class')) {
      n += ' class';
    }
    if (this.node.attr('typedef')) {
      n = 'typedef ' + n;
    }
    ret = '<div id="' + e(this.id) + '"><span class="keyword">' + e(n) + '</span> ';
    ret += '<span class="identifier">';
    if (!cldoc.startswith(this.name, '(anonymous')) {
      ret += e(this.name);
    }
    ret += '</span></div>';
    ret += cldoc.Doc.either(this.node);
    ret += '<table>';
    _ref1 = this.node.children('enumvalue');
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      value = _ref1[_i];
      value = $(value);
      ret += '<tr id="' + e(value.attr('id')) + '">';
      ret += '<td class="name identifier">' + e(value.attr('name')) + '</td>';
      ret += '<td class="value">' + e(value.attr('value')) + '</td>';
      ret += '<td class="doc">' + cldoc.Doc.either(value) + '</td>';
      ret += '</tr>';
    }
    return ret + '</table>';
  };

  return Enum;

})(cldoc.Node);

cldoc.Node.types["enum"] = cldoc.Enum;

cldoc.Templated = function(base) {
  var MixedIn;
  MixedIn = (function(_super) {
    __extends(MixedIn, _super);

    function MixedIn() {
      return MixedIn.__super__.constructor.apply(this, arguments);
    }

    MixedIn.prototype.template_parameter_name = function(param) {
      var def, name, ret, tp;
      param = $(param);
      name = param.attr('name');
      def = param.attr('default');
      tp = param.children('type');
      ret = '';
      if (tp.length > 0) {
        ret += (new cldoc.Type(tp)).as_text() + ' ';
      }
      ret += name;
      if (def) {
        ret += ' = ' + def;
      }
      return ret;
    };

    MixedIn.prototype.templated_name = function() {
      var name, x;
      name = this.name;
      name += '<';
      name += ((function() {
        var _i, _len, _ref1, _results;
        _ref1 = this.node.children('templatetypeparameter, templatenontypeparameter');
        _results = [];
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          x = _ref1[_i];
          _results.push(this.template_parameter_name(x));
        }
        return _results;
      }).call(this)).join(', ');
      name += '>';
      return name;
    };

    MixedIn.prototype.identifier_for_display = function() {
      return this.templated_name();
    };

    MixedIn.prototype.full_name_for_display = function() {
      return this.templated_name();
    };

    MixedIn.prototype.sidebar_name = function() {
      return this.identifier_for_display();
    };

    MixedIn.prototype.render_arguments = function() {
      var ret, tt, x, _i, _len;
      ret = '<table class="function-template-parameters">';
      tt = this.node.children('templatetypeparameter, templatenontypeparameter');
      for (_i = 0, _len = tt.length; _i < _len; _i++) {
        x = tt[_i];
        x = $(x);
        ret += '<tr>';
        ret += '<td>' + x.attr('name') + '</td>';
        ret += '<td>' + cldoc.Doc.either(x) + '</td>';
        ret += '</tr>';
      }
      ret += '</table>';
      ret += MixedIn.__super__.render_arguments.apply(this, arguments);
      return ret;
    };

    return MixedIn;

  })(base);
  return MixedIn;
};

cldoc.Struct = (function(_super) {
  __extends(Struct, _super);

  Struct.title = ['Struct', 'Structures'];

  Struct.render_container_tag = 'table';

  function Struct(node) {
    this.node = node;
    Struct.__super__.constructor.call(this, this.node);
    if (this.node.attr('typedef')) {
      this.keyword = 'typedef struct';
    } else {
      this.keyword = 'struct';
    }
  }

  Struct.prototype.render = function() {
    if (this.ref || this.node.children('field, method, function, methodtemplate, functiontemplate').length === 0) {
      return this.render_short();
    } else {
      return this.render_whole();
    }
  };

  Struct.prototype.identifier_for_display = function() {
    return this.name;
  };

  Struct.prototype.render_short = function() {
    var e, id, ret;
    e = cldoc.html_escape;
    ret = '<tr class="short">';
    if (this.ref) {
      id = cldoc.Page.make_link(this.ref, this.identifier_for_display());
    } else {
      id = '<span class="identifier">' + e(this.identifier_for_display()) + '</span>';
    }
    ret += '<td>' + id + '</td>';
    ret += '<td>' + cldoc.Doc.brief(this.node) + '</td>';
    return ret + '</tr>';
  };

  Struct.prototype.render_whole = function() {
    var e, id, identifier, isprot, k;
    e = cldoc.html_escape;
    ret += '<tr class="full"><td colspan="2"><div class="item">';
    identifier = this.identifier_for_display();
    id = '<span class="identifier">' + e(identifier) + '</span>';
    k = '<span class="keyword">';
    isprot = this.node.attr('access') === 'protected';
    if (isprot) {
      k += 'protected ';
    }
    k += e(this.keyword) + '</span>';
    ret += '<div id="' + e(identifier) + '">' + k + ' ' + id + '</div>';
    ret += cldoc.Doc.either(this.node);
    ret += this.render_fields();
    ret += this.render_variables();
    return ret + '</div></td></tr>';
  };

  Struct.prototype.render_variables = function() {
    var container, itemsc, variable, variables, _i, _len;
    variables = this.node.children('variable');
    if (variables.length === 0) {
      return '';
    }
    container = cldoc.Variable.render_container();
    itemsc = '';
    for (_i = 0, _len = variables.length; _i < _len; _i++) {
      variable = variables[_i];
      itemsc += new cldoc.Variable($(variable)).render();
    }
    return container[0] + itemsc + container[1];
  };

  Struct.prototype.render_fields = function() {
    var container, field, fields, itemsc, tp, _i, _len;
    fields = this.node.children('field,union');
    if (fields.length === 0) {
      return '';
    }
    container = cldoc.Field.render_container();
    itemsc = '';
    for (_i = 0, _len = fields.length; _i < _len; _i++) {
      field = fields[_i];
      field = $(field);
      tp = cldoc.Page.node_type(field);
      if (tp) {
        itemsc += new tp(field).render();
      }
    }
    return container[0] + itemsc + container[1];
  };

  return Struct;

})(cldoc.Node);

cldoc.Node.types.struct = cldoc.Struct;

cldoc.StructTemplate = (function(_super) {
  __extends(StructTemplate, _super);

  function StructTemplate() {
    return StructTemplate.__super__.constructor.apply(this, arguments);
  }

  return StructTemplate;

})(cldoc.Mixin(cldoc.Struct, cldoc.Templated));

cldoc.Node.types.structtemplate = cldoc.StructTemplate;

cldoc.Class = (function(_super) {
  __extends(Class, _super);

  Class.title = ['Class', 'Classes'];

  function Class(node) {
    this.node = node;
    Class.__super__.constructor.call(this, this.node);
    this.keyword = 'class';
  }

  return Class;

})(cldoc.Struct);

cldoc.Node.types['class'] = cldoc.Class;

cldoc.ClassTemplate = (function(_super) {
  __extends(ClassTemplate, _super);

  function ClassTemplate() {
    return ClassTemplate.__super__.constructor.apply(this, arguments);
  }

  return ClassTemplate;

})(cldoc.Mixin(cldoc.Class, cldoc.Templated));

cldoc.Node.types.classtemplate = cldoc.ClassTemplate;

cldoc.Namespace = (function(_super) {
  __extends(Namespace, _super);

  Namespace.title = ['Namespace', 'Namespaces'];

  function Namespace(node) {
    this.node = node;
    Namespace.__super__.constructor.call(this, this.node);
  }

  Namespace.prototype.render = function() {
    var a, classes, cls, ret, _i, _len;
    ret = '<div class="item">';
    ret += cldoc.Page.make_link(this.ref, this.name, {
      'id': this.id
    });
    ret += new cldoc.Doc(this.brief).render();
    classes = this.node.children('class,struct');
    if (classes.length > 0) {
      ret += '<table class="namespace">';
      for (_i = 0, _len = classes.length; _i < _len; _i++) {
        cls = classes[_i];
        cls = $(cls);
        ret += '<tr>';
        a = cldoc.Page.make_link(cls.attr('ref'), cls.attr('name'));
        ret += '<td>' + a + '</td>';
        ret += '<td class="doc">' + cldoc.Doc.either(cls) + '</td>';
        ret += '</tr>';
      }
      ret += '</table>';
    }
    return ret;
  };

  return Namespace;

})(cldoc.Node);

cldoc.Node.types.namespace = cldoc.Namespace;

cldoc.Typedef = (function(_super) {
  __extends(Typedef, _super);

  Typedef.title = ['Typedef', 'Typedefs'];

  Typedef.render_container_tag = 'table';

  function Typedef(node) {
    this.node = node;
    Typedef.__super__.constructor.call(this, this.node);
  }

  Typedef.prototype.render = function() {
    var e, ret;
    e = cldoc.html_escape;
    ret = '<tr class="typedef" id="' + e(this.id) + '">';
    ret += '<td class="typedef_name identifier">' + e(this.node.attr('name')) + '</td>';
    ret += '<td class="typedef_decl keyword">type</td>';
    ret += '<td class="typedef_type">' + new cldoc.Type(this.node.children('type')).render() + '</td>';
    ret += '</tr>';
    ret += '<tr class="doc">';
    ret += '<td colspan="3">' + cldoc.Doc.either(this.node) + '</td>';
    return ret + '</tr>';
  };

  return Typedef;

})(cldoc.Node);

cldoc.Node.types.typedef = cldoc.Typedef;

cldoc.Variable = (function(_super) {
  __extends(Variable, _super);

  Variable.title = ['Variable', 'Variables'];

  Variable.render_container_tag = 'table';

  function Variable(node) {
    this.node = node;
    Variable.__super__.constructor.call(this, this.node);
  }

  Variable.prototype.render = function() {
    var e, ret;
    e = cldoc.html_escape;
    ret = '<tr id="' + e(this.node.attr('id')) + '">';
    ret += '<td class="variable_name identifier">' + e(this.node.attr('name')) + '</td>';
    ret += '<td class="variable_type">' + new cldoc.Type(this.node.children('type')).render() + '</td>';
    ret += '<td class="doc">' + cldoc.Doc.either(this.node) + '</td>';
    return ret + '</tr>';
  };

  return Variable;

})(cldoc.Node);

cldoc.Node.types.variable = cldoc.Variable;

cldoc.Function = (function(_super) {
  __extends(Function, _super);

  Function.title = ['Function', 'Functions'];

  function Function(node) {
    this.node = node;
    Function.__super__.constructor.call(this, this.node);
  }

  Function.prototype.identifier_for_display = function() {
    return this.name;
  };

  Function.prototype.render_arguments = function() {
    var arg, args, argtype, e, i, ret, retu, returntype, _i, _ref1;
    args = this.node.children('argument');
    ret = '<table class="arguments">';
    retu = this.node.children('return');
    returntype = null;
    if (retu.length > 0) {
      returntype = new cldoc.Type(retu.children('type'));
    }
    e = cldoc.html_escape;
    for (i = _i = 0, _ref1 = args.length - 1; _i <= _ref1; i = _i += 1) {
      arg = $(args[i]);
      argtype = new cldoc.Type(arg.children('type'));
      ret += '<tr id="' + e(arg.attr('id')) + '">';
      ret += '<td>' + e(arg.attr('name')) + '</td>';
      ret += '<td>' + cldoc.Doc.either(arg);
      if (argtype.allow_none) {
        ret += '<span class="annotation">(may be <code>NULL</code>)</span>';
      }
      ret += '</td></tr>';
    }
    if (returntype && returntype.node.attr('name') !== 'void') {
      ret += '<tr class="return">';
      ret += '<td class="keyword">return</td>';
      ret += '<td>' + cldoc.Doc.either(retu);
      if (returntype.transfer_ownership === 'full') {
        ret += '<span class="annotation">(owned by caller)</span>';
      } else if (returntype.transfer_ownership === 'container') {
        ret += '<span class="annotation">(container owned by caller)</span>';
      }
      ret += '</tr>';
    }
    ret += '</table>';
    return ret;
  };

  Function.prototype.render = function() {
    var arg, args, argtype, e, i, isover, isprot, isstat, isvirt, name, ov, override, ret, retu, returntype, _i, _j, _ref1, _ref2;
    e = cldoc.html_escape;
    ret = '<div class="function">';
    ret += '<div class="declaration" id="' + e(this.id) + '">';
    isvirt = this.node.attr('virtual');
    isprot = this.node.attr('access') === 'protected';
    isstat = this.node.attr('static');
    if (isvirt || isprot || isstat) {
      ret += '<ul class="specifiers">';
      if (isstat) {
        ret += '<li class="static">static</li>';
      }
      if (isprot) {
        ret += '<li class="protected">protected</li>';
      }
      if (isvirt) {
        isover = this.node.attr('override');
        if (isover) {
          ret += '<li class="override">override</li>';
        } else {
          ret += '<li class="virtual">virtual</li>';
        }
        if (this.node.attr('abstract')) {
          ret += '<li class="abstract">abstract</li>';
        }
      }
      ret += '</ul>';
    }
    retu = this.node.children('return');
    returntype = null;
    if (retu.length > 0) {
      returntype = new cldoc.Type(retu.children('type'));
      ret += '<div class="return_type">' + returntype.render() + '</div>';
    }
    ret += '<table class="declaration">';
    ret += '<tr><td class="identifier">' + e(this.identifier_for_display()) + '</td>';
    ret += '<td class="open_paren">(</td>';
    args = this.node.children('argument');
    for (i = _i = 0, _ref1 = args.length - 1; _i <= _ref1; i = _i += 1) {
      if (i !== 0) {
        ret += '</tr><tr><td colspan="2"></td>';
      }
      arg = $(args[i]);
      argtype = new cldoc.Type(arg.children('type'));
      ret += '<td class="argument_type">' + argtype.render() + '</td>';
      name = arg.attr('name');
      if (i !== args.length - 1) {
        name += ',';
      }
      ret += '<td class="argument_name">' + e(name) + '</td>';
    }
    if (args.length === 0) {
      ret += '<td colspan="2"></td>';
    }
    ret += '<td class="close_paren">)</td></tr></table></div>';
    ret += cldoc.Doc.either(this.node);
    ret += this.render_arguments();
    override = this.node.children('override');
    if (override.length > 0) {
      ret += '<div class="overrides"><span class="title">Overrides: </span>';
      for (i = _j = 0, _ref2 = override.length - 1; 0 <= _ref2 ? _j <= _ref2 : _j >= _ref2; i = 0 <= _ref2 ? ++_j : --_j) {
        ov = $(override[i]);
        if (i !== 0) {
          if (i === override.length - 1) {
            ret += ' and ';
          } else {
            ret += ', ';
          }
        }
        ret += cldoc.Page.make_link(ov.attr('ref'), ov.attr('name'));
      }
    }
    return ret + '</div>';
  };

  return Function;

})(cldoc.Node);

cldoc.Node.types["function"] = cldoc.Function;

cldoc.FunctionTemplate = (function(_super) {
  __extends(FunctionTemplate, _super);

  function FunctionTemplate() {
    return FunctionTemplate.__super__.constructor.apply(this, arguments);
  }

  return FunctionTemplate;

})(cldoc.Mixin(cldoc.Function, cldoc.Templated));

cldoc.Node.types.functiontemplate = cldoc.FunctionTemplate;

cldoc.Field = (function(_super) {
  __extends(Field, _super);

  Field.title = ['Field', 'Fields'];

  Field.render_container_tag = 'table';

  function Field(node) {
    this.node = node;
    Field.__super__.constructor.call(this, this.node);
  }

  Field.prototype.render = function() {
    var e, ret;
    e = cldoc.html_escape;
    ret = '<tr id="' + e(this.node.attr('id')) + '">';
    ret += '<td class="field_name identifier">' + e(this.node.attr('name')) + '</td>';
    ret += '<td class="field_type">' + new cldoc.Type(this.node.children('type')).render() + '</td>';
    ret += '<td class="doc">' + cldoc.Doc.either(this.node) + '</td>';
    return ret + '</tr>';
  };

  return Field;

})(cldoc.Node);

cldoc.Node.types.field = cldoc.Field;

cldoc.Method = (function(_super) {
  __extends(Method, _super);

  Method.title = ['Member Function', 'Member Functions'];

  function Method(node) {
    this.node = node;
    Method.__super__.constructor.call(this, this.node);
  }

  return Method;

})(cldoc.Function);

cldoc.Node.types.method = cldoc.Method;

cldoc.MethodTemplate = (function(_super) {
  __extends(MethodTemplate, _super);

  function MethodTemplate() {
    return MethodTemplate.__super__.constructor.apply(this, arguments);
  }

  return MethodTemplate;

})(cldoc.Mixin(cldoc.Method, cldoc.Templated));

cldoc.Node.types.methodtemplate = cldoc.MethodTemplate;

cldoc.Constructor = (function(_super) {
  __extends(Constructor, _super);

  Constructor.title = ['Constructor', 'Constructors'];

  function Constructor(node) {
    this.node = node;
    Constructor.__super__.constructor.call(this, this.node);
  }

  return Constructor;

})(cldoc.Method);

cldoc.Node.types.constructor = cldoc.Constructor;

cldoc.Destructor = (function(_super) {
  __extends(Destructor, _super);

  Destructor.title = ['Destructor', 'Destructors'];

  function Destructor(node) {
    this.node = node;
    Destructor.__super__.constructor.call(this, this.node);
  }

  return Destructor;

})(cldoc.Method);

cldoc.Node.types.destructor = cldoc.Destructor;

cldoc.Base = (function(_super) {
  __extends(Base, _super);

  Base.title = ['Base', 'Bases'];

  Base.render_container_tag = 'table';

  function Base(node) {
    var ref;
    this.node = node;
    Base.__super__.constructor.call(this, this.node);
    this.type = this.node.children('type');
    this.access = this.node.attr('access');
    this.name = this.type.attr('name');
    ref = this.type.attr('ref');
    if (ref) {
      this.id = ref.replace('#', '+');
    }
  }

  Base.prototype.render = function() {
    var access, e, ret, type;
    e = cldoc.html_escape;
    ret = '<tr id="' + e(this.id) + '">';
    access = this.access;
    if (access === 'public') {
      access = '';
    }
    type = new cldoc.Type(this.type);
    ret += '<td class="keyword">' + e(access) + '</td>';
    ret += '<td>' + type.render() + '</td>';
    ret += '<td>' + cldoc.Doc.brief(this.node) + '</td>';
    return ret + '</tr>';
  };

  return Base;

})(cldoc.Node);

cldoc.Node.types.base = cldoc.Base;

cldoc.Implements = (function(_super) {
  __extends(Implements, _super);

  Implements.title = ['Implements', 'Implements'];

  Implements.render_container_tag = 'table';

  function Implements(node) {
    var ref;
    this.node = node;
    Implements.__super__.constructor.call(this, this.node);
    this.type = this.node.children('type');
    this.access = this.node.attr('access');
    this.name = this.type.attr('name');
    ref = this.type.attr('ref');
    if (ref) {
      this.id = ref.replace('#', '+');
    }
  }

  Implements.prototype.render = function() {
    var access, e, ret, type;
    e = cldoc.html_escape;
    ret = '<tr id="' + e(this.id) + '">';
    access = this.access;
    if (access === 'public') {
      access = '';
    }
    type = new cldoc.Type(this.type);
    ret += '<td class="keyword">' + e(access) + '</td>';
    ret += '<td>' + type.render() + '</td>';
    ret += '<td>' + cldoc.Doc.brief(this.node) + '</td>';
    return ret + '</tr>';
  };

  return Implements;

})(cldoc.Node);

cldoc.Node.types["implements"] = cldoc.Implements;

cldoc.Subclass = (function(_super) {
  __extends(Subclass, _super);

  Subclass.title = ['Subclass', 'Subclasses'];

  Subclass.render_container_tag = 'table';

  function Subclass(node) {
    this.node = node;
    Subclass.__super__.constructor.call(this, this.node);
    this.access = this.node.attr('access');
  }

  Subclass.prototype.render = function() {
    var access, e, ret;
    e = cldoc.html_escape;
    ret = '<tr id="' + e(this.id) + '">';
    access = this.access;
    if (access === 'public') {
      access = '';
    }
    ret += '<td class="keyword">' + e(access) + '</td>';
    ret += '<td>' + cldoc.Page.make_link(this.ref, this.name) + '</td>';
    ret += '<td>' + cldoc.Doc.brief(this.node) + '</td>';
    ret += '</tr>';
    return ret;
  };

  return Subclass;

})(cldoc.Node);

cldoc.Node.types.subclass = cldoc.Subclass;

cldoc.ImplementedBy = (function(_super) {
  __extends(ImplementedBy, _super);

  ImplementedBy.title = ['Implemented By', 'Implemented By'];

  ImplementedBy.render_container_tag = 'table';

  function ImplementedBy(node) {
    this.node = node;
    ImplementedBy.__super__.constructor.call(this, this.node);
    this.access = this.node.attr('access');
  }

  ImplementedBy.prototype.render = function() {
    var access, e, ret;
    e = cldoc.html_escape;
    ret = '<tr id="' + e(this.id) + '">';
    access = this.access;
    if (access === 'public') {
      access = '';
    }
    ret += '<td class="keyword">' + e(access) + '</td>';
    ret += '<td>' + cldoc.Page.make_link(this.ref, this.name) + '</td>';
    ret += '<td>' + cldoc.Doc.brief(this.node) + '</td>';
    return ret + '</tr>';
  };

  return ImplementedBy;

})(cldoc.Node);

cldoc.Node.types.implementedby = cldoc.ImplementedBy;

cldoc.TemplateTypeParameter = (function(_super) {
  __extends(TemplateTypeParameter, _super);

  function TemplateTypeParameter() {
    return TemplateTypeParameter.__super__.constructor.apply(this, arguments);
  }

  TemplateTypeParameter.title = ['Template Parameter', 'Template Parameters'];

  TemplateTypeParameter.render_container_tag = 'table';

  TemplateTypeParameter.prototype.render = function() {
    var def, e, name, ret, tp;
    e = cldoc.html_escape;
    name = this.name;
    def = this.node.attr('default');
    tp = this.node.children('type');
    ret = '<tr id="' + e(this.id) + '">';
    name = '';
    if (tp.length > 0) {
      name += (new cldoc.Type(tp)).render() + ' ';
    }
    name += e(this.name);
    if (def) {
      name += ' = <span class="constant">' + def + '</span>';
    }
    ret += '<td>' + name + '</td>';
    ret += '<td>' + cldoc.Doc.brief(this.node) + '</td>';
    ret += '</tr>';
    return ret;
  };

  return TemplateTypeParameter;

})(cldoc.Node);

cldoc.Node.types.templatetypeparameter = cldoc.TemplateTypeParameter;

cldoc.Node.types.templatenontypeparameter = cldoc.TemplateTypeParameter;

cldoc.Coverage = (function(_super) {
  __extends(Coverage, _super);

  Coverage.title = ['Coverage', 'Coverage'];

  function Coverage(node) {
    this.node = node;
    Coverage.__super__.constructor.call(this, this.node);
  }

  Coverage.prototype.get_coverage = function(type) {
    var ret;
    ret = {
      documented: parseInt(type.attr('documented')),
      undocumented: parseInt(type.attr('undocumented'))
    };
    ret.total = ret.documented + ret.undocumented;
    ret.percentage = Math.round(100 * ret.documented / ret.total);
    return ret;
  };

  Coverage.prototype.render_sidebar_type = function(type) {
    var a, cov, e, ret, tt, typename;
    typename = type.attr('name');
    cov = this.get_coverage(type);
    e = cldoc.html_escape;
    if (cov.documented === 0 && cov.undocumented === 0) {
      return;
    }
    tt = cov.documented + ' out of ' + cov.total + ' (' + cov.percentage + '%)';
    a = cldoc.Page.make_link(cldoc.Page.current_page + '#' + typename, typename);
    ret = '<li>';
    if (cov.undocumented === 0) {
      ret += '<span class="bullet complete">&#x2713;</span>';
    } else {
      ret += '<span class="bullet incomplete">&#10007;</span>';
    }
    ret += a + '<div class="brief">' + e(tt) + '</div>';
    return ret + '</li>';
  };

  Coverage.prototype.render_sidebar = function() {
    var ret, type, types, _i, _len;
    types = this.node.children('type');
    ret = '';
    for (_i = 0, _len = types.length; _i < _len; _i++) {
      type = types[_i];
      ret += this.render_sidebar_type($(type));
    }
    return ret;
  };

  Coverage.prototype.render_type = function(type) {
    var cov, e, file, line, loc, ret, typename, undoc, _i, _j, _len, _len1, _ref1, _ref2;
    ret = '';
    typename = type.attr('name');
    cov = this.get_coverage(type);
    if (cov.documented === 0 && cov.undocumented === 0) {
      return ret;
    }
    e = cldoc.html_escape;
    ret += '<h3 id="' + e(typename) + '">' + e(typename + ' (' + cov.percentage + '%)') + '</h3>';
    ret += '<table class="coverage">';
    ret += '<tr><td>Documented:</td><td>' + e(cov.documented) + '</td></tr>';
    ret += '<tr><td>Undocumented:</td><td>' + e(cov.undocumented) + '</td></tr>';
    ret += '</table><table class="undocumented">';
    _ref1 = type.children('undocumented');
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      undoc = _ref1[_i];
      undoc = $(undoc);
      ret += '<tr><td>' + e(undoc.attr('id')) + '</td>';
      _ref2 = undoc.children('location');
      for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
        loc = _ref2[_j];
        loc = $(loc);
        file = e(loc.attr('file'));
        line = e(loc.attr('line') + ':' + loc.attr('column'));
        ret += '<td>' + file + '</td><td>' + line + '</td>';
        ret += '</tr><td></td>';
      }
    }
    return ret + '</tr></table>';
  };

  Coverage.prototype.render = function() {
    var ret, type, types, _i, _len;
    types = this.node.children('type');
    ret = '';
    for (_i = 0, _len = types.length; _i < _len; _i++) {
      type = types[_i];
      ret += this.render_type($(type));
    }
    return ret;
  };

  return Coverage;

})(cldoc.Node);

cldoc.Node.types.coverage = cldoc.Coverage;

cldoc.Arguments = (function(_super) {
  __extends(Arguments, _super);

  Arguments.title = ['Arguments', 'Arguments'];

  function Arguments(node) {
    this.node = node;
    Arguments.__super__.constructor.call(this, this.node);
  }

  Arguments.prototype.render_sidebar_function = function(func) {
    var a;
    a = cldoc.Page.make_link(cldoc.Page.current_page + '#' + func.attr('id'), func.attr('name'));
    return '<li>' + a + '</li>';
  };

  Arguments.prototype.render_sidebar = function() {
    var f, funcs, ret, _i, _len;
    funcs = this.node.children('function');
    ret = '';
    for (_i = 0, _len = funcs.length; _i < _len; _i++) {
      f = funcs[_i];
      ret += this.render_sidebar_function($(f));
    }
    return ret;
  };

  Arguments.prototype.render_function = function(func) {
    var e, file, line, loc, misspelled, names, ret, undocumented, x, _i, _len, _ref1;
    e = cldoc.html_escape;
    ret = '<tr class="title" id="' + e(func.attr('id')) + '"> <td class="identifier">' + e(func.attr('name')) + '</td>';
    _ref1 = func.children('location');
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      loc = _ref1[_i];
      loc = $(loc);
      file = e(loc.attr('file'));
      line = e(loc.attr('line') + ':' + loc.attr('column'));
      ret += '<td>' + file + '</td><td>' + line + '</td>';
      ret += '</tr><tr><td></td>';
    }
    ret += '</tr>';
    undocumented = func.children('undocumented');
    if (undocumented.length > 0) {
      names = ((function() {
        var _j, _len1, _results;
        _results = [];
        for (_j = 0, _len1 = undocumented.length; _j < _len1; _j++) {
          x = undocumented[_j];
          _results.push($(x).attr('name'));
        }
        return _results;
      })()).join(', ');
      ret += '<tr class="undocumented"><td>Undocumented arguments:</td>' + '<td colspan="2">' + e(names) + '</td></tr>';
    }
    misspelled = func.children('misspelled');
    if (misspelled.length > 0) {
      names = ((function() {
        var _j, _len1, _results;
        _results = [];
        for (_j = 0, _len1 = undocumented.length; _j < _len1; _j++) {
          x = undocumented[_j];
          _results.push($(x).attr('name'));
        }
        return _results;
      })()).join(', ');
      ret += '<tr class="misspelled"><td>Misspelled arguments:</td>' + '<td colspan="2">' + e(names) + '</td></tr>';
    }
    if (func.children('undocumented-return')) {
      ret += '<tr class="undocumented"><td colspan="3">Undocumented return value</td></tr>';
    }
    return ret;
  };

  Arguments.prototype.render = function() {
    var c, f, funcs, _i, _len;
    funcs = this.node.children('function');
    c = '<table class="function">';
    for (_i = 0, _len = funcs.length; _i < _len; _i++) {
      f = funcs[_i];
      c += this.render_function($(f));
    }
    return c + '</table>';
  };

  return Arguments;

})(cldoc.Node);

cldoc.Node.types["arguments"] = cldoc.Arguments;

cldoc.Report = (function(_super) {
  __extends(Report, _super);

  Report.title = ['Report', 'Report'];

  function Report(node) {
    this.node = node;
    Report.__super__.constructor.call(this, this.node);
  }

  Report.prototype.render_sidebar = function() {
    return '<li>' + cldoc.Page.make_link(this.ref, this.name) + '</li>';
  };

  Report.prototype.render = function(container) {};

  return Report;

})(cldoc.Node);

cldoc.Node.types.report = cldoc.Report;

cldoc.References = (function(_super) {
  __extends(References, _super);

  References.title = ['References', 'References'];

  References.render_container_tag = 'table';

  function References(node) {
    this.node = node;
    References.__super__.constructor.call(this, this.node);
  }

  References.prototype.render_sidebar = function() {
    var a, child, e, ret, _i, _len, _ref1;
    ret = '';
    e = cldoc.html_escape;
    _ref1 = this.node.children();
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      child = _ref1[_i];
      child = $(child);
      a = cldoc.Page.make_link(cldoc.Page.current_page + '#ref-' + child.attr('id'), child.attr('name'));
      ret += '<li><span class="keyword">' + e(cldoc.tag(child)[0]) + ' ' + a + '</span></li>';
    }
    return ret;
  };

  References.prototype.render = function() {
    var child, component, e, file, id, kw, line, loc, name, refs, ret, tp, x, _i, _j, _k, _len, _len1, _len2, _ref1, _ref2, _ref3;
    ret = '';
    e = cldoc.html_escape;
    _ref1 = this.node.children();
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      child = _ref1[_i];
      child = $(child);
      kw = '<span class="keyword">' + e(cldoc.tag(child)[0]) + '&nbsp;' + '</span>';
      id = '<span class="identifier">' + e(child.attr('id')) + '</span>';
      ret += '<tr id="' + e('ref-' + child.attr('id')) + '"><td class="title">' + kw + id + '</td>';
      _ref2 = child.children('location');
      for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
        loc = _ref2[_j];
        loc = $(loc);
        file = e(loc.attr('file'));
        line = e(loc.attr('line') + ':' + loc.attr('column'));
        ret += '<td>' + file + '</td>';
        ret += '<td>' + line + '</td>';
        ret += '</tr><tr><td></td>';
      }
      ret += '</tr>';
      _ref3 = child.children('doctype');
      for (_k = 0, _len2 = _ref3.length; _k < _len2; _k++) {
        tp = _ref3[_k];
        tp = $(tp);
        name = tp.attr('name');
        component = tp.attr('component');
        if (component) {
          name += '.' + component;
        }
        refs = ((function() {
          var _l, _len3, _ref4, _results;
          _ref4 = tp.children('ref');
          _results = [];
          for (_l = 0, _len3 = _ref4.length; _l < _len3; _l++) {
            x = _ref4[_l];
            _results.push($(x).attr('name'));
          }
          return _results;
        })()).join(', ');
        ret += '<tr class="missing">';
        ret += '<td>' + e(name) + '</td>';
        ret += '<td>' + e(refs) + '</td>';
        ret += '<td></td>';
        ret += '</tr>';
      }
    }
    return ret;
  };

  return References;

})(cldoc.Node);

cldoc.Node.types.references = cldoc.References;

cldoc.Union = (function(_super) {
  __extends(Union, _super);

  Union.title = ['Union', 'Unions'];

  Union.render_container_tag = 'table';

  function Union(node) {
    this.node = node;
    Union.__super__.constructor.call(this, this.node);
  }

  Union.prototype.render = function() {
    var child, ret, tp, _i, _len, _ref1;
    ret = '<tr class="union">';
    ret += '<td><span class="keyword">union</span></td>';
    ret += '<td></td>';
    ret += '<td class="doc">' + cldoc.Doc.either(this.node) + '</td>';
    ret += '</tr><tr><td colspan="3"><table class="fields union">';
    _ref1 = this.node.children();
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      child = _ref1[_i];
      child = $(child);
      tp = cldoc.Page.node_type(child);
      if (tp) {
        ret += new tp(child).render();
      }
    }
    return ret + '</table></td></tr>';
  };

  return Union;

})(cldoc.Node);

cldoc.Node.types.union = cldoc.Union;

cldoc.GObjectClass = (function(_super) {
  __extends(GObjectClass, _super);

  GObjectClass.title = ['GObject Class', 'GObject Classes'];

  function GObjectClass(node) {
    this.node = node;
    GObjectClass.__super__.constructor.call(this, this.node);
    this.keyword = 'struct';
  }

  return GObjectClass;

})(cldoc.Class);

cldoc.Node.types['gobject:class'] = cldoc.GObjectClass;

cldoc.GObjectInterface = (function(_super) {
  __extends(GObjectInterface, _super);

  GObjectInterface.title = ['GObject Interface', 'GObject Interfaces'];

  function GObjectInterface(node) {
    this.node = node;
    GObjectInterface.__super__.constructor.call(this, this.node);
    this.keyword = 'interface';
  }

  return GObjectInterface;

})(cldoc.Class);

cldoc.Node.types['gobject:interface'] = cldoc.GObjectInterface;

cldoc.GObjectBoxed = (function(_super) {
  __extends(GObjectBoxed, _super);

  GObjectBoxed.title = ['GObject Boxed Structure', 'GObject Boxed Structures'];

  function GObjectBoxed(node) {
    this.node = node;
    GObjectBoxed.__super__.constructor.call(this, this.node);
    this.keyword = 'struct';
  }

  return GObjectBoxed;

})(cldoc.Struct);

cldoc.Node.types['gobject:boxed'] = cldoc.GObjectBoxed;

cldoc.GObjectProperty = (function(_super) {
  __extends(GObjectProperty, _super);

  GObjectProperty.title = ['GObject Property', 'GObject Properties'];

  GObjectProperty.render_container_tag = 'table';

  function GObjectProperty(node) {
    this.node = node;
    GObjectProperty.__super__.constructor.call(this, this.node);
  }

  GObjectProperty.prototype.render = function() {
    var e, mode, ret, x, _i, _len, _ref1;
    e = cldoc.html_escape;
    ret = '<tr id="' + this.node.attr('id') + '">';
    ret += '<td class="gobject_property_name identifier">' + e(this.node.attr('name')) + '</td>';
    mode = this.node.attr('mode');
    ret += '<td class="gobject_property_mode">';
    if (mode) {
      ret += '<ul class="gobject_property_mode">';
      _ref1 = mode.split(',');
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        x = _ref1[_i];
        ret += '<li class="keyword">' + e(x) + '</li>';
      }
      ret += '</ul>';
    }
    ret += '<td class="gobject_property_type">' + new cldoc.Type(this.node.children('type')).render() + '</td>';
    ret += '<td class="doc">' + cldoc.Doc.either(this.node) + '</td>';
    return ret + '</tr>';
  };

  return GObjectProperty;

})(cldoc.Node);

cldoc.Node.types['gobject:property'] = cldoc.GObjectProperty;
