#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys

from distutils.core import setup

import clint

def publish():
    """Publish to PyPi"""
    os.system("python setup.py sdist upload")

if sys.argv[-1] == "publish":
    publish()
    sys.exit()

required = []

setup(
    name='clint2',
    version=clint.__version__,
    description='Python Command-line Application Tools',
    long_description=open('README.rst').read() + '\n\n' +
                     open('HISTORY.rst').read(),
    author='Mahdi Yusuf',
    author_email='yusuf.mahdi@gmail.com',
    url='https://github.com/myusuf3/clint',
    data_files=[
        'README.rst',
        'HISTORY.rst',
    ],
    packages= [
        'clint',
        'clint.textui',
        'clint.packages', 'clint.packages.colorama'
    ],
    install_requires=required,
    license='ISC',
    classifiers=(
#       'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: ISC License (ISCL)',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.5',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.1',
        'Programming Language :: Python :: 3.2',
        'Topic :: Terminals :: Terminal Emulators/X Terminals',
    ),
)
