<%inherit file="home_comp.mako"/>

<h3>Imprint</h3>

<p>
    Below is the information required by law about the web site of
    ${request.dataset.name}
    (${request.host_url}), an electronic resource published by the
    ${request.dataset.publisher_name} (${request.dataset.publisher_url})
    as well as important legal points.
</p>

<h4>Provider Identification for this Internet Website</h4>
<p>
    The following provides mandatory data concerning the provider of this website,
    obligations with regard to data protection, as well as other important legal
    references involving the websites of the Max-Planck-Gesellschaft zur Förderung der
    Wissenschaften e.V. (http://www.mpg.de/).
</p>
<h5>Provider</h5>
<p>
    The provider of this website within the legal meaning of the term is the registered
    association Max Planck Society for the Advancement of Science (Max-Planck
    Gesellschaft zur Förderung der Wissenschaften e.V.).
</p>
<dl>
    <dt>Address:</dt>
    <dd>
        <address>
            Max-Planck-Gesellschaft zur Förderung der Wissenschaften e.V.<br/>
            Hofgartenstrasse 8<br/>
            80539 Munich<br/>
            Germany<br/>
        </address>
    </dd>
    <dt>Phone:</dt>
    <dd>+49 089 21 08 - 0</dd>
    <dt>Internet:</dt>
    <dd>http://www.mpg.de/</dd>
    <dt>e-mail:</dt>
    <dd>presse@gv.mpg.de</dd>
</dl>
<h5>Register of Societies and Associations</h5>
<p>
    The Max Planck Society is registered in the Official Register of Societies and
    Associations at Berlin-Charlottenburg Local Court under the register number
    VR&nbsp;13378&nbsp;B.
</p>
<h5>Legal Representation</h5>
<p>
    The Max Planck Society is legally represented by its Board of Directors, which, in
    turn, is represented by the President of the Society, Professor Martin Stratmann, and by
    Secretary General Dr. Ludwig Kronthaler.
</p>
<h5>Value added tax identification number</h5>
<p>
    The value added tax identification number of the Max Planck Society is DE 129517720.
</p>
<h5>Editor</h5>
<p>
<p>
    The editor responsible for the information within the scope of the internet presence
    of the ${request.dataset.publisher_name} is:
    <address>
        <strong>Prof. Dr. Martin Haspelmath</strong><br/>
        ${request.dataset.publisher_name}<br/>
        Deutscher Platz 6<br/>
        04103 Leipzig<br/>
        Tel.: +49 (341) 3550 - 307
    </address>
</p>
<h5>Legal Structure</h5>
<p>
    The Max Planck Society is a non-profit research facility, which is organized as a
    registered association. All of the institutes and facilities of the Max Planck Society
    are largely autonomous in terms of organization and research, but as a rule have no
    legal capacity of their own.
</p>
<h4>Data Protection</h4>
<h5>Data Collection and Processing</h5>
<p>
    Visits to this website are logged. The anonymized IP address currently used by your
    computer, as well as further technical data pertaining to the data call is recorded.
</p>
<p>
    Data is evaluated only for statistical purposes in anonymized form. No personal user
    profiles are created.
</p>
<p>
    Session cookies are used within the scope of this Internet session for technical
    reasons. This data is deleted at the latest when you close your browser.
</p>
<p>
    The data protection officer of the Max Planck Society is available for questions
    concerning the topic of data protection at dsb@gv.mpg.de or +49 (0) 89-2108-1317.
</p>
<h5>Data Transmission</h5>
<p>
    Your personal data will only be transmitted to government organizations and
    authorities in legally required cases and/or for prosecution in the event of
    attacks on our network infrastructure. Your personal data are not provided to
    third parties for any other purpose.
</p>
<h4>Liability for Contents of Online Information</h4>
<p>
    In accordance with Section 7 Paragraph 1 of the Tele-Media Law, the Max Planck Society
    shall be responsible for its own contents according to general legal provisions.
    The Max Planck Society makes every effort to provide timely and accurate information
    on this Website. Nevertheless, errors and inaccuracies cannot be completely ruled out.
    Therefore, the Max Planck Society does not assume any liability for the information
    provided being up-to-date as well as its accuracy, completeness or quality. The
    Max Planck Society shall not be liable for damage of a tangible or intangible nature
    caused directly or indirectly through the use or failure to use the information
    offered and/or through the use of faulty or incomplete information unless it is
    verifiably culpable of intent or gross negligence. The same shall apply to any
    software downloads available free of charge. The Max Planck Society reserves the
    right to modify, supplement, or delete any or all of the information offered on its
    Website, or to temporarily or permanently cease publication thereof without prior and
    separate notification.
</p>
<h4>Links to Websites of Third Parties</h4>
<p>
    This Website includes links to other external websites. These external links are
    designated with an icon as follows:
    ${h.external_link('http://example.org', 'external link')}.
    References to the subordinate pages of this Website are designated without an icon as
    follows: <a href="#">internal link example</a>.
</p>
<p>
    The respective provider shall be responsible for the contents of any linked external
    pages. In establishing the initial link, the Max Planck Society has reviewed the
    respective external content in order to determine whether such link entailed possible
    civil or criminal responsibility. However, a constant review of linked external pages
    is unreasonable without concrete indication of a violation of rights. If the
    Max Planck Society discovers or is pointed out by others that an external offer
    linked to by the Max Planck Society causes civil or criminal responsibility, the
    Max Planck Society will immediately eliminate any link to this offer. The Max Planck
    Society expressly dissociates itself from such contents.
</p>
