#!/usr/bin/env python2.7
# -*- coding: UTF-8 -*-
# vim: fileencoding=UTF-8 filetype=python ff=unix expandtab sw=4 sts=4 tw=120
# author: Christer Sjöholm -- hcs AT furuvik DOT net

from setuptools import setup, find_packages
import sys, os

here = os.path.abspath(os.path.dirname(__file__))
README = open(os.path.join(here, 'README.txt')).read()
NEWS = open(os.path.join(here, 'NEWS.txt')).read()

class UltraMagicString(object):
    ''' Stolen from http://stackoverflow.com/questions/1162338/whats-the-right-way-to-use-unicode-metadata-in-setup-py

    Catch-22:
    - if I return Unicode, python setup.py --long-description as well
      as python setup.py upload fail with a UnicodeEncodeError
    - if I return UTF-8 string, python setup.py sdist register
      fails with an UnicodeDecodeError
    '''

    def __init__(self, value):
        self.value = value

    def __str__(self):
        return self.value

    def __unicode__(self):
        return self.value.decode('UTF-8')

    def __add__(self, other):
        return UltraMagicString(self.value + str(other))

    def split(self, *args, **kw):
        return self.value.split(*args, **kw)

install_requires = [
    # List your project dependencies here.
    # For more details, see:
    # http://packages.python.org/distribute/setuptools.html#declaring-dependencies
    'rl>=1.12',
    'simplejson>=2.1.1',
    'storm>=0.17',
    'hcs_utils>=1.3a2',
]

setup(name='clog',
      version = '2.0',
      description = 'combined command-line work-log/diary and todo manager',
      long_description=UltraMagicString(README + '\n\n' + NEWS),
      maintainer = UltraMagicString('Christer Sjöholm'),
      maintainer_email = 'hcs AT furuvik DOT net',
      #url = '',
      download_url = 'http://pypi.python.org/pypi/clog',
      classifiers = [f.strip() for f in """
        Development Status :: 3 - Alpha
        Environment :: Console
        License :: OSI Approved :: ISC License (ISCL)
        Operating System :: OS Independent
        Programming Language :: Python
        Programming Language :: Python :: 2.7
        Intended Audience :: Developers
        Intended Audience :: End Users/Desktop
        Intended Audience :: System Administrators
        Topic :: Utilities
        """.splitlines() if f.strip()],
        # Get strings from http://pypi.python.org/pypi?%3Aaction=list_classifiers
      install_requires = install_requires,
      packages = find_packages(),
      entry_points = {'console_scripts': [ 'clog = clog.application:main']}
     )

