#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# vim: fileencoding=UTF-8 filetype=python ff=unix et ts=4 sw=4 sts=4 tw=120
# author: Christer Sjöholm -- hcs AT furuvik DOT net

import codecs
import os
import subprocess
import sys
import tempfile

EDIT_HELP = """To abort, exit without saving.\n"""
EDIT_HELP_SEPARATOR = '--This line, and those below, will be ignored--'

def _fields_to_str(fields, body_field, edit_help=False):
    parts = []
    for (key, value) in fields.iteritems():
        if key == body_field:
            continue
        parts.append('{0}: {1}'.format(key, value))
    parts.append('')
    parts.append(fields.setdefault(body_field, '').rstrip())
    if edit_help:
        parts.append(EDIT_HELP_SEPARATOR)
        parts.append(EDIT_HELP)
    return '\n'.join(parts)

def _str_to_fields(str_, body_field):
    fields = {}
    body = []
    headers_finished = False
    for line in str_.splitlines():
        line = line.rstrip()
        if not headers_finished:
            if not line:
                headers_finished = True
            else:
                name, _, content = line.partition(':')
                content = content.strip()
                fields[name] = content
        elif line == EDIT_HELP_SEPARATOR:
            break # Ignore the rest
        else:
            body.append(line)
    fields[body_field] = '\n'.join(body)
    return fields

def edit_mailstyle(fields, body_field):
    '''fields is a dict and should have a "body" key, that is presented as a mail body
    all other item pairs are presented and mail properties.'''
    (fd, path) = tempfile.mkstemp()
    with os.fdopen(fd,'w') as f:
        f.write(_fields_to_str(fields, body_field, edit_help=True).encode('utf8'))
    try:
        retcode = subprocess.call("vim %s +5" % path, shell=True)
        if retcode < 0:
            print >> sys.stderr, "Child was terminated by signal", -retcode
        else:
            print >> sys.stderr, "Child returned", retcode
    except OSError, e:
        print >> sys.stderr, "Execution failed:", e
    with codecs.open(path, encoding='utf8') as inp:
        fields2 = _str_to_fields(inp.read(), body_field)
    return fields2


def edit_entry(entry, body_field='note'):
    fields = entry.to_dict()
    fields2 = edit_mailstyle(fields, body_field)
    has_changed = fields != fields2
    if has_changed:
        entry.update(fields2)
        return True
    return False



