/*
 * Decompiled with CFR 0.152.
 */
package org.clonedigger.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.clonedigger.Activator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.framework.Bundle;
import org.python.pydev.navigator.elements.IWrappedResource;

public class DigAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IPageChangedListener {
    boolean WINDOWS = File.separatorChar == '\\';
    Set<String> selectedFiles = new LinkedHashSet<String>();
    Set<IResource> selectedResources = new LinkedHashSet<IResource>();
    Set<IResource> grayedResources = new LinkedHashSet<IResource>();
    Process digProcess = null;
    Thread digThread = null;
    private String htmFile;
    private ProcessBuilder pb;
    private DigWizard digWizard;

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.digWizard = new DigWizard();
        WizardDialog wd = new WizardDialog(shell, (IWizard)this.digWizard);
        wd.addPageChangedListener((IPageChangedListener)this);
        wd.open();
    }

    public void selectResource(IResource res, boolean select) {
        if (res == null) {
            return;
        }
        if (select && this.selectedResources.contains(res) && !this.grayedResources.contains(res)) {
            return;
        }
        if (res instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)res).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource subRes = iResourceArray[n2];
                    this.selectResource(subRes, select);
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        } else if (res instanceof IFile) {
            if (select) {
                this.selectedFiles.add(res.getLocation().toOSString());
            } else {
                this.selectedFiles.remove(res.getLocation().toOSString());
            }
        }
        if (select) {
            this.selectedResources.add(res);
        } else {
            this.selectedResources.remove(res);
        }
        this.grayedResources.remove(res);
        res = res.getParent();
        while (res != null) {
            this.selectedResources.add(res);
            this.grayedResources.add(res);
            res = res.getParent();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        this.selectedFiles.clear();
        this.selectedResources.clear();
        this.grayedResources.clear();
        action.setEnabled(true);
        Object[] objectArray = sel.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object unwrap;
            Object obj = objectArray[n2];
            IResource res = null;
            if (obj instanceof IResource) {
                res = (IResource)obj;
            }
            if (obj instanceof IWrappedResource && (unwrap = ((IWrappedResource)obj).getActualObject()) instanceof IResource) {
                res = (IResource)unwrap;
            }
            if (obj instanceof IJavaElement) {
                res = ((IJavaElement)obj).getResource();
            }
            this.selectResource(res, true);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageChanged(PageChangedEvent event) {
        IDialogPage page = (IDialogPage)event.getSelectedPage();
        if (!(page instanceof ConsolePage)) {
            Activator activator = Activator.getDefault();
            synchronized (activator) {
                if (this.digThread == null) {
                    return;
                }
                if (this.digProcess != null) {
                    try {
                        this.digProcess.destroy();
                        this.digProcess.waitFor();
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                    }
                }
                return;
            }
        }
        int langidx = this.digWizard.resourcePage.langCombo.getSelectionIndex();
        ConsolePage consolePage = (ConsolePage)page;
        consolePage.console.setText("");
        consolePage.setPageComplete(false);
        String ohtmFile = "";
        File flistFile = null;
        try {
            File tmpfile = File.createTempFile("cde_output", ".htm");
            this.htmFile = tmpfile.getAbsolutePath();
            tmpfile.deleteOnExit();
            tmpfile = File.createTempFile("cde_output_o", ".htm");
            ohtmFile = tmpfile.getAbsolutePath();
            tmpfile.deleteOnExit();
            flistFile = File.createTempFile("cde_flist", ".lst");
            flistFile.deleteOnExit();
            BufferedWriter flistStream = new BufferedWriter(new FileWriter(flistFile));
            for (String f : this.selectedFiles) {
                f = f.replaceAll("\\\\", "/");
                if (langidx == 0 && f.endsWith(".py")) {
                    flistStream.write(String.valueOf(f) + "\n");
                }
                if (langidx != 1 || !f.endsWith(".java")) continue;
                flistStream.write(String.valueOf(f) + "\n");
            }
            flistStream.flush();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        Bundle bundle = Platform.getBundle((String)"org.clonedigger");
        String runpath = "";
        try {
            runpath = FileLocator.toFileURL((URL)bundle.getEntry("runclonedigger.py")).getPath();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        if (this.WINDOWS) {
            runpath = runpath.replaceAll("^/+", "");
        }
        this.pb = new ProcessBuilder(new String[0]);
        this.pb.command().add("python");
        this.pb.command().add(runpath);
        if (langidx == 1) {
            this.pb.command().add("--lang=java");
        }
        if (this.digWizard.resourcePage.fastMode.getSelection()) {
            this.pb.command().add("--fast");
        }
        this.pb.command().add("--size-threshold=" + this.digWizard.resourcePage.cloneSize.getSelection());
        this.pb.command().add("--distance-threshold=" + this.digWizard.resourcePage.cloneDist.getSelection());
        this.pb.command().add("--output=" + ohtmFile);
        this.pb.command().add("--eclipse-output=" + this.htmFile);
        this.pb.command().add("--file-list=" + flistFile.getAbsolutePath());
        this.pb.redirectErrorStream(true);
        String ppath = String.valueOf(new File(runpath).getParent()) + "/CloneDigger";
        this.pb.environment().put("PYTHONPATH", ppath);
        System.out.println("pythonexec: " + this.pb.command().toString());
        consolePage.console.append("Running clonedigger...\n\n");
        Object object = Activator.getDefault();
        synchronized (object) {
            this.digWizard.resourcePage.setPageComplete(false);
            this.digThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        final char[] buf = new char[1024];
                        do {
                            try {
                                int len;
                                InputStreamReader pi;
                                Activator activator = Activator.getDefault();
                                synchronized (activator) {
                                    DigAction.this.digProcess = DigAction.this.pb.start();
                                    pi = new InputStreamReader(DigAction.this.digProcess.getInputStream(), "CP866");
                                }
                                while ((len = pi.read(buf)) >= 0) {
                                    Display.getDefault().syncExec(new Runnable(){

                                        public void run() {
                                            if (DigAction.this.digWizard != null) {
                                                consolePage.console.append(new String(buf, 0, len));
                                            }
                                        }
                                    });
                                }
                            }
                            catch (IOException e) {
                                Activator.log(e);
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    if (DigAction.this.digWizard != null) {
                                        consolePage.console.append("\n");
                                    }
                                }
                            });
                            try {
                                DigAction.this.digProcess.waitFor();
                            }
                            catch (InterruptedException e) {
                                Activator.log(e);
                            }
                        } while (DigAction.this.digProcess.exitValue() == 143);
                        Display.getDefault().syncExec(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Activator activator = Activator.getDefault();
                                synchronized (activator) {
                                    if (DigAction.this.digWizard != null) {
                                        ((DigAction)(this).DigAction.this).digWizard.resourcePage.setPageComplete(true);
                                        if (new File(DigAction.this.htmFile).exists() && new File(DigAction.this.htmFile).length() != 0L) {
                                            consolePage.console.append("Press finish to view results...");
                                            consolePage.setPageComplete(true);
                                        } else {
                                            consolePage.console.append("No output found...");
                                        }
                                    }
                                    (this).DigAction.this.digProcess = null;
                                    (this).DigAction.this.digThread = null;
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        Activator activator = Activator.getDefault();
                        synchronized (activator) {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    if (DigAction.this.digWizard != null) {
                                        ((DigAction)(this).DigAction.this).digWizard.resourcePage.setPageComplete(true);
                                    }
                                }
                            });
                            DigAction.this.digProcess = null;
                            DigAction.this.digThread = null;
                        }
                        Activator.log(e);
                    }
                }
            });
            this.digThread.start();
        }
    }

    class ConsolePage
    extends WizardPage {
        Text console;

        public ConsolePage() {
            super("ConsolePage");
            this.setTitle("Running clonedigger");
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            int ncol;
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = ncol = 1;
            composite.setLayout((Layout)gl);
            this.console = new Text(composite, 2634);
            this.console.setLayoutData((Object)new GridData(1808));
            this.console.setBackground(new Color(null, 0, 0, 0));
            this.console.setForeground(new Color(null, 255, 255, 255));
            this.setControl((Control)composite);
        }
    }

    class DigWizard
    extends Wizard {
        public ResourcesPage resourcePage;
        public ConsolePage consolePage;

        DigWizard() {
        }

        public void addPages() {
            super.addPages();
            this.resourcePage = new ResourcesPage();
            this.addPage((IWizardPage)this.resourcePage);
            this.consolePage = new ConsolePage();
            this.addPage((IWizardPage)this.consolePage);
            this.setWindowTitle("Dig clones");
        }

        public boolean performFinish() {
            if (new File(DigAction.this.htmFile).exists()) {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    WebBrowserEditorInput htmInput = null;
                    htmInput = new WebBrowserEditorInput(new URL("file:/" + DigAction.this.htmFile.replaceAll("^/+", "")), 0);
                    page.openEditor((IEditorInput)htmInput, "org.clonedigger.resultbrowser");
                }
                catch (MalformedURLException e) {
                    Activator.log(e);
                }
                catch (PartInitException e) {
                    Activator.log(e);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean performCancel() {
            Activator activator = Activator.getDefault();
            synchronized (activator) {
                block7: {
                    if (DigAction.this.digThread != null) break block7;
                    return true;
                }
                if (DigAction.this.digProcess != null) {
                    try {
                        DigAction.this.digProcess.destroy();
                        DigAction.this.digProcess.waitFor();
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                    }
                }
                DigAction.this.digWizard = null;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResourcesPage
    extends WizardPage
    implements ITreeContentProvider,
    ILabelProvider,
    ICheckStateListener {
        private Combo langCombo;
        private CheckboxTreeViewer resourcesTree;
        private ILabelProvider labelProvider;
        private Button fastMode;
        private Spinner cloneSize;
        private Spinner cloneDist;

        public ResourcesPage() {
            super("ResourcesPage");
            this.setTitle("Please select files to dig");
            this.labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.horizontalSpacing = 12;
            composite.setLayout((Layout)gl);
            new Label(composite, 0).setText("Select language:");
            Group opsGroup = new Group(composite, 1);
            opsGroup.setText("Dig options");
            opsGroup.setLayout((Layout)new GridLayout(5, false));
            GridData gd = new GridData(1);
            gd.verticalSpan = 2;
            opsGroup.setLayoutData((Object)gd);
            this.fastMode = new Button((Composite)opsGroup, 32);
            this.fastMode.setText("Fast mode");
            this.fastMode.setToolTipText("Find only clones, which differ in variable and function names and constants.Use this option if you don't want to wait.");
            Label label = new Label((Composite)opsGroup, 0);
            label.setText("  Clone size:");
            label.setToolTipText("The minimum clone size (in lines of code)");
            this.cloneSize = new Spinner((Composite)opsGroup, 2048);
            this.cloneSize.setMinimum(1);
            this.cloneSize.setMaximum(99);
            this.cloneSize.setTextLimit(2);
            this.cloneSize.setToolTipText(label.getToolTipText());
            label = new Label((Composite)opsGroup, 0);
            label.setText("  Clone distance:");
            label.setToolTipText("The maximum amount of differences between fragments in clone pair");
            this.cloneDist = new Spinner((Composite)opsGroup, 2048);
            this.cloneDist.setMinimum(1);
            this.cloneDist.setMaximum(99);
            this.cloneDist.setTextLimit(2);
            this.cloneDist.setToolTipText(label.getToolTipText());
            this.langCombo = new Combo(composite, 2056);
            this.langCombo.add("Python");
            this.langCombo.add("Java");
            this.langCombo.select(0);
            gd = new GridData(256);
            this.langCombo.setLayoutData((Object)gd);
            this.langCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (ResourcesPage.this.resourcesTree != null) {
                        ResourcesPage.this.resourcesTree.refresh();
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    if (ResourcesPage.this.resourcesTree != null) {
                        ResourcesPage.this.resourcesTree.refresh();
                        ResourcesPage.this.resourcesTree.setCheckedElements(ResourcesPage.this.filterValidItems(((ResourcesPage)ResourcesPage.this).DigAction.this.selectedResources));
                        ResourcesPage.this.resourcesTree.setGrayedElements(ResourcesPage.this.filterValidItems(((ResourcesPage)ResourcesPage.this).DigAction.this.grayedResources));
                    }
                    if (ResourcesPage.this.langCombo.getSelectionIndex() == 0) {
                        ResourcesPage.this.cloneSize.setSelection(5);
                        ResourcesPage.this.cloneDist.setSelection(5);
                    } else {
                        ResourcesPage.this.cloneSize.setSelection(10);
                        ResourcesPage.this.cloneDist.setSelection(7);
                    }
                }
            });
            this.langCombo.notifyListeners(13, new Event());
            label = new Label(composite, 0);
            label.setText("Select files:");
            gd = new GridData(1);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            this.resourcesTree = new CheckboxTreeViewer(composite);
            this.resourcesTree.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
            this.resourcesTree.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

                public Object[] getChildren(Object o) {
                    if (o instanceof IContainer) {
                        IResource[] members = null;
                        try {
                            members = ((IContainer)o).members();
                        }
                        catch (CoreException coreException) {
                            return new Object[0];
                        }
                        ArrayList<IResource> results = new ArrayList<IResource>();
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            if (member instanceof IFile) {
                                if (((IFile)member).getFileExtension() != null && (ResourcesPage.this.langCombo.getSelectionIndex() == 0 && ((IFile)member).getFileExtension().equals("py") || ResourcesPage.this.langCombo.getSelectionIndex() == 1 && ((IFile)member).getFileExtension().equals("java"))) {
                                    results.add(member);
                                }
                            } else {
                                results.add(member);
                            }
                            ++n2;
                        }
                        return results.toArray();
                    }
                    return new Object[0];
                }
            });
            this.resourcesTree.addCheckStateListener((ICheckStateListener)this);
            this.resourcesTree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.resourcesTree.getControl().setLayoutData((Object)gd);
            this.resourcesTree.refresh();
            this.resourcesTree.setCheckedElements(this.filterValidItems(DigAction.this.selectedResources));
            this.resourcesTree.setGrayedElements(this.filterValidItems(DigAction.this.grayedResources));
            this.setControl((Control)composite);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IContainer) {
                try {
                    return ((IContainer)parentElement).members();
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IContainer) {
                try {
                    return ((IContainer)element).members().length > 0;
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IContainer) {
                try {
                    return ((IContainer)inputElement).members();
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return this.labelProvider.getImage(element);
        }

        public String getText(Object element) {
            return this.labelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.labelProvider.addListener(listener);
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.labelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.labelProvider.removeListener(listener);
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean checked = event.getChecked();
            IResource res = (IResource)event.getElement();
            DigAction.this.selectResource(res, checked);
            this.resourcesTree.setCheckedElements(this.filterValidItems(DigAction.this.selectedResources));
            this.resourcesTree.setGrayedElements(this.filterValidItems(DigAction.this.grayedResources));
        }

        public Object[] filterValidItems(Collection<IResource> src) {
            ArrayList<IResource> results = new ArrayList<IResource>();
            for (IResource member : src) {
                if (member instanceof IFile) {
                    if (((IFile)member).getFileExtension() == null || (this.langCombo.getSelectionIndex() != 0 || !((IFile)member).getFileExtension().equals("py")) && (this.langCombo.getSelectionIndex() != 1 || !((IFile)member).getFileExtension().equals("java"))) continue;
                    results.add(member);
                    continue;
                }
                results.add(member);
            }
            return results.toArray();
        }
    }
}

