"""Install system programs not available from packages.
"""
import os

from fabric.api import *
from fabric.contrib.files import *

from shared import _if_not_installed, _get_install, _configure_make

@_if_not_installed("s3fs")
def install_s3fs(env):
    """FUSE-based file system backed by Amazon S3.
    https://code.google.com/p/s3fs/
    """
    version = "1.61"
    url = "http://s3fs.googlecode.com/files/s3fs-{0}.tar.gz".format(version)
    _get_install(url, env, _configure_make)
