
"""Lists site to site vpn customer gateways"""
from baseCmd import *
from baseResponse import *
class listVpnCustomerGatewaysCmd (baseCmd):
    def __init__(self):
        self.isAsync = "false"
        """List resources by account. Must be used with the domainId parameter."""
        self.account = None
        """list only resources belonging to the domain specified"""
        self.domainid = None
        """id of the customer gateway"""
        self.id = None
        """defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves."""
        self.isrecursive = None
        """List by keyword"""
        self.keyword = None
        """If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false"""
        self.listall = None
        """"""
        self.page = None
        """"""
        self.pagesize = None
        """list objects by project"""
        self.projectid = None
        self.required = []

class listVpnCustomerGatewaysResponse (baseResponse):
    def __init__(self):
        """the vpn gateway ID"""
        self.id = None
        """the owner"""
        self.account = None
        """guest cidr list of the customer gateway"""
        self.cidrlist = None
        """the domain name of the owner"""
        self.domain = None
        """the domain id of the owner"""
        self.domainid = None
        """if DPD is enabled for customer gateway"""
        self.dpd = None
        """Lifetime of ESP SA of customer gateway"""
        self.esplifetime = None
        """IPsec policy of customer gateway"""
        self.esppolicy = None
        """public ip address id of the customer gateway"""
        self.gateway = None
        """Lifetime of IKE SA of customer gateway"""
        self.ikelifetime = None
        """IKE policy of customer gateway"""
        self.ikepolicy = None
        """guest ip of the customer gateway"""
        self.ipaddress = None
        """IPsec preshared-key of customer gateway"""
        self.ipsecpsk = None
        """name of the customer gateway"""
        self.name = None
        """the project name"""
        self.project = None
        """the project id"""
        self.projectid = None
        """the date and time the host was removed"""
        self.removed = None

