
"""Adds F5 external load balancer appliance."""
from baseCmd import *
from baseResponse import *
class addExternalLoadBalancerCmd (baseCmd):
    def __init__(self):
        self.isAsync = "false"
        """Password of the external load balancer appliance."""
        """Required"""
        self.password = None
        """URL of the external load balancer appliance."""
        """Required"""
        self.url = None
        """Username of the external load balancer appliance."""
        """Required"""
        self.username = None
        """Zone in which to add the external load balancer appliance."""
        """Required"""
        self.zoneid = None
        self.required = ["password","url","username","zoneid",]

class addExternalLoadBalancerResponse (baseResponse):
    def __init__(self):
        """the ID of the external load balancer"""
        self.id = None
        """the management IP address of the external load balancer"""
        self.ipaddress = None
        """the number of times to retry requests to the external load balancer"""
        self.numretries = None
        """the private interface of the external load balancer"""
        self.privateinterface = None
        """the public interface of the external load balancer"""
        self.publicinterface = None
        """the username that's used to log in to the external load balancer"""
        self.username = None
        """the zone ID of the external load balancer"""
        self.zoneid = None

