
"""Adds a netscaler load balancer device"""
from baseCmd import *
from baseResponse import *
class addNetscalerLoadBalancerCmd (baseCmd):
    def __init__(self):
        self.isAsync = "true"
        """Netscaler device type supports NetscalerMPXLoadBalancer, NetscalerVPXLoadBalancer, NetscalerSDXLoadBalancer"""
        """Required"""
        self.networkdevicetype = None
        """Credentials to reach netscaler load balancer device"""
        """Required"""
        self.password = None
        """the Physical Network ID"""
        """Required"""
        self.physicalnetworkid = None
        """URL of the netscaler load balancer appliance."""
        """Required"""
        self.url = None
        """Credentials to reach netscaler load balancer device"""
        """Required"""
        self.username = None
        self.required = ["networkdevicetype","password","physicalnetworkid","url","username",]

class addNetscalerLoadBalancerResponse (baseResponse):
    def __init__(self):
        """the management IP address of the external load balancer"""
        self.ipaddress = None
        """device capacity"""
        self.lbdevicecapacity = None
        """true if device is dedicated for an account"""
        self.lbdevicededicated = None
        """device id of the netscaler load balancer"""
        self.lbdeviceid = None
        """device name"""
        self.lbdevicename = None
        """device state"""
        self.lbdevicestate = None
        """the physical network to which this netscaler device belongs to"""
        self.physicalnetworkid = None
        """Used when NetScaler device is provider of EIP service. This parameter represents the list of pod's, for which there exists a policy based route on datacenter L3 router to route pod's subnet IP to a NetScaler device."""
        self.podids = None
        """the private interface of the load balancer"""
        self.privateinterface = None
        """name of the provider"""
        self.provider = None
        """the public interface of the load balancer"""
        self.publicinterface = None

