
"""configures a F5 load balancer device"""
from baseCmd import *
from baseResponse import *
class configureF5LoadBalancerCmd (baseCmd):
    def __init__(self):
        self.isAsync = "true"
        """F5 load balancer device ID"""
        """Required"""
        self.lbdeviceid = None
        """capacity of the device, Capacity will be interpreted as number of networks device can handle"""
        self.lbdevicecapacity = None
        self.required = ["lbdeviceid",]

class configureF5LoadBalancerResponse (baseResponse):
    def __init__(self):
        """the management IP address of the external load balancer"""
        self.ipaddress = None
        """device capacity"""
        self.lbdevicecapacity = None
        """true if device is dedicated for an account"""
        self.lbdevicededicated = None
        """device id of the F5 load balancer"""
        self.lbdeviceid = None
        """device name"""
        self.lbdevicename = None
        """device state"""
        self.lbdevicestate = None
        """the physical network to which this F5 device belongs to"""
        self.physicalnetworkid = None
        """the private interface of the load balancer"""
        self.privateinterface = None
        """name of the provider"""
        self.provider = None
        """the public interface of the load balancer"""
        self.publicinterface = None

