
"""configures a netscaler load balancer device"""
from baseCmd import *
from baseResponse import *
class configureNetscalerLoadBalancerCmd (baseCmd):
    def __init__(self):
        self.isAsync = "true"
        """Netscaler load balancer device ID"""
        """Required"""
        self.lbdeviceid = None
        """true if netscaler load balancer is intended to be used in in-line with firewall, false if netscaler load balancer will side-by-side with firewall"""
        self.inline = None
        """capacity of the device, Capacity will be interpreted as number of networks device can handle"""
        self.lbdevicecapacity = None
        """true if this netscaler device to dedicated for a account, false if the netscaler device will be shared by multiple accounts"""
        self.lbdevicededicated = None
        """Used when NetScaler device is provider of EIP service. This parameter represents the list of pod's, for which there exists a policy based route on datacenter L3 router to route pod's subnet IP to a NetScaler device."""
        self.podids = []
        self.required = ["lbdeviceid",]

class configureNetscalerLoadBalancerResponse (baseResponse):
    def __init__(self):
        """the management IP address of the external load balancer"""
        self.ipaddress = None
        """device capacity"""
        self.lbdevicecapacity = None
        """true if device is dedicated for an account"""
        self.lbdevicededicated = None
        """device id of the netscaler load balancer"""
        self.lbdeviceid = None
        """device name"""
        self.lbdevicename = None
        """device state"""
        self.lbdevicestate = None
        """the physical network to which this netscaler device belongs to"""
        self.physicalnetworkid = None
        """Used when NetScaler device is provider of EIP service. This parameter represents the list of pod's, for which there exists a policy based route on datacenter L3 router to route pod's subnet IP to a NetScaler device."""
        self.podids = None
        """the private interface of the load balancer"""
        self.privateinterface = None
        """name of the provider"""
        self.provider = None
        """the public interface of the load balancer"""
        self.publicinterface = None

