
"""Configures a SRX firewall device"""
from baseCmd import *
from baseResponse import *
class configureSrxFirewallCmd (baseCmd):
    def __init__(self):
        self.isAsync = "true"
        """SRX firewall device ID"""
        """Required"""
        self.fwdeviceid = None
        """capacity of the firewall device, Capacity will be interpreted as number of networks device can handle"""
        self.fwdevicecapacity = None
        self.required = ["fwdeviceid",]

class configureSrxFirewallResponse (baseResponse):
    def __init__(self):
        """device capacity"""
        self.fwdevicecapacity = None
        """device id of the SRX firewall"""
        self.fwdeviceid = None
        """device name"""
        self.fwdevicename = None
        """device state"""
        self.fwdevicestate = None
        """the management IP address of the external firewall"""
        self.ipaddress = None
        """the number of times to retry requests to the external firewall"""
        self.numretries = None
        """the physical network to which this SRX firewall belongs to"""
        self.physicalnetworkid = None
        """the private interface of the external firewall"""
        self.privateinterface = None
        """the private security zone of the external firewall"""
        self.privatezone = None
        """name of the provider"""
        self.provider = None
        """the public interface of the external firewall"""
        self.publicinterface = None
        """the public security zone of the external firewall"""
        self.publiczone = None
        """the timeout (in seconds) for requests to the external firewall"""
        self.timeout = None
        """the usage interface of the external firewall"""
        self.usageinterface = None
        """the username that's used to log in to the external firewall"""
        self.username = None
        """the zone ID of the external firewall"""
        self.zoneid = None

