
"""Retrieves a Cisco Nexus 1000v Virtual Switch Manager device associated with a Cluster"""
from baseCmd import *
from baseResponse import *
class listCiscoNexusVSMsCmd (baseCmd):
    def __init__(self):
        self.isAsync = "false"
        """Id of the CloudStack cluster in which the Cisco Nexus 1000v VSM appliance."""
        self.clusterid = None
        """List by keyword"""
        self.keyword = None
        """"""
        self.page = None
        """"""
        self.pagesize = None
        """Id of the CloudStack cluster in which the Cisco Nexus 1000v VSM appliance."""
        self.zoneid = None
        self.required = []

class listCiscoNexusVSMsResponse (baseResponse):
    def __init__(self):
        """the management IP address of the external Cisco Nexus 1000v Virtual Supervisor Module"""
        self.ipaddress = None
        """The mode of the VSM (standalone/HA)"""
        self.vsmconfigmode = None
        """The Config State (Primary/Standby) of the VSM"""
        self.vsmconfigstate = None
        """control vlan id of the VSM"""
        self.vsmctrlvlanid = None
        """device id of the Cisco N1KV VSM device"""
        self.vsmdeviceid = None
        """device name"""
        self.vsmdevicename = None
        """device state"""
        self.vsmdevicestate = None
        """The Device State (Enabled/Disabled) of the VSM"""
        self.vsmdevicestate = None
        """The VSM is a switch supervisor. This is the VSM's switch domain id"""
        self.vsmdomainid = None
        """management vlan id of the VSM"""
        self.vsmmgmtvlanid = None
        """packet vlan id of the VSM"""
        self.vsmpktvlanid = None
        """storage vlan id of the VSM"""
        self.vsmstoragevlanid = None

