
"""lists SRX firewall devices in a physical network"""
from baseCmd import *
from baseResponse import *
class listSrxFirewallsCmd (baseCmd):
    def __init__(self):
        self.isAsync = "false"
        """SRX firewall device ID"""
        self.fwdeviceid = None
        """List by keyword"""
        self.keyword = None
        """"""
        self.page = None
        """"""
        self.pagesize = None
        """the Physical Network ID"""
        self.physicalnetworkid = None
        self.required = []

class listSrxFirewallsResponse (baseResponse):
    def __init__(self):
        """device capacity"""
        self.fwdevicecapacity = None
        """device id of the SRX firewall"""
        self.fwdeviceid = None
        """device name"""
        self.fwdevicename = None
        """device state"""
        self.fwdevicestate = None
        """the management IP address of the external firewall"""
        self.ipaddress = None
        """the number of times to retry requests to the external firewall"""
        self.numretries = None
        """the physical network to which this SRX firewall belongs to"""
        self.physicalnetworkid = None
        """the private interface of the external firewall"""
        self.privateinterface = None
        """the private security zone of the external firewall"""
        self.privatezone = None
        """name of the provider"""
        self.provider = None
        """the public interface of the external firewall"""
        self.publicinterface = None
        """the public security zone of the external firewall"""
        self.publiczone = None
        """the timeout (in seconds) for requests to the external firewall"""
        self.timeout = None
        """the usage interface of the external firewall"""
        self.usageinterface = None
        """the username that's used to log in to the external firewall"""
        self.username = None
        """the zone ID of the external firewall"""
        self.zoneid = None

