#!/usr/bin/python
# -*- coding: utf-8 -*-
# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2013 CloudRunner.IO
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import json


def stringify(*values):
    for value in values:
        if value is None:
            yield value
        if isinstance(value, unicode):
            yield value.encode('utf8')
        else:
            yield str(value)


def jsonify(*values):
    for value in values:
        if value is None:
            yield ''
        if isinstance(value, unicode):
            yield value.encode('utf8')
        else:
            yield json.dumps(value)


def stringify1(value):
    if value is None:
        return value
    if isinstance(value, unicode):
        return value.encode('utf8')
    else:
        return str(value)


def jsonify1(value):
    if value is None:
        return ''
    if isinstance(value, unicode):
        return value.encode('utf8')
    else:
        return json.dumps(value)
