# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.


"""Lists all network ACLs"""
from baseCmd import *
from baseResponse import *
class listNetworkACLListsCmd (baseCmd):
    def __init__(self):
        self.isAsync = "false"
        """list resources by account. Must be used with the domainId parameter."""
        self.account = None
        """list only resources belonging to the domain specified"""
        self.domainid = None
        """list resources by display flag; only ROOT admin is eligible to pass this parameter"""
        self.fordisplay = None
        """Lists network ACL with the specified ID."""
        self.id = None
        """defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves."""
        self.isrecursive = None
        """List by keyword"""
        self.keyword = None
        """If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false"""
        self.listall = None
        """list network ACLs by specified name"""
        self.name = None
        """list network ACLs by network Id"""
        self.networkid = None
        """"""
        self.page = None
        """"""
        self.pagesize = None
        """list objects by project"""
        self.projectid = None
        """list network ACLs by Vpc Id"""
        self.vpcid = None
        self.required = []

class listNetworkACLListsResponse (baseResponse):
    def __init__(self):
        """the ID of the ACL"""
        self.id = None
        """Description of the ACL"""
        self.description = None
        """is ACL for display to the regular user"""
        self.fordisplay = None
        """the Name of the ACL"""
        self.name = None
        """Id of the VPC this ACL is associated with"""
        self.vpcid = None

