from collections import OrderedDict
from ..inspector import Inspector


class Metaclass(type):

    # Public

    @classmethod
    def __prepare__(cls, name, bases):
        return OrderedDict()

    def __new__(cls, name, bases, attrs):
        attrs['__order__'] = tuple(attrs)
        return super().__new__(cls, name, bases, attrs)

    # TODO: another interface like inspect function?
    def __getitem__(self, name):
        inspector = Inspector(self)
        return getattr(inspector, name)
