class Option:

    # Public

    def __init__(self, *, flags, **params):
        self.__flags = flags
        self.__params = params

    def __repr__(self):
        return '<Option with flags "{flags}">'.format(flags=self.__flags)

    def apply(self, parser, name):
        parser.add_argument(*self.__flags, dest=name, **self.__params)

    @property
    def flags(self):
        return self.__flags

    @property
    def help(self):
        return self.__params.get('help', '')
