from .argument import ArgumentParser


class Parser:

    # Public

    def __init__(self, name, *, options):
        self.__name = name
        self.__options = options

    def parse(self, argv_slice):
        parser = ArgumentParser(prog=self.__name)
        parser.add_argument('_arguments', nargs='*')
        for name, option in self.__options.items():
            option.apply(parser, name)
        options = vars(parser.parse_args(argv_slice))
        arguments = options.pop('_arguments')
        return (arguments, options)
