import unittest
from importlib import import_module
component = import_module('clyde.command.command')


class CommandTest(unittest.TestCase):

    # Helpers

    def setUp(self):
        self.Command = self.make_command()

    def make_command(self):
        class Command(component.Command):
            # Actions
            def __call__(self):
                return self
            # Options
            test = component.Option(
                action='store_true',
                flags=['-t', '--test'],
                help='This is test')
        return Command

    # Tests

    def test(self):
        self.command = self.Command(['program', '-t'])
        self.assertEqual(self.command.test, True)
