from abc import ABCMeta, abstractmethod


class Formatter(metaclass=ABCMeta):

    # Public

    @abstractmethod
    def __init__(self, *, name, command,
                 arguments, mixins, options, subcommands):
        pass  # pragma: no cover

    # Format

    @abstractmethod
    def format_doc(self, element=None):
        pass  # pragma: no cover

    @abstractmethod
    def format_help(self):
        pass  # pragma: no cover

    @abstractmethod
    def format_error(self, message):
        pass  # pragma: no cover

    @abstractmethod
    def format_usage(self):
        pass  # pragma: no cover
