# TO MAKE CHANGES USE "meta" DIRECTORY (see packgram docs).

import os
from setuptools import setup, find_packages

data_files = []
if data_files:
    try:
        if os.geteuid() != 0:
            data_files.clear()
    except Exception:
        pass

packages = find_packages(os.path.dirname(__file__) or '.', exclude=['tests*'])

setup(
    author='roll',
    author_email='roll@respect31.com',
    classifiers=[],       
    description='Clyde is a command line interface designer.',
    data_files=data_files,
    download_url='https://github.com/respect31/clyde/tarball/0.4.0',
    entry_points={},
    license='MIT License',
    maintainer='roll',
    maintainer_email='roll@respect31.com',
    name='clyde',
    include_package_data=True,
    install_requires=['box>=0.44', 'jinja2'], 
    packages=packages,
    platforms=['Unix'],
    url='https://github.com/respect31/clyde',
    long_description='''.. TO MAKE CHANGES USE "meta" DIRECTORY (see packgram docs).

Clyde
=====================
Clyde is a command line interface designer.

.. image:: http://img.shields.io/badge/code-GitHub-brightgreen.svg
     :target: https://github.com/respect31/clyde
     :alt: code
.. image:: http://img.shields.io/travis/respect31/clyde/master.svg
     :target: https://travis-ci.org/respect31/clyde 
     :alt: build
.. image:: http://img.shields.io/coveralls/respect31/clyde/master.svg 
     :target: https://coveralls.io/r/respect31/clyde  
     :alt: coverage
.. image:: http://img.shields.io/badge/docs-latest-brightgreen.svg
     :target: http://clyde.readthedocs.org
     :alt: docs     
.. image:: http://img.shields.io/pypi/v/clyde.svg
     :target: https://pypi.python.org/pypi?:action=display&name=clyde
     :alt: pypi

Application
-----------
Package is under active development and is not ready for production use.
Backward-compatibility between minor releases (0.x.0), documentation and 
changelog are not guaranteed to be present before stable versions (>=1.0.0).

Requirements
------------
- Platforms

  - Unix
- Interpreters

  - Python 3.3
  - Python 3.4

Installation
------------
- pip install clyde

Contribution
------------
- Authors

  - roll <roll@respect31.com>
- Maintainers

  - roll <roll@respect31.com>

Changelog
---------
- no entries yet

License
-------
**MIT License**

Copyright (c) 2014 Respect31 <post@respect31.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
''',     
    tests_require=['nose', 'coverage'],
    test_suite='nose.collector',
    version='0.4.0')
