class Argument:

    # Public

    def __init__(self, **params):
        self.__params = params

    def __repr__(self):
        return '<Argument>'

    def apply(self, parser, name):
        parser.add_argument(name, **self.__params)

    @property
    def help(self):
        return self.__params.get('help', '')

    @property
    def single(self):
        return self.__params.get('nargs', None) in [None, '?']
