class Mixin:

    # Public

    def __init__(self, function, require=None):
        self.__function = function
        self.__require = require

    # TODO: rename to __execute__ like in Command?
    def process(self, call, exception=None):
        if (isinstance(self.__require, type) and
            issubclass(self.__require, BaseException)):
            if exception is None:
                return
            if not isinstance(exception, self.__require):
                return
            self.__function(exception)
        else:
            if exception is not None:
                return
            if self.__require is not None:
                if not getattr(call, self.__require, False):
                    return
            self.__function()
