# Block: caution
# TO MAKE CHANGES USE "meta" DIRECTORY (see packgram docs).

# Block: data_files
import os
data_files = []
if data_files:
    try:
        if os.geteuid() != 0:
            data_files.clear()
    except Exception:
        pass

# Block: long_description
from glob import iglob
long_description = 'Clyde is a command line interface designer.'
for filepath in iglob('README.*'):
    with open(filepath) as file:
        long_description = file.read()
    break     

# Block: packages
from setuptools import find_packages
packages = find_packages(os.path.dirname(__file__) or '.', exclude=['tests*'])

# Block: setup
from setuptools import setup
setup(
    author='roll',
    author_email='roll@respect31.com',
    classifiers=[],       
    description='Clyde is a command line interface designer.',
    data_files=data_files,
    download_url='https://github.com/clyde-hub/clyde/tarball/0.7.0',
    entry_points={},
    license='MIT License',
    long_description=long_description,
    maintainer='roll',
    maintainer_email='roll@respect31.com',
    name='clyde',
    include_package_data=True,
    install_requires=['sugarbowl', 'jinja2'], 
    packages=packages,
    platforms=['Unix'],
    url='https://github.com/clyde-hub/clyde',
    tests_require=['nose', 'coverage'],
    test_suite='nose.collector',
    version='0.7.0')
