import inspect
from sugarbowl import Function


class mixin(Function):

    # Public

    # TODO: make it constant?
    decorator = '_clyde_mixin_mixin'

    def __init__(self, require=None):
        self.__require = require

    def __call__(self, function):
        setattr(function, self.decorator, self)
        return function

    def protocol(self, *args, **kwargs):
        try:
            if inspect.isfunction(args[0]):
                return Function.FUNCTION
        except IndexError:
            pass
        return Function.DECORATOR

    @property
    def require(self):
        return self.__require
