import sys
from .sformat import sformat


def sprint(*values, **params):
    """Print values with styles and colors.
    """
    sep = params.pop('sep', ' ')
    end = params.pop('end', '\n')
    file = params.pop('file', sys.stdout)
    flush = params.pop('file', False)
    string = sep.join(map(str, values))
    styled_string = sformat(string, **params)
    print(styled_string, sep='', end=end, file=file, flush=flush)
