import unittest
from io import StringIO
from unittest.mock import patch
from importlib import import_module
component = import_module('clyde.styler.sprint')


class sprint_Test(unittest.TestCase):

    # Actions

    def setUp(self):
        self.addCleanup(patch.stopall)
        self.stdout = patch.object(
            component.sys, 'stdout', new_callable=StringIO).start()

    # Tests

    def test(self):
        component.sprint('string', foreground='red')
        self.assertEqual(self.stdout.getvalue(), ('[31mstring[m\n'))
