import unittest
from importlib import import_module
component = import_module('clyde.styler.styler')


class StylerTest(unittest.TestCase):

    # Actions

    def setUp(self):
        self.styler = component.Styler()

    # Tests

    def test(self):
        with self.styler.style(foreground='red', background='white'):
            string1 = self.styler.format('string1')
            with self.styler.style(background='green'):
                string2 = self.styler.format('string2')
            string3 = self.styler.format('string3', background='green')
        self.assertEqual(string1, '\x1b[31;47mstring1\x1b[m')
        self.assertEqual(string2, '\x1b[31;47m\x1b[42mstring2\x1b[m')
        self.assertEqual(string3, '\x1b[31;47m\x1b[42mstring3\x1b[m')

    def test_with_param(self):
        self.styler = component.Styler(styles={'bold': 1000})
        string = self.styler.format('string', bold=True)
        self.assertEqual(string, '\x1b[1000mstring\x1b[m')

    def test_with_bad_param(self):
        self.assertRaises(
            ValueError, component.Styler, bad_param='bad_param')

    def test_format_with_bad_param(self):
        self.assertRaises(
            ValueError, self.styler.format, 'string', bad_param='bad_param')
