from .argparse import ArgparseParser
from .error import ParseError
from .result import ParseResult


class Parser:

    # Public

    def __init__(self, name):
        self.__name = name

    def parse(self, argv, arguments, options):
        result = ParseResult()
        argv = self.__parse_options(argv, options, result)
        self.__parse_arguments(argv, arguments, result)
        return result

    # Private

    def __parse_options(self, argv, options, result):
        try:
            parser = self.__create_parser(options)
            namespace, argv = parser.parse_known_args(argv)
            result.options = vars(namespace)
        except ParseError as exception:
            result.options = exception
        return argv

    def __parse_arguments(self, argv, arguments, result):
        try:
            parser = self.__create_parser(arguments)
            namespace = parser.parse_args(argv)
            result.arguments = []
            for name, argument in arguments.items():
                value = getattr(namespace, name)
                if argument.single:
                    result.arguments.append(value)
                else:
                    result.arguments += value
        except ParseError as exception:
            result.arguments = exception

    def __create_parser(self, elements):
        parser = ArgparseParser(prog=self.__name)
        for name, element in elements.items():
            element.apply(parser, name)
        return parser
