from cmdr.error import ParseError
from cmdr.flag import Flag


class CLI():
    def __init__(self, name, desc, action, version=None):
        self.name = name
        self.desc = desc
        self.version = version
        self.action = action

        self.flags = {'help': Flag('help', 'print this help and exit', False)}

    def run(self, argv):
        argv = argv[1:]

        if self.version:
            self.flag('version', 'print version and exit', False)

        try:
            opts, args = parse_argv(self.flags, argv)
        except ParseError:
            self.show_help()
            return 1

        if opts['help']:
            self.show_help()
            return 0
        elif self.version and opts['version']:
            self.show_version()
            return 0
        else:
            return self.action(opts, args)

    def flag(self, name, desc, val):
        self.flags[name] = Flag(name, desc, val)

    def show_help(self):
        msg = '%s - %s\n' % (self.name, self.desc.capitalize())
        msg += '\n'
        msg += 'Usage: %s [options] [args]\n' % self.name
        msg += '\n'
        msg += 'Options:\n'

        namesize = max([len(name) for name in self.flags])

        for _, flag in self.flags.iteritems():
            padding = ' ' * (namesize - len(flag.name))
            msg += '  --%s%s    %s\n' % (flag.name, padding, flag.desc.capitalize())

        print msg

    def show_version(self):
        print '%s %s' % (self.name, self.version)


def parse_argv(flags, argv):
    opts = {}
    args = []

    for name, flag in flags.iteritems():
        opts[name] = flag.val

    for idx, arg in enumerate(argv):
        if not arg.startswith('--'):
            args = argv[idx:]
            break

        name = arg[2:]
        if name not in flags:
            raise ParseError('unknown flag "%s"' % name)

        if name in flags:
            opts[name] = True

    return opts, args
