from cmdr import error
from cmdr import utils


class Flag():
    def __init__(self, name, desc, val):
        if not utils.validate(name):
            raise error.CmdrError('Name "%s" is not a valid flag name' % name)

        self.name = name
        self.desc = desc
        self.val = val

    def __str__(self):
        return '--%s=%s' % (self.name, self.val)
