import re

name_re = re.compile('^[a-zA-Z0-9]+(?:-[a-zA-Z0-9]+)*$')


def resolve(prefix, name, env):
    return env.get('%s_%s' % (canonize(prefix), canonize(name)), None)


def canonize(name):
    return name.upper().replace('-', '_')


def validate(name):
    return name_re.match(name) is not None
