# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'GoogleAnalyticsPluginModel'
        db.create_table('cmsplugin_googleanalyticspluginmodel', (
            ('cmsplugin_ptr', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['cms.CMSPlugin'], unique=True, primary_key=True)),
            ('account_code', self.gf('django.db.models.fields.CharField')(default='UA-xxxxxxxx-x', max_length=50)),
            ('domain_name', self.gf('django.db.models.fields.CharField')(default='example.com', max_length=60)),
            ('subdomains', self.gf('django.db.models.fields.BooleanField')(default=False)),
        ))
        db.send_create_signal('google_analytics', ['GoogleAnalyticsPluginModel'])


    def backwards(self, orm):
        # Deleting model 'GoogleAnalyticsPluginModel'
        db.delete_table('cmsplugin_googleanalyticspluginmodel')


    models = {
        'cms.cmsplugin': {
            'Meta': {'object_name': 'CMSPlugin'},
            'changed_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime(2013, 2, 27, 0, 0)'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'language': ('django.db.models.fields.CharField', [], {'max_length': '15', 'db_index': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['cms.CMSPlugin']", 'null': 'True', 'blank': 'True'}),
            'placeholder': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['cms.Placeholder']", 'null': 'True'}),
            'plugin_type': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'}),
            'position': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'})
        },
        'cms.placeholder': {
            'Meta': {'object_name': 'Placeholder'},
            'default_width': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'slot': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'})
        },
        'google_analytics.googleanalyticspluginmodel': {
            'Meta': {'object_name': 'GoogleAnalyticsPluginModel', 'db_table': "'cmsplugin_googleanalyticspluginmodel'", '_ormbases': ['cms.CMSPlugin']},
            'account_code': ('django.db.models.fields.CharField', [], {'default': "'UA-xxxxxxxx-x'", 'max_length': '50'}),
            'cmsplugin_ptr': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['cms.CMSPlugin']", 'unique': 'True', 'primary_key': 'True'}),
            'domain_name': ('django.db.models.fields.CharField', [], {'default': "'example.com'", 'max_length': '60'}),
            'subdomains': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        }
    }

    complete_apps = ['google_analytics']