# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'NavbarPluginModel'
        db.create_table('cmsplugin_navbarpluginmodel', (
            ('cmsplugin_ptr', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['cms.CMSPlugin'], unique=True, primary_key=True)),
            ('navbar_type', self.gf('django.db.models.fields.CharField')(default='navbar-fixed-top', max_length=64, blank=True)),
            ('inverted', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('brand', self.gf('django.db.models.fields.CharField')(default='', max_length=80, blank=True)),
            ('link_to_children', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('icon_type', self.gf('django.db.models.fields.CharField')(max_length=24, blank=True)),
        ))
        db.send_create_signal('navbar', ['NavbarPluginModel'])


    def backwards(self, orm):
        # Deleting model 'NavbarPluginModel'
        db.delete_table('cmsplugin_navbarpluginmodel')


    models = {
        'cms.cmsplugin': {
            'Meta': {'object_name': 'CMSPlugin'},
            'changed_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime(2013, 2, 27, 0, 0)'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'language': ('django.db.models.fields.CharField', [], {'max_length': '15', 'db_index': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['cms.CMSPlugin']", 'null': 'True', 'blank': 'True'}),
            'placeholder': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['cms.Placeholder']", 'null': 'True'}),
            'plugin_type': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'}),
            'position': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'})
        },
        'cms.placeholder': {
            'Meta': {'object_name': 'Placeholder'},
            'default_width': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'slot': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'})
        },
        'navbar.navbarpluginmodel': {
            'Meta': {'object_name': 'NavbarPluginModel', 'db_table': "'cmsplugin_navbarpluginmodel'", '_ormbases': ['cms.CMSPlugin']},
            'brand': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '80', 'blank': 'True'}),
            'cmsplugin_ptr': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['cms.CMSPlugin']", 'unique': 'True', 'primary_key': 'True'}),
            'icon_type': ('django.db.models.fields.CharField', [], {'max_length': '24', 'blank': 'True'}),
            'inverted': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'link_to_children': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'navbar_type': ('django.db.models.fields.CharField', [], {'default': "'navbar-fixed-top'", 'max_length': '64', 'blank': 'True'})
        }
    }

    complete_apps = ['navbar']