describe("module:ng.directive:ngController", function() {
  beforeEach(function() {
    browser.get("./examples/example-ngController/index-jquery.html");
  });

  it('should check controller', function() {
    var container = element(by.id('ctrl-exmpl'));

    expect(container.findElement(by.model('name'))
        .getAttribute('value')).toBe('John Smith');

    var firstRepeat =
        container.findElement(by.repeater('contact in contacts').row(0));
    var secondRepeat =
        container.findElement(by.repeater('contact in contacts').row(1));

    expect(firstRepeat.findElement(by.model('contact.value')).getAttribute('value'))
        .toBe('408 555 1212');
    expect(secondRepeat.findElement(by.model('contact.value')).getAttribute('value'))
        .toBe('john.smith@example.org');

    firstRepeat.findElement(by.linkText('clear')).click();

    expect(firstRepeat.findElement(by.model('contact.value')).getAttribute('value'))
        .toBe('');

    container.findElement(by.linkText('add')).click();

    expect(container.findElement(by.repeater('contact in contacts').row(2))
        .findElement(by.model('contact.value'))
        .getAttribute('value'))
        .toBe('yourname@example.org');
  });
});