from Products.Archetypes.public import *
from collective.phantasy.config import I18N_DOMAIN
from Products.SmartColorWidget.Widget import SmartColorWidget

PreservedShematas = ['default', 'images', 'dimensions', 'colors', 'fonts', 'borders', 'plone-overloads']

def finalizePhantasySchema(schema):
    """Finalizes schema to alter some fields
    """
    # Id must be valid and description invisible
    schema['id'].validators = ('isValidId',)
    schema['description'].widget.visible = {'view':'invisible', 'edit':'invisible'}
    # remove ATCTFolder metadata fields
    for fieldName in schema.keys() :
        if schema[fieldName].schemata not in PreservedShematas :
            schema[fieldName].widget.visible = {'view':'invisible', 'edit':'invisible'}
    # Make a copy to reinitialize all layers
    new_schema = schema.copy()
    return new_schema

PhantasyFieldsSchema = Schema((
#standard plone properties are always required    
    StringField(
        'cssfile',
        schemata ='default',
        widget=StringWidget(
            label='Css ',
            description = """Choose a stylesheet file name, upload the file in this skin.
This css will be applied at the end (after all properties). Use './myimage.jpg' in this css
to reference an image called 'myimage.jpg' from this skin.""",
            label_msgid = "label_logo_name",
            description_msgid = "description_logo_name",
            i18n_domain = I18N_DOMAIN,
            ),
        ),                                                                         
    StringField(
        'logoName',
        schemata ='images',
        required=1,
        widget=StringWidget(
            label='Logo Name',
            description = "Choose the logo file name, upload the image in the skin to overload it",
            label_msgid = "label_logo_name",
            description_msgid = "description_logo_name",
            i18n_domain = I18N_DOMAIN,
            ),
        ),            
    StringField(
        'backgroundImageName',
        schemata ='images',
        widget=StringWidget(
            label='Background Image Name',
            description = "Choose the background image name for the page, upload the image in this skin",
            label_msgid = "label_background_image_name",
            description_msgid = "description_background_image_name",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    StringField(
        'backgroundImagePosition',
        schemata ='images',
        default="top left",
        vocabulary = [("top left", "Top Left"), 
                      ("top right", "Top Right"),
                      ("top center", "Top Center"),
                      ("center left", "Center Left"),
                      ("center right", "Center Right"),
                      ("center center", "Center Center"),
                      ("bottom left", "Bottom Left"),
                      ("bottom right", "Bottom Right"),
                      ("bottom center", "Bottom Center")],
        widget=SelectionWidget(
            label='Background Image Position',
            format='select',
            description = "Choose the background image position for the page",
            label_msgid = "label_background_image_position",
            description_msgid = "description_background_image_position",
            i18n_domain = I18N_DOMAIN,
            ),
        ),   
    StringField(
        'backgroundImageRepeat',
        schemata ='images',
        default="no-repeat",
        vocabulary = [("no-repeat", "No repeat"), 
                      ("repeat-x", "Horizontal Repeat"),
                      ("repeat-y", "Vertical Repeat"),
                      ("repeat", "mosaic repeat")],
        widget=SelectionWidget(
            label='Background Image Repeat',
            format='select',
            description = "Choose the background image repeat for the page",
            label_msgid = "label_background_image_repeat",
            description_msgid = "description_background_image_repeat",
            i18n_domain = I18N_DOMAIN,
            ),
        ),        
    StringField(
        'portalBackgroundImageName',
        schemata ='images',
        widget=StringWidget(
            label='Portal Background Image Name',
            description = "Choose the background image name for the portal, upload the image in this skin",
            label_msgid = "label_portal_background_image_name",
            description_msgid = "description_portal_background_image_name",
            i18n_domain = I18N_DOMAIN,
            ),
        ),   
    StringField(
        'contentBackgroundImageName',
        schemata ='images',
        widget=StringWidget(
            label='Content Background Image Name',
            description = "Choose the background image name for the content, upload the image in this skin",
            label_msgid = "label_contentl_background_image_name",
            description_msgid = "description_content_background_image_name",
            i18n_domain = I18N_DOMAIN,
            ),
        ),              
# this property is not used is standard plone css 
# so we make it invisible                 
    StringField(
        'portalMinWidth',
        schemata ='dimensions',
        widget=StringWidget(
            label='Portal min width',
            visible = {'view':'invisible', 'edit':'invisible'},
            description = "Choose the portal min width in px em or %",
            label_msgid = "label_portal_min_width",
            description_msgid = "description_portal_min_width",
            i18n_domain = I18N_DOMAIN,
            ),
        ),   
    StringField(
        'portalWidth',
        schemata ='dimensions',
        default = '100%',
        widget=StringWidget(
            label='Portal width',
            description = "Choose the portal min width in px em or %",
            label_msgid = "label_portal_width",
            description_msgid = "description_portal_width",
            i18n_domain = I18N_DOMAIN,
            ),
        ),              
    StringField(
        'portalHorizontalPosition',
        schemata ='dimensions',
        default="",
        vocabulary = [("0", "undefined"), 
                      ("0 auto 0 auto", "centered"),
                      ("0 auto 0 0", "on left"),
                      ("0 0 0 auto", "on right")],
        widget=SelectionWidget(
            label='Portal Horizontal Position',
            format='select',
            description = "Choose the position for portal",
            label_msgid = "label_text_transform",
            description_msgid = "description_text_transform",
            i18n_domain = I18N_DOMAIN,
            ),
        ),              
    StringField(
        'columnOneWidth',
        schemata ='dimensions',
        required=1,
        widget=StringWidget(
            label='Column One width',
            description = "Choose the column one width in px em or %",
            label_msgid = "label_column_one_width",
            description_msgid = "description_column_one_width",
            i18n_domain = I18N_DOMAIN,
            ),
        ),     
    StringField(
        'columnTwoWidth',
        schemata ='dimensions',
        required=1,
        widget=StringWidget(
            label='Column Two width',
            description = "Choose the column two width in px em or %",
            label_msgid = "label_column_two_width",
            description_msgid = "description_column_two_width",
            i18n_domain = I18N_DOMAIN,
            ),
        ),             
    StringField(
        'fontFamily',
        schemata ='fonts',
        required=1,
        widget=StringWidget(
            label='Font Family',
            description = "Choose the font family",
            label_msgid = "label_font_family",
            description_msgid = "description_font_family",
            i18n_domain = I18N_DOMAIN,
            ),
        ),              
    StringField(
        'fontBaseSize',
        schemata ='fonts',
        required=1,
        widget=StringWidget(
            label='Font Base Size',
            description = "Choose the base font size in % (better) em px pt or using a keyword (xx-small, small, ...)",
            label_msgid = "label_font_base_size",
            description_msgid = "description_font_base_size",
            i18n_domain = I18N_DOMAIN,
            ),
        ),               
    StringField(
        'fontSmallSize',
        schemata ='fonts',
        required=1,
        widget=StringWidget(
            label='Font Small Size',
            description = "Choose the small font size in % (better) em px pt or using a keyword (xx-small, small, ...)",
            label_msgid = "label_font_small_size",
            description_msgid = "description_font_small_size",
            i18n_domain = I18N_DOMAIN,
            ),
        ),      
    StringField(
        'headingFontFamily',
        schemata ='fonts',
        required=1,
        widget=StringWidget(
            label='Heading Font Family',
            description = "Choose the font family for titles",
            label_msgid = "label_heading_font_family",
            description_msgid = "description_heading_font_family",
            i18n_domain = I18N_DOMAIN,
            ),
        ),       
    StringField(
        'textTransform',
        schemata ='fonts',
        required=1,
        vocabulary = [("none", "none"), 
                      ("uppercase", "uppercase"),
                      ("lowercase", "lowercase"),
                      ("capitalize","capitalize")],
        widget=SelectionWidget(
            label='Text Transform',
            format='select',
            description = "Choose the text transformation for tabs and some headings",
            label_msgid = "label_text_transform",
            description_msgid = "description_text_transform",
            i18n_domain = I18N_DOMAIN,
            ),
        ),                                  
    StringField(
        'fontColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Font Color',
            description = "Choose the font color ",
            label_msgid = "label_font_color",
            description_msgid = "description_font_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),        
    StringField(
        'backgroundColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Background Color',
            description = "Choose the background color of the page",
            label_msgid = "label_background_color",
            description_msgid = "description_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),                                   
    StringField(
        'discreetColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Discreet Color',
            description = "Choose the discreet color (can be used in content) ",
            label_msgid = "label_discreet_color",
            description_msgid = "description_discreet_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),  
    StringField(
        'portalBackgroundColor',
        schemata ='colors',
        default="transparent",
        widget=SmartColorWidget(
            label='Portal Background Color',
            description = "Choose the portal background color",
            label_msgid = "label_portal_background_color",
            description_msgid = "description_portal_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    StringField(
        'contentBackgroundColor',
        schemata ='colors',
        default="transparent",
        widget=SmartColorWidget(
            label='Content Background Color',
            description = "Choose background color for content part of the page",
            label_msgid = "label_content_background_color",
            description_msgid = "description_content_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),      
    StringField(
        'headerBackgroundColor',
        schemata ='colors',
        default="transparent",
        widget=SmartColorWidget(
            label='Header Background Color',
            description = "Choose background color for the header",
            label_msgid = "label_header_background_color",
            description_msgid = "description_header_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),                                       
    StringField(
        'inputFontColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Input Font Color',
            description = "Choose the input fields font color",
            label_msgid = "label_input_font_color",
            description_msgid = "description_input_font_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    StringField(
        'linkColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Link Color',
            description = "Choose the color for links",
            label_msgid = "label_link_color",
            description_msgid = "description_link_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),      
    StringField(
        'linkVisitedColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Link Visited Color',
            description = "Choose the color for visited links",
            label_msgid = "label_link_color",
            description_msgid = "description_link_visited_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    StringField(
        'linkActiveColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Link Active/Hover Color',
            description = "Choose the color for active links",
            label_msgid = "label_link_active_color",
            description_msgid = "description_link_active_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),  
    StringField(
        'notifyBackgroundColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Notify Background Color',
            description = "Choose the notify background color (for portal messages)",
            label_msgid = "label_notify_background_color",
            description_msgid = "description_notify_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    StringField(
        'notifyBorderColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Notify Border Color',
            description = "Choose the notify border color",
            label_msgid = "label_notify_border_color",
            description_msgid = "description_notify_border_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),          
    StringField(
        'helpBackgroundColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Help Background Color',
            description = "Choose the bg color for help in forms",
            label_msgid = "label_help_background_color",
            description_msgid = "description_help_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),   
    StringField(
        'oddRowBackgroundColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Odd Row Background Color',
            description = "Choose the bg color for odd rows (tables, portlets)",
            label_msgid = "label__odd_row_background_color",
            description_msgid = "description_odd_row_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),            
    StringField(
        'evenRowBackgroundColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Even Row Background Color',
            description = "Choose the bg color for even rows (tables, portlets)",
            label_msgid = "label__even_row_background_color",
            description_msgid = "description_even_row_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),     
    StringField(
        'globalBackgroundColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Global Background Color',
            description = "Choose the global background color (used in tabs and portlets headers)",
            label_msgid = "label_global_background_color",
            description_msgid = "description_global_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),    
    StringField(
        'globalFontColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Global Font Color',
            description = "Choose the global font color (used in tabs and portlets headers)",
            label_msgid = "label_global_font_color",
            description_msgid = "description_global_font_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),                  
    StringField(
        'globalBorderColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Global Border Color',
            description = "Choose the color for global borders",
            label_msgid = "label_global_border_color",
            description_msgid = "description_global_border_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),     
    StringField(
        'contentViewBackgroundColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Content View Background Color',
            description = "Choose the background color for content views tabs",
            label_msgid = "label_content_views_background_color",
            description_msgid = "description_content_views_background_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),  
    StringField(
        'contentViewBorderColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Content View Border Color',
            description = "Choose the border color for content views tabs",
            label_msgid = "label_content_views_border_color",
            description_msgid = "description_content_views_border_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),   
    StringField(
        'contentViewFontColor',
        schemata ='colors',
        required=1,
        widget=SmartColorWidget(
            label='Content View Font Color',
            description = "Choose the font color for content views tabs",
            label_msgid = "label_content_views_font_color",
            description_msgid = "description_content_views_font_color",
            i18n_domain = I18N_DOMAIN,
            ),
        ),            
    StringField(
        'borderStyle',
        schemata ='borders',
        required=1,
        vocabulary = [("none", "no border"),
                      ("hidden", "hidden when none is impossible (tables)"),
                      ("solid", "solid"), 
                      ("dotted", "dotted"),
                      ("dashed", "dashed"),
                      ("groove","3D groove"), 
                      ("double", "double borders"),
                      ("inset", "3D inset"),
                      ("outset","3D outset"),
                      ("ridge","3D ridge")],
        widget=SelectionWidget(
            label='Border Style',
            format='select',
            description = "Choose the global border style",
            label_msgid = "label_border_style",
            description_msgid = "description_border_style",
            i18n_domain = I18N_DOMAIN,
            ),
        ),   
    StringField(
        'borderStyleAnnotations',
        schemata ='borders',
        required=1,
        vocabulary = [("none", "no border"),
                      ("hidden", "hidden when none is impossible (tables)"),
                      ("solid", "solid"), 
                      ("dotted", "dotted"),
                      ("dashed", "dashed"),
                      ("groove","3D groove"), 
                      ("double", "double borders"),
                      ("inset", "3D inset"),
                      ("outset","3D outset"),
                      ("ridge","3D ridge")],
        widget=SelectionWidget(
            label='Border Style for Annotations',
            format='select',
            description = "Choose the border style for annotations ",
            label_msgid = "label_border_style_annotations",
            description_msgid = "description_border_style_annotations",
            i18n_domain = I18N_DOMAIN,
            ),
        ),             
    StringField(
        'borderWidth',
        schemata ='borders',
        required=1,
        widget=StringWidget(
            label='Border Width',
            description = "Choose the border width in px",
            label_msgid = "label_border_width",
            description_msgid = "description_border_width",
            i18n_domain = I18N_DOMAIN,
            ),
        ),      
    BooleanField(
        'overloadBody',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Body Style',
            description = """Do you want to overload the body style ?""",
            label_msgid = "label_overload_body",
            description_msgid = "description_overload_body",
            i18n_domain = I18N_DOMAIN,
            ),
        ),      
    BooleanField(
        'overloadHTMLTags',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload HTML Tags Styles',
            description = """Do you want to overload content styles (classic html tags) ?""",
            label_msgid = "label_overload_html_tags",
            description_msgid = "description_overload_html_tags",
            i18n_domain = I18N_DOMAIN,
            ),
        ),         
    BooleanField(
        'overloadContent',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Various Content Styles',
            description = """Do you want to overload standard plone styles used for content ?""",
            label_msgid = "label_overload_content",
            description_msgid = "description_overload_content",
            i18n_domain = I18N_DOMAIN,
            ),
        ),  
    BooleanField(
        'overloadLinks',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Links Styles',
            description = """Do you want to overload links styles (icons, colors etc ...) ?""",
            label_msgid = "label_overload_links",
            description_msgid = "description_overload_links",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    BooleanField(
        'overloadSiteActions',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Site Actions Styles',
            description = """Do you want to overload site actions styles ?""",
            label_msgid = "label_overload_site_actions",
            description_msgid = "description_overload_site_actions",
            i18n_domain = I18N_DOMAIN,
            ),
        ),  
    BooleanField(
        'overloadSearchBox',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Search Box Styles',
            description = """Do you want to overload search box styles ?""",
            label_msgid = "label_overload_search_box",
            description_msgid = "description_overload_search_box",
            i18n_domain = I18N_DOMAIN,
            ),
        ),    
    BooleanField(
        'overloadGlobalSections',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Global Sections Styles',
            description = """Do you want to overload global sections buttons styles ?""",
            label_msgid = "label_overload_global_sections",
            description_msgid = "description_overload_global_sections",
            i18n_domain = I18N_DOMAIN,
            ),
        ),      
    BooleanField(
        'overloadPersonalTools',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Personals Tools Styles',
            description = """Do you want to overload global sections buttons styles ?""",
            label_msgid = "label_overload_personal_tools",
            description_msgid = "description_overload_personal_tools",
            i18n_domain = I18N_DOMAIN,
            ),
        ),              
    BooleanField(
        'overloadBreadcrumbs',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Breadcrumbs Styles',
            description = """Do you want to overload breadcrumbs styles ?""",
            label_msgid = "label_overload_breadcrumbs",
            description_msgid = "description_overload_breadcrumbs",
            i18n_domain = I18N_DOMAIN,
            ),
        ),  
    BooleanField(
        'overloadFooter',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Footer Styles',
            description = """Do you want to overload footer styles ?""",
            label_msgid = "label_overload_footer",
            description_msgid = "description_overload_footer",
            i18n_domain = I18N_DOMAIN,
            ),
        ),        
    BooleanField(
        'overloadSiteMap',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Site Map Styles',
            description = """Do you want to overload site map styles ?""",
            label_msgid = "label_overload_site_map",
            description_msgid = "description_overload_site_map",
            i18n_domain = I18N_DOMAIN,
            ),
        ),    
    BooleanField(
        'overloadColumns',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Columns Styles',
            description = """Do you want to overload columns styles ?""",
            label_msgid = "label_overload_columns",
            description_msgid = "description_overload_columns",
            i18n_domain = I18N_DOMAIN,
            ),
        ),         
    BooleanField(
        'overloadForms',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Forms Styles',
            description = """Do you want to overload forms styles ?""",
            label_msgid = "label_overload_forms",
            description_msgid = "description_overload_forms",
            i18n_domain = I18N_DOMAIN,
            ),
        ),           
    BooleanField(
        'overloadPortlets',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Portlets Styles',
            description = """Do you want to overload portlets styles ?""",
            label_msgid = "label_overload_portlets",
            description_msgid = "description_overload_portlets",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    BooleanField(
        'overloadNavtree',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Navigation Tree Styles',
            description = """Do you want to overload navigation tree styles (impact sitemap + navtree portlet) ?""",
            label_msgid = "label_overload_navtree",
            description_msgid = "description_overload_navtree",
            i18n_domain = I18N_DOMAIN,
            ),
        ), 
    BooleanField(
        'overloadAuthoring',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Authoring Styles',
            description = """Do you want to overload authoring styles (content views, actions etc ...) ?""",
            label_msgid = "label_overload_navtree",
            description_msgid = "description_overload_navtree",
            i18n_domain = I18N_DOMAIN,
            ),
        ),     
    BooleanField(
        'overloadLogo',
        schemata ='plone-overloads',
        default = True,
        widget=BooleanWidget(
            label='Overload Logo',
            description = """Do you want to overload site logo ?""",
            label_msgid = "label_overload_logo",
            description_msgid = "description_overload_logo",
            i18n_domain = I18N_DOMAIN,
            ),
        ),                       

    ), marshall=RFC822Marshaller())    
