from collective.plonetruegallery import PTGMessageFactory as _
from zope.interface import Interface
from plone.z3cform.fieldsets import group as plonegroup
from z3c.form import form, field, group
from plone.app.z3cform.layout import wrap_form
from collective.plonetruegallery.interfaces import IGallery, IGallerySettings
from collective.plonetruegallery.meta.zcml import getAllGalleryTypes, \
    getAllDisplayTypes, getDisplayType
from collective.plonetruegallery.settings import GallerySettings
import zope.i18n

class INothing(Interface):
    pass

class MainSettingsGroup(plonegroup.Group):
    fields = field.Fields(IGallerySettings)
    label = u"Main"

class GallerySettingsForm(group.GroupForm, form.EditForm):
    """
    The page that holds all the gallery settings
    """
    
    fields = field.Fields(INothing)
    groups = [MainSettingsGroup]
    
    label = _(u'heading_gallery_settings_form', default=u"Gallery")
    description = _(u'description_gallery_settings_form', default=u"Configure the parameters for this gallery.")

    def add_fields_to_group(self, type_, groupname):
        group = None
        for g in self.groups:
            if groupname == g.label:
                group = g
                
        if group is None:
            g = plonegroup.GroupFactory(groupname, field.Fields(type_.schema))
            self.groups.append(g)
        else:
            fields = field.Fields(type_.schema)
            toadd = []
            for f in fields._data_values:
                if f.__name__ not in group.fields.keys():
                    toadd.append(f)
                    
            group.fields = field.Fields(group.fields, *toadd)

    def update(self):
        gallerytypes = getAllGalleryTypes()
        displaytypes = getAllDisplayTypes()
    
        for t in gallerytypes:
            if len(t.schema.names()) > 0:
                self.add_fields_to_group(t, "Type Settings")
            
        for t in displaytypes:
            if len(t.schema.names()) > 0:
                self.add_fields_to_group(t, "Display Type Settings")
              
        super(GallerySettingsForm, self).update()

    def __call__(self):
        self.update()
        
        settings = GallerySettings(self.context)
        display_type = getDisplayType(settings.display_type)
        if display_type.user_warning is not None:
            self.status += " " + zope.i18n.translate(display_type.user_warning)
            
        return self.render()

    def applyChanges(self, data):
        settings = GallerySettings(self.context)
        settings.last_cooked_time_in_seconds = 0
                
        return super(GallerySettingsForm, self).applyChanges(data)
    
GallerySettingsView = wrap_form(GallerySettingsForm)

