/*
 * Scrollbar plugin for jQuery UI
 *
 * Originally adapted from the jQuery UI Slider example for implementing a horizontal scrollbar.
 *
 * Author: Jillian Ada Burrows.
 * Version: 1.0.0
 * Date: 27 February 2012
 *
 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 *	jquery.ui.slider.js
 */(function(a){a.widget("ui.scrollbar",{options:{orientation:"horizontal",scrollFactor:15,easing:"linear",animationDuration:20},_create:function(){var b=this,c=this.options,d=this.element;this.scrollbarActive=!1,this.containerElement=a(d),this.containerChildren=this.containerElement.children(),this.containerChildren.detach(),this.scrollPane=a('<div class="scroll-pane scroll-pane-'+c.orientation+'"></div>'),this.scrollContent=a('<div class="scroll-content scroll-content-'+c.orientation+'"></div>'),this.scrollContent.append(this.containerChildren),this.scrollContent.appendTo(this.scrollPane),this.scrollContent.show(),this.scrollbarWrapper=a('<div class="scroll-bar-wrap scroll-bar-wrap-'+c.orientation+' ui-corner-all"></div>'),this.scrollbarWrapper.appendTo(this.scrollPane).hide(),this.scrollbar=a('<div class="scroll-bar scroll-bar-'+c.orientation+'"></div>').slider({orientation:c.orientation,value:c.orientation=="horizontal"?0:100,slide:function(a,d){c.orientation=="horizontal"?b._horizontalScrollHandler(a,d):b._verticalScrollHandler(a,d)}}),this._makeHandleHelper(),this.scrollbar.appendTo(this.scrollbarWrapper),this.scrollPane.appendTo(this.containerElement),this.containerElement.bind("mousewheel",function(a,c){if(b.scrollbarActive===!0){a.stopPropagation();if(c!==undefined)return b._mousewheelHandler(a,c)}}),this._showScrollbar()},_makeHandleHelper:function(){var a=this;this.options.orientation=="horizontal"?this.handleHelper=this.scrollbar.find(".ui-slider-handle").mousedown(function(){a.scrollbar.width(a.handleHelper.width())}).mouseup(function(){a.scrollbar.width("100%")}).wrap("<div class='ui-handle-helper-parent'></div>").parent():this.handleHelper=this.scrollbar.find(".ui-slider-handle").mousedown(function(){a.scrollbar.height(a.handleHelper.height())}).mouseup(function(){a.scrollbar.height("100%")}).wrap("<div class='ui-handle-helper-parent'></div>").parent(),this.scrollPane.css("overflow","hidden")},_horizontalScrollHandler:function(a,b){this._scrollHorizontal(b.value,this.options.animationDuration)},_verticalScrollHandler:function(a,b){this._scrollVertical(b.value,this.options.animationDuration)},_mousewheelHandler:function(a,b){var c=!1,d=this.options.animationDuration,e=b*this.options.scrollFactor;if(this.options.orientation=="horizontal"){var f=this._adjustScrollAmount(-e);this._scrollHorizontal(f.amount,d)}else{var f=this._adjustScrollAmount(e);this._scrollVertical(f.amount,d)}return f.scroll},_adjustScrollAmount:function(a){var b=!1,c=parseInt(this.scrollbar.slider("value"))+a;return c<0&&(c=0,b=!0),c>100&&(c=100,b=!0),this.scrollbar.slider("value",c),{amount:c,scroll:b}},_scrollHorizontal:function(a,b){if(this.scrollContent.width()>this.scrollPane.width()){var c=Math.round(a/100*(this.scrollPane.width()-this.scrollContent.width()));this._scrollHorizontalDistance(c,b)}else this.scrollContent.css("margin-left",0)},_scrollVertical:function(a,b){if(this.scrollContent.height()>this.scrollPane.height()){var c=Math.round((100-a)/100*(this.scrollPane.height()-this.scrollContent.height()));this._scrollVerticalDistance(c,b)}else this.scrollContent.css("margin-top",0)},_scrollHorizontalDistance:function(a,b){this.scrollContent.animate({"margin-left":a+"px"},{duration:b/a,easing:this.options.easing})},_scrollVerticalDistance:function(a,b){this.scrollContent.animate({"margin-top":a+"px"},{duration:b/a,easing:this.options.easing})},_showScrollbar:function(){var a=this.containerElement.width()-this.scrollContent.width(),b=this.containerElement.height()-this.scrollContent.height();if(this.options.orientation=="horizontal"&&a<0||this.options.orientation=="vertical"&&b<0){this.scrollbarActive=!0,this.scrollbarWrapper.show(),this.scrollContent.addClass("with-scrollbar");var c=this;setTimeout(function(){c._sizeScrollbar()},10)}else this.scrollbarActive===!0&&(this.scrollbarActive=!1,this.scrollbarWrapper.hide(),this.scrollContent.removeClass(".with-scrollbar"));this._sizeContent()},_sizeContent:function(){this.options.orientation!="horizontal"&&(this.scrollbarActive===!0?this.scrollContent.css("width",this.scrollPane.width()-this.scrollbarWrapper.outerWidth(!0)):this.scrollContent.css("width","100%"))},_sizeScrollbar:function(){if(this.options.orientation=="horizontal"){var a=this._calcScrollBarSize(this.scrollContent.width(),this.scrollPane.width());this.scrollbar.find(".ui-slider-handle").css({width:a,"margin-left":-a/2}),this.handleHelper.width("").width(this.scrollbar.width()-a)}else{var a=this._calcScrollBarSize(this.scrollContent.height(),this.scrollPane.height());this.scrollbar.find(".ui-slider-handle").css({height:a,"margin-top":-(a/2)}),this.handleHelper.height("").height(this.scrollbar.height()-a).css("margin-top",a+"px")}},_calcScrollBarSize:function(a,b){var c=a-b,d=c/a,e=b-d*b;return e},_resetValue:function(){if(this.options.orientation=="horizontal"){var a=this.scrollPane.width()-this.scrollContent.width(),b=this.scrollContent.css("margin-left")==="auto"?0:parseInt(this.scrollContent.css("margin-left")),c=Math.round(b/a*100);this.scrollbar.slider("value",c)}else{var a=this.scrollPane.height()-this.scrollContent.height(),d=this.scrollContent.css("margin-top")==="auto"?0:parseInt(this.scrollContent.css("margin-top")),c=Math.round(d/a*100);this.scrollbar.slider("value",100-c)}},_reflowContent:function(){if(this.options.orientation=="horizontal"){var a=this.scrollContent.width()+parseInt(this.scrollContent.css("margin-left"),10),b=this.scrollPane.width()-a;b>0&&this.scrollContent.css("margin-left",parseInt(this.scrollContent.css("margin-left"),10)+b)}else{var a=this.scrollContent.height()+parseInt(this.scrollContent.css("margin-top"),10),b=this.scrollPane.height()-a;b>0&&this.scrollContent.css("margin-top",parseInt(this.scrollContent.css("margin-top"),10)+b)}},resize:function(){this._showScrollbar(),this.scrollbarActive&&(this._resetValue(),this._reflowContent())},scrollToOffset:function(a){if(this.options.orientation=="horizontal"){var b=this.calcDistanceToOffset(a,this.scrollContent.width(),this.containerElement.width());this._scrollHorizontalDistance(b,this.options.animationDuration)}else{var b=this.calcDistanceToOffset(a,this.scrollContent.height(),this.containerElement.height());this._scrollVerticalDistance(b,this.options.animationDuration)}},calcDistanceToOffset:function(a,b,c){var d=b-a,e=c-d,f=a;return e<0&&(f=a+e),f},destroy:function(){this.containerChildren.detach(),this.containerElement.empty(),this.containerElement.append(this.containerChildren)},_setOption:function(b,c){a.Widget.prototype._setOption.apply(this,arguments);switch(b){case"contentHeight":this.scrollContent.css("height",c),this._sizeScrollbar()}}})})(jQuery);