# -*- coding: utf-8 -*-
"""Recipe mockedeggs"""

import os
import sys
import logging
import pkg_resources
import zc.buildout
from zc.buildout.rmtree import rmtree

SETUP_TEMPLATE = """# Never release this
# This is an intentionally fake "%(module)s" module
# generated by collective.recipe.mockedeggs recipe

from setuptools import setup

version = '%(version)s'

setup(
    name='%(module)s',
    version=version,
    description="Fake %(module)s",
    author="Ingeniweb",
    author_email='thomas.desvenain@gmail.com',
    url='http://pypi.python.org/pypi/collective.recipe.mockedeggs/',
    )

"""

class Recipe(object):
    """zc.buildout recipe"""

    def __init__(self, buildout, name, options):
        self.buildout, self.name, self.options = buildout, name, options
        self.log = logging.getLogger(self.name)

    def install(self):
        """Installer"""
        if os.path.exists(self.name):
            rmtree(self.name)
        os.mkdir(self.name)
        mockedeggs = [e for e in self.options['mocked-eggs'].split('\n') if e]
        modules = []
        for egg in mockedeggs:
            module, version = [v.strip() for v in egg.split('=') if v.strip()]
            mockedegg = os.path.abspath('%s/fake-%s' % (self.name, module))
            os.mkdir(mockedegg)
            setup_py = open('%s/setup.py' % mockedegg, 'w')
            setup_py.write(SETUP_TEMPLATE % {'module': module, 'version': version})
            setup_py.close()
            zc.buildout.easy_install.develop(mockedegg,
                    self.buildout['buildout']['develop-eggs-directory'])
            modules.append(module)

        self.log.info("Mocked eggs %s." % ', '.join(modules))
        return self.name

    def update(self):
        """Updater"""
        pass
