#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# ANSI color scheme script featuring various art.
#
# Inspired by various posts on: http://crunchbang.org/forums/viewtopic.php?pid=126921%23p126921#p126921
# Python version by @gardaud
#

#define color escape sequence
clear = '\033[0m'
bold = '\033[1m'

black = '\033[30m'
red = '\033[31m'
green = '\033[32m'
yellow = '\033[33m'
blue = '\033[34m'
purple = '\033[35m'
cyan = '\033[36m'
white = '\033[37m'

bright_black = '\033[90m'
bright_red = '\033[91m'
bright_green = '\033[92m'
bright_yellow = '\033[93m'
bright_blue = '\033[94m'
bright_purple = '\033[95m'
bright_cyan = '\033[96m'
bright_white = '\033[97m'



#available art
invaders = "\
 {2}  ▀▄   ▄▀     {3} ▄▄▄████▄▄▄    {4}  ▄██▄     {5}  ▀▄   ▄▀     {6} ▄▄▄████▄▄▄    {7}  ▄██▄  {0}\n\
 {2} ▄█▀███▀█▄    {3}███▀▀██▀▀███   {4}▄█▀██▀█▄   {5} ▄█▀███▀█▄    {6}███▀▀██▀▀███   {7}▄█▀██▀█▄{0}\n\
 {2}█▀███████▀█   {3}▀▀███▀▀███▀▀   {4}▀█▀██▀█▀   {5}█▀███████▀█   {6}▀▀███▀▀███▀▀   {7}▀█▀██▀█▀{0}\n\
 {2}▀ ▀▄▄ ▄▄▀ ▀   {3} ▀█▄ ▀▀ ▄█▀    {4}▀▄    ▄▀   {5}▀ ▀▄▄ ▄▄▀ ▀   {6} ▀█▄ ▀▀ ▄█▀    {7}▀▄    ▄▀{0}\n\
\n\
 {10}▄ ▀▄   ▄▀ ▄   {11} ▄▄▄████▄▄▄    {12}  ▄██▄     {13}▄ ▀▄   ▄▀ ▄   {14} ▄▄▄████▄▄▄    {15}  ▄██▄  {0}\n\
 {10}█▄█▀███▀█▄█   {11}███▀▀██▀▀███   {12}▄█▀██▀█▄   {13}█▄█▀███▀█▄█   {14}███▀▀██▀▀███   {15}▄█▀██▀█▄{0}\n\
 {10}▀█████████▀   {11}▀▀▀██▀▀██▀▀▀   {12}▀▀█▀▀█▀▀   {13}▀█████████▀   {14}▀▀▀██▀▀██▀▀▀   {15}▀▀█▀▀█▀▀{0}\n\
 {10} ▄▀     ▀▄    {11}▄▄▀▀ ▀▀ ▀▀▄▄   {12}▄▀▄▀▀▄▀▄   {13} ▄▀     ▀▄    {14}▄▄▀▀ ▀▀ ▀▀▄▄   {15}▄▀▄▀▀▄▀▄{0}\n\
\n\
\n\
                                     {16}▌{0}\n\
\n\
                                   {16}▌{0}\n\
\n\
                              {8}    ▄█▄    {0}\n\
                              {8}▄█████████▄{0}\n\
                              {8}▀▀▀▀▀▀▀▀▀▀▀{0}\n\
"

abcdef = "\
{10}  ██████   {11}██████  {12}   ██████ {13}██████   {14}  ██████ {15}  ███████\n\
{10}  ████████ {11}██    ██ {12}██       {13}██    ██ {14}██████  {15} █████████\n\
{2}  ██  ████ {3}██  ████{4} ████     {5}████  ██ {6}████     {7}█████ \n\
{2}  ██    ██ {3}██████ {4}  ████████ {5}██████   {6}████████ {7}██{0} \n\
"

pacman = "\
 {4}  ▄███████▄                {2}  ▄██████▄    {3}  ▄██████▄    {5}  ▄██████▄    {6}  ▄██████▄    {7}  ▄██████▄    \n\
 {4}▄█████████▀▀               {2}▄{8}█▀█{2}██{8}█▀█{2}██▄  {3}▄█{8}███{3}██{8}███{3}█▄  {5}▄█{8}███{5}██{8}███{5}█▄  {6}▄█{8}███{6}██{8}███{6}█▄  {7}▄██{8}█▀█{7}██{8}█▀█{7}▄\n\
 {4}███████▀      {8}▄▄  ▄▄  ▄▄   {2}█{8}▄▄█{2}██{8}▄▄█{2}███  {3}██{8}█ █{3}██{8}█ █{3}██  {5}██{8}█ █{5}██{8}█ █{5}██  {6}██{8}█ █{6}██{8}█ █{6}██  {7}███{8}█▄▄{7}██{8}█▄▄{7}█\n\
 {4}███████▄      {8}▀▀  ▀▀  ▀▀   {2}████████████  {3}████████████  {5}████████████  {6}████████████  {7}████████████  \n\
 {4}▀█████████▄▄               {2}██▀██▀▀██▀██  {3}██▀██▀▀██▀██  {5}██▀██▀▀██▀██  {6}██▀██▀▀██▀██  {7}██▀██▀▀██▀██\n\
 {4}  ▀███████▀                {2}▀   ▀  ▀   ▀  {3}▀   ▀  ▀   ▀  {5}▀   ▀  ▀   ▀  {6}▀   ▀  ▀   ▀  {7}▀   ▀  ▀   ▀ \n\
\n\
 {12}  ▄███████▄                {10}  ▄██████▄    {11}  ▄██████▄    {13}  ▄██████▄    {14}  ▄██████▄    {15}  ▄██████▄    \n\
 {12}▄█████████▀▀               {10}▄{16}█▀█{10}██{16}█▀█{10}██▄  {11}▄█{16}█ █{11}██{16}█ █{11}█▄  {13}▄█{16}█ █{13}██{16}█ █{13}█▄  {14}▄█{16}█ █{14}██{16}█ █{14}█▄  {15}▄██{16}█▀█{15}██{16}█▀█{15}▄\n\
 {12}███████▀      {16}▄▄  ▄▄  ▄▄   {10}█{16}▄▄█{10}██{16}▄▄█{10}███  {11}██{16}███{11}██{16}███{11}██  {13}██{16}███{13}██{16}███{13}██  {14}██{16}███{14}██{16}███{14}██  {15}███{16}█▄▄{15}██{16}█▄▄{15}█\n\
 {12}███████▄      {16}▀▀  ▀▀  ▀▀   {10}████████████  {11}████████████  {13}████████████  {14}████████████  {15}████████████  \n\
 {12}▀█████████▄▄               {10}██▀██▀▀██▀██  {11}██▀██▀▀██▀██  {13}██▀██▀▀██▀██  {14}██▀██▀▀██▀██  {15}██▀██▀▀██▀██\n\
 {12}  ▀███████▀                {10}▀   ▀  ▀   ▀  {11}▀   ▀  ▀   ▀  {13}▀   ▀  ▀   ▀  {14}▀   ▀  ▀   ▀  {15}▀   ▀  ▀   ▀ \n\
{0}"

dots = "\
{2}╔╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╗  {3}╔╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╗  {4}╔╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╗\n\
{10}╚╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╝  {11}╚╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╝  {12}╚╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╝{0}\n\
 {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ {8}■ {16}■ \n\
{5}╔╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╗  {6}╔╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╗  {7}╔╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╦╗\n\
{13}╚╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╝  {14}╚╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╝  {15}╚╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╩╝{0}\n\
"

tanks = "\
{2}    █    {0}    {3}    █    {0}    {4}    █    {0}    {5}    █    {0}    {6}    █    {0}    {7}    █    {0}\n\
{2}▄▄  █  ▄▄{0}    {3}▄▄  █  ▄▄{0}    {4}▄▄  █  ▄▄{0}    {5}▄▄  █  ▄▄{0}    {6}▄▄  █  ▄▄{0}    {7}▄▄  █  ▄▄{0}\n\
{2}███▀▀▀███{0}    {3}███▀▀▀███{0}    {4}███▀▀▀███{0}    {5}███▀▀▀███{0}    {6}███▀▀▀███{0}    {7}███▀▀▀███{0}\n\
{2}███ █ ███{0}    {3}███ █ ███{0}    {4}███ █ ███{0}    {5}███ █ ███{0}    {6}███ █ ███{0}    {7}███ █ ███{0}\n\
{2}██ ▀▀▀ ██{0}    {3}██ ▀▀▀ ██{0}    {4}██ ▀▀▀ ██{0}    {5}██ ▀▀▀ ██{0}    {6}██ ▀▀▀ ██{0}    {7}██ ▀▀▀ ██{0}\n\
\n\
{10}    █    {0}    {11}    █    {0}    {12}    █    {0}    {13}    █    {0}    {14}    █    {0}    {15}    █    {0}\n\
{10}▄▄  █  ▄▄{0}    {11}▄▄  █  ▄▄{0}    {12}▄▄  █  ▄▄{0}    {13}▄▄  █  ▄▄{0}    {14}▄▄  █  ▄▄{0}    {15}▄▄  █  ▄▄{0}\n\
{10}███▀▀▀███{0}    {11}███▀▀▀███{0}    {12}███▀▀▀███{0}    {13}███▀▀▀███{0}    {14}███▀▀▀███{0}    {15}███▀▀▀███{0}\n\
{10}███ █ ███{0}    {11}███ █ ███{0}    {12}███ █ ███{0}    {13}███ █ ███{0}    {14}███ █ ███{0}    {15}███ █ ███{0}\n\
{10}██ ▀▀▀ ██{0}    {11}██ ▀▀▀ ██{0}    {12}██ ▀▀▀ ██{0}    {13}██ ▀▀▀ ██{0}    {14}██ ▀▀▀ ██{0}    {15}██ ▀▀▀ ██{0}\n\
"

blocks = "\
{2}▀ █{0} {10}█ ▀{0}   {3}▀ █{0} {11}█ ▀{0}   {4}▀ █{0} {12}█ ▀{0}   {5}▀ █{0} {13}█ ▀{0}   {6}▀ █{0} {14}█ ▀{0}   {7}▀ █{0} {15}█ ▀{0}\n\
{2}██{0}  {10} ██{0}   {3}██{0}   {11}██{0}   {4}██{0}   {12}██{0}   {5}██{0}   {13}██{0}   {6}██{0}   {14}██{0}   {7}██{0}   {15}██{0}\n\
{2}▄ █{0}{10} █ ▄ {0}  {3}▄ █ {0}{11}█ ▄{0}   {4}▄ █ {0}{12}█ ▄{0}   {5}▄ █ {0}{13}█ ▄{0}   {6}▄ █ {0}{14}█ ▄{0}   {7}▄ █ {0}{15}█ ▄{0}\n\
"

dna = "\
 {2}█-----{10}█  {3}█-----{11}█  {4}█-----{12}█  {5}█-----{13}█  {6}█-----{14}█  {7}█-----{15}█\n\
  {2}█---{10}█    {3}█---{11}█    {4}█---{12}█    {5}█---{13}█    {6}█---{14}█    {7}█---{15}█\n\
  {2} █-{10}█     {3} █-{11}█     {4} █-{12}█     {5} █-{13}█     {6} █-{14}█     {7} █-{15}█\n\
    {2}█        {3}█        {4}█        {5}█        {6}█        {7}█\n\
   {10}█-{2}█      {11}█_{3}█      {12}█-{4}█      {13}█-{5}█      {14}█-{6}█      {15}█-{7}█\n\
  {10}█---{2}█    {11}█---{3}█    {12}█---{4}█    {13}█---{5}█    {14}█---{6}█    {15}█---{7}█ \n\
 {10}█-----{2}█  {11}█-----{3}█  {12}█-----{4}█  {13}█-----{5}█  {14}█-----{6}█  {15}█-----{7}█\n\
  {10}█---{2}█    {11}█---{3}█    {12}█---{4}█    {13}█---{5}█    {14}█---{6}█    {15}█---{7}█\n\
   {10}█-{2}█      {11}█-{3}█      {12}█-{4}█      {13}█-{5}█      {14}█-{6}█      {15}█-{7}█\n\
    {10}█        {11}█        {12}█        {13}█        {14}█        {15}█\n\
   {2}█-{10}█      {3}█-{11}█      {4}█-{12}█      {5}█-{13}█      {6}█-{14}█      {7}█-{15}█\n\
  {2}█---{10}█    {3}█---{11}█    {4}█---{12}█    {5}█---{13}█    {6}█---{14}█    {7}█---{15}█\n\
 {2}█-----{10}█  {3}█-----{11}█  {4}█-----{12}█  {5}█-----{13}█  {6}█-----{14}█  {7}█-----{15}█\n\
  {2}█---{10}█    {3}█---{11}█    {4}█---{12}█    {5}█---{13}█    {6}█---{14}█    {7}█---{15}█\n\
  {2} █-{10}█     {3} █-{11}█     {4} █-{12}█     {5} █-{13}█     {6} █-{14}█     {7} █-{15}█\n\
    {2}█        {3}█        {4}█        {5}█        {6}█        {7}█\n\
   {10}█-{2}█      {11}█_{3}█      {12}█-{4}█      {13}█-{5}█      {14}█-{6}█      {15}█-{7}█\n\
  {10}█---{2}█    {11}█---{3}█    {12}█---{4}█    {13}█---{5}█    {14}█---{6}█    {15}█---{7}█ \n\
 {10}█-----{2}█  {11}█-----{3}█  {12}█-----{4}█  {13}█-----{5}█  {14}█-----{6}█  {15}█-----{7}█\n\
  {10}█---{2}█    {11}█---{3}█    {12}█---{4}█    {13}█---{5}█    {14}█---{6}█    {15}█---{7}█\n\
   {10}█-{2}█      {11}█-{3}█      {12}█-{4}█      {13}█-{5}█      {14}█-{6}█      {15}█-{7}█\n\
    {10}█        {11}█        {12}█        {13}█        {14}█        {15}█\n\
   {2}█-{10}█      {3}█-{11}█      {4}█-{12}█      {5}█-{13}█      {6}█-{14}█      {7}█-{15}█\n\
  {2}█---{10}█    {3}█---{11}█    {4}█---{12}█    {5}█---{13}█    {6}█---{14}█    {7}█---{15}█\n\
 {2}█-----{10}█  {3}█-----{11}█  {4}█-----{12}█  {5}█-----{13}█  {6}█-----{14}█  {7}█-----{15}█\n\
"

ghosts = "\
{2}    ▄▄▄      {3}    ▄▄▄      {4}    ▄▄▄      {5}    ▄▄▄      {6}    ▄▄▄      {7}    ▄▄▄  \n\
{2}   ▀█▀██  ▄  {3}   ▀█▀██  ▄  {4}   ▀█▀██  ▄  {5}   ▀█▀██  ▄  {6}   ▀█▀██  ▄  {7}   ▀█▀██  ▄ \n\
{2} ▀▄██████▀   {3} ▀▄██████▀   {4} ▀▄██████▀   {5} ▀▄██████▀   {6} ▀▄██████▀   {7} ▀▄██████▀  \n\
{2}    ▀█████   {3}    ▀█████   {4}    ▀█████   {5}    ▀█████   {6}    ▀█████   {7}    ▀█████  \n\
{2}       ▀▀▀▀▄ {3}       ▀▀▀▀▄ {4}       ▀▀▀▀▄ {5}       ▀▀▀▀▄ {6}       ▀▀▀▀▄ {7}       ▀▀▀▀▄\n\
\n\
{10}    ▄▄▄      {11}    ▄▄▄      {12}    ▄▄▄      {13}    ▄▄▄      {14}    ▄▄▄      {15}    ▄▄▄  \n\
{10}   ▀█▀██  ▄  {11}   ▀█▀██  ▄  {12}   ▀█▀██  ▄  {13}   ▀█▀██  ▄  {14}   ▀█▀██  ▄  {15}   ▀█▀██  ▄ \n\
{10} ▀▄██████▀   {11} ▀▄██████▀   {12} ▀▄██████▀   {13} ▀▄██████▀   {14} ▀▄██████▀   {15} ▀▄██████▀  \n\
{10}    ▀█████   {11}    ▀█████   {12}    ▀█████   {13}    ▀█████   {14}    ▀█████   {15}    ▀█████  \n\
{10}       ▀▀▀▀▄ {11}       ▀▀▀▀▄ {12}       ▀▀▀▀▄ {13}       ▀▀▀▀▄ {14}       ▀▀▀▀▄ {15}       ▀▀▀▀▄\n\
{0}\n\
"

basic = "\
  {1}color0     {2}color1     {3}color2     {4}color3     {5}color4     {6}color5     {7}color6     {8}color7 \n\
  {1}███████    {2}███████    {3}███████    {4}███████    {5}███████    {6}███████    {7}███████    {8}███████\n\
  {1}███████    {2}███████    {3}███████    {4}███████    {5}███████    {6}███████    {7}███████    {8}███████\n\
                                                                                      \n\
  {9}color8     {10}color9     {11}color10    {12}color11    {13}color12    {14}color13    {15}color14    {16}color15\n\
  {9}███████    {10}███████    {11}███████    {12}███████    {13}███████    {14}███████    {15}███████    {16}███████\n\
  {9}███████    {10}███████    {11}███████    {12}███████    {13}███████    {14}███████    {15}███████    {16}███████\n\
{0}"

art_choices = {
  'abcdef': abcdef,
  'basic': basic,
  'blocks': blocks,
  'dots': dots,
  'dna': dna,
  'ghosts': ghosts,
  'invaders': invaders,
  'pacman': pacman,
  'tanks': tanks,
}


def main(art_choice):
  import sys

  art = art_choices[art_choice]
  print >> sys.stdout, art.format(clear, 
                                  black,
                                  red,
                                  green,
                                  yellow,
                                  blue,
                                  purple,
                                  cyan,
                                  white,
                                  bright_black,
                                  bright_red,
                                  bright_green,
                                  bright_yellow,
                                  bright_blue,
                                  bright_purple,
                                  bright_cyan,
                                  bright_white)

