#!/usr/bin/env python

import os
import sys

import complexity

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

if sys.argv[-1] == 'publish':
    os.system('python setup.py sdist upload')
    sys.exit()

with open('README.rst') as f:
    readme = f.read()
    
with open('HISTORY.rst') as f:
    history = f.read()
history.replace(".. :changelog:", "")

requirements = ['jinja2==2.7']

if sys.version_info[:2] < (2, 7):
    requirements.append('argparse')
    
setup(
    name='complexity',
    version=complexity.__version__,
    description='A refreshingly simple static site generator, for those who like to work in HTML.',
    long_description=readme + '\n\n' + history,
    author='Audrey Roy',
    author_email='audreyr@gmail.com',
    url='https://github.com/audreyr/complexity',
    packages=[
        'complexity',
    ],
    package_dir={'complexity': 'complexity'},
    entry_points={
        'console_scripts': [
            'complexity = complexity.main:main',
        ]
    },
    include_package_data=True,
    install_requires=requirements,
    license="BSD",
    zip_safe=False,
    keywords='complexity,static site generator,HTML,Jinja2,templates,S3',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        "Environment :: Console",
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.3',
        'Topic :: Internet :: WWW/HTTP :: Site Management',
    ],
    test_suite='tests',
)
