#
# Autogenerated by Thrift Compiler (1.0.0-dev)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style,utf8strings
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
import concrete.structure.ttypes
import concrete.metadata.ttypes
import concrete.uuid.ttypes


from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None



class Argument(object):
  """
  A situation argument, consisting of an argument role and a value.
  Argument values may be Entities or Situations.

  Attributes:
   - role: The relationship between this argument and the situation that
  owns it. The roles that a situation's arguments can take
  depend on the type of the situation (including subtype
  information, such as event_type).
   - entityId: A pointer to the value of this argument, if it is explicitly
  encoded as an Entity.
   - situationId: A pointer to the value of this argument, if it is a situation.
   - roleLabel: New roles should usually be added to the enum, but for use
  cases with many varied and possibly dynamic role names, this can be
  used. Presumably this would only be used in a prototype stage of an
  analytic, with roles eventually "hardening" and moving to the enum.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'role', None, None, ), # 1
    (2, TType.STRUCT, 'entityId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'situationId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 3
    (4, TType.STRING, 'roleLabel', None, None, ), # 4
  )

  def __init__(self, role=None, entityId=None, situationId=None, roleLabel=None,):
    self.role = role
    self.entityId = entityId
    self.situationId = situationId
    self.roleLabel = roleLabel

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.role = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.entityId = concrete.uuid.ttypes.UUID()
          self.entityId.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.situationId = concrete.uuid.ttypes.UUID()
          self.situationId.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.roleLabel = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Argument')
    if self.role is not None:
      oprot.writeFieldBegin('role', TType.STRING, 1)
      oprot.writeString(self.role.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.entityId is not None:
      oprot.writeFieldBegin('entityId', TType.STRUCT, 2)
      self.entityId.write(oprot)
      oprot.writeFieldEnd()
    if self.situationId is not None:
      oprot.writeFieldBegin('situationId', TType.STRUCT, 3)
      self.situationId.write(oprot)
      oprot.writeFieldEnd()
    if self.roleLabel is not None:
      oprot.writeFieldBegin('roleLabel', TType.STRING, 4)
      oprot.writeString(self.roleLabel.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Justification(object):
  """
  Attributes:
   - justificationType: An enumerated value used to describe the way in which the
  justification's mention provides supporting evidence for the
  situation.
   - mentionId: A pointer to the SituationMention itself.
   - tokens: An optional list of pointers to tokens that are (especially)
  relevant to the way in which this mention provides
  justification for the situation. It is left up to individual
  analytics to decide what tokens (if any) they wish to include
  in this field.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'justificationType', None, None, ), # 1
    (2, TType.STRUCT, 'mentionId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 2
    (3, TType.LIST, 'tokens', (TType.STRUCT,(concrete.structure.ttypes.TokenRefSequence, concrete.structure.ttypes.TokenRefSequence.thrift_spec)), None, ), # 3
  )

  def __init__(self, justificationType=None, mentionId=None, tokens=None,):
    self.justificationType = justificationType
    self.mentionId = mentionId
    self.tokens = tokens

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.justificationType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.mentionId = concrete.uuid.ttypes.UUID()
          self.mentionId.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.tokens = []
          (_etype3, _size0) = iprot.readListBegin()
          for _i4 in xrange(_size0):
            _elem5 = concrete.structure.ttypes.TokenRefSequence()
            _elem5.read(iprot)
            self.tokens.append(_elem5)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Justification')
    if self.justificationType is not None:
      oprot.writeFieldBegin('justificationType', TType.STRING, 1)
      oprot.writeString(self.justificationType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.mentionId is not None:
      oprot.writeFieldBegin('mentionId', TType.STRUCT, 2)
      self.mentionId.write(oprot)
      oprot.writeFieldEnd()
    if self.tokens is not None:
      oprot.writeFieldBegin('tokens', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.tokens))
      for iter6 in self.tokens:
        iter6.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.mentionId is None:
      raise TProtocol.TProtocolException(message='Required field mentionId is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Situation(object):
  """
  A single situation, along with pointers to situation mentions that
  provide evidence for the situation. "Situations" include events,
  relations, facts, sentiments, and beliefs. Each situation has a
  core type (such as EVENT or SENTIMENT), along with an optional
  subtype based on its core type (e.g., event_type=CONTACT_MEET), and
  a set of zero or more unordered arguments.

  Attributes:
   - uuid: Unique identifier for this situation.
   - situationType: The core type of this situation (eg EVENT or SENTIMENT).
   - argumentList: The arguments for this situation. Each argument consists of a
  role and a value. It is possible for an situation to have
  multiple arguments with the same role. Arguments are
  unordered.
   - mentionIdList: Ids of the mentions of this situation in a communication
  (type=SituationMention)
   - justificationList: An list of pointers to SituationMentions that provide
  justification for this situation. These mentions may be either
  direct mentions of the situation, or indirect evidence.
   - eventType: The event type for situations where situation_type=EVENT
   - stateType: The state type for situations where situation_type=STATE
   - temporalFactType: The temporal fact type for situations where situation_type=TEMPORAL_FACT
   - situationKindLemma: This lemma represents a canonical lemma for the situation kind
  when the situation kind cannot be specified by a situation type subtype
  (ex, when using arbitrary verbs or nominalizations as events which do
  not appear in the event_type enumeration).
  If this kind is grounded in a token sequence from the original text, the
  appropriate SituationMention should have a reference to the token sequence.
   - timemlClass: The TimeML class for situations representing TimeML events
   - timemlTense: The TimeML tense for situations representing TimeML events
   - timemlAspect: The TimeML aspect for situations representing TimeML events
   - intensity: An "intensity" rating for this situation, typically ranging from
  0-1. In the case of SENTIMENT situations, this is used to record
  the intensity of the sentiment.
   - polarity: The polarity of this situation. In the case of SENTIMENT
  situations, this is used to record the polarity of the
  sentiment.
   - confidence: A confidence score for this individual situation. You can also
  set a confidence score for an entire SituationSet using the
  SituationSet's metadata.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRING, 'situationType', None, None, ), # 2
    (3, TType.LIST, 'argumentList', (TType.STRUCT,(Argument, Argument.thrift_spec)), None, ), # 3
    (4, TType.LIST, 'mentionIdList', (TType.STRUCT,(concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec)), None, ), # 4
    (5, TType.LIST, 'justificationList', (TType.STRUCT,(Justification, Justification.thrift_spec)), None, ), # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    None, # 10
    None, # 11
    None, # 12
    None, # 13
    None, # 14
    None, # 15
    None, # 16
    None, # 17
    None, # 18
    None, # 19
    None, # 20
    None, # 21
    None, # 22
    None, # 23
    None, # 24
    None, # 25
    None, # 26
    None, # 27
    None, # 28
    None, # 29
    None, # 30
    None, # 31
    None, # 32
    None, # 33
    None, # 34
    None, # 35
    None, # 36
    None, # 37
    None, # 38
    None, # 39
    None, # 40
    None, # 41
    None, # 42
    None, # 43
    None, # 44
    None, # 45
    None, # 46
    None, # 47
    None, # 48
    None, # 49
    (50, TType.STRING, 'eventType', None, None, ), # 50
    (51, TType.STRING, 'stateType', None, None, ), # 51
    (52, TType.STRING, 'temporalFactType', None, None, ), # 52
    (53, TType.STRING, 'situationKindLemma', None, None, ), # 53
    (54, TType.STRING, 'timemlClass', None, None, ), # 54
    (55, TType.STRING, 'timemlTense', None, None, ), # 55
    (56, TType.STRING, 'timemlAspect', None, None, ), # 56
    None, # 57
    None, # 58
    None, # 59
    None, # 60
    None, # 61
    None, # 62
    None, # 63
    None, # 64
    None, # 65
    None, # 66
    None, # 67
    None, # 68
    None, # 69
    None, # 70
    None, # 71
    None, # 72
    None, # 73
    None, # 74
    None, # 75
    None, # 76
    None, # 77
    None, # 78
    None, # 79
    None, # 80
    None, # 81
    None, # 82
    None, # 83
    None, # 84
    None, # 85
    None, # 86
    None, # 87
    None, # 88
    None, # 89
    None, # 90
    None, # 91
    None, # 92
    None, # 93
    None, # 94
    None, # 95
    None, # 96
    None, # 97
    None, # 98
    None, # 99
    (100, TType.DOUBLE, 'intensity', None, None, ), # 100
    (101, TType.STRING, 'polarity', None, None, ), # 101
    None, # 102
    None, # 103
    None, # 104
    None, # 105
    None, # 106
    None, # 107
    None, # 108
    None, # 109
    None, # 110
    None, # 111
    None, # 112
    None, # 113
    None, # 114
    None, # 115
    None, # 116
    None, # 117
    None, # 118
    None, # 119
    None, # 120
    None, # 121
    None, # 122
    None, # 123
    None, # 124
    None, # 125
    None, # 126
    None, # 127
    None, # 128
    None, # 129
    None, # 130
    None, # 131
    None, # 132
    None, # 133
    None, # 134
    None, # 135
    None, # 136
    None, # 137
    None, # 138
    None, # 139
    None, # 140
    None, # 141
    None, # 142
    None, # 143
    None, # 144
    None, # 145
    None, # 146
    None, # 147
    None, # 148
    None, # 149
    None, # 150
    None, # 151
    None, # 152
    None, # 153
    None, # 154
    None, # 155
    None, # 156
    None, # 157
    None, # 158
    None, # 159
    None, # 160
    None, # 161
    None, # 162
    None, # 163
    None, # 164
    None, # 165
    None, # 166
    None, # 167
    None, # 168
    None, # 169
    None, # 170
    None, # 171
    None, # 172
    None, # 173
    None, # 174
    None, # 175
    None, # 176
    None, # 177
    None, # 178
    None, # 179
    None, # 180
    None, # 181
    None, # 182
    None, # 183
    None, # 184
    None, # 185
    None, # 186
    None, # 187
    None, # 188
    None, # 189
    None, # 190
    None, # 191
    None, # 192
    None, # 193
    None, # 194
    None, # 195
    None, # 196
    None, # 197
    None, # 198
    None, # 199
    (200, TType.DOUBLE, 'confidence', None, None, ), # 200
  )

  def __init__(self, uuid=None, situationType=None, argumentList=None, mentionIdList=None, justificationList=None, eventType=None, stateType=None, temporalFactType=None, situationKindLemma=None, timemlClass=None, timemlTense=None, timemlAspect=None, intensity=None, polarity=None, confidence=None,):
    self.uuid = uuid
    self.situationType = situationType
    self.argumentList = argumentList
    self.mentionIdList = mentionIdList
    self.justificationList = justificationList
    self.eventType = eventType
    self.stateType = stateType
    self.temporalFactType = temporalFactType
    self.situationKindLemma = situationKindLemma
    self.timemlClass = timemlClass
    self.timemlTense = timemlTense
    self.timemlAspect = timemlAspect
    self.intensity = intensity
    self.polarity = polarity
    self.confidence = confidence

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.situationType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.argumentList = []
          (_etype10, _size7) = iprot.readListBegin()
          for _i11 in xrange(_size7):
            _elem12 = Argument()
            _elem12.read(iprot)
            self.argumentList.append(_elem12)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.mentionIdList = []
          (_etype16, _size13) = iprot.readListBegin()
          for _i17 in xrange(_size13):
            _elem18 = concrete.uuid.ttypes.UUID()
            _elem18.read(iprot)
            self.mentionIdList.append(_elem18)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.justificationList = []
          (_etype22, _size19) = iprot.readListBegin()
          for _i23 in xrange(_size19):
            _elem24 = Justification()
            _elem24.read(iprot)
            self.justificationList.append(_elem24)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 50:
        if ftype == TType.STRING:
          self.eventType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 51:
        if ftype == TType.STRING:
          self.stateType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 52:
        if ftype == TType.STRING:
          self.temporalFactType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 53:
        if ftype == TType.STRING:
          self.situationKindLemma = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 54:
        if ftype == TType.STRING:
          self.timemlClass = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 55:
        if ftype == TType.STRING:
          self.timemlTense = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 56:
        if ftype == TType.STRING:
          self.timemlAspect = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 100:
        if ftype == TType.DOUBLE:
          self.intensity = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 101:
        if ftype == TType.STRING:
          self.polarity = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 200:
        if ftype == TType.DOUBLE:
          self.confidence = iprot.readDouble();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Situation')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.situationType is not None:
      oprot.writeFieldBegin('situationType', TType.STRING, 2)
      oprot.writeString(self.situationType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.argumentList is not None:
      oprot.writeFieldBegin('argumentList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.argumentList))
      for iter25 in self.argumentList:
        iter25.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.mentionIdList is not None:
      oprot.writeFieldBegin('mentionIdList', TType.LIST, 4)
      oprot.writeListBegin(TType.STRUCT, len(self.mentionIdList))
      for iter26 in self.mentionIdList:
        iter26.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.justificationList is not None:
      oprot.writeFieldBegin('justificationList', TType.LIST, 5)
      oprot.writeListBegin(TType.STRUCT, len(self.justificationList))
      for iter27 in self.justificationList:
        iter27.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.eventType is not None:
      oprot.writeFieldBegin('eventType', TType.STRING, 50)
      oprot.writeString(self.eventType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.stateType is not None:
      oprot.writeFieldBegin('stateType', TType.STRING, 51)
      oprot.writeString(self.stateType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.temporalFactType is not None:
      oprot.writeFieldBegin('temporalFactType', TType.STRING, 52)
      oprot.writeString(self.temporalFactType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.situationKindLemma is not None:
      oprot.writeFieldBegin('situationKindLemma', TType.STRING, 53)
      oprot.writeString(self.situationKindLemma.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.timemlClass is not None:
      oprot.writeFieldBegin('timemlClass', TType.STRING, 54)
      oprot.writeString(self.timemlClass.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.timemlTense is not None:
      oprot.writeFieldBegin('timemlTense', TType.STRING, 55)
      oprot.writeString(self.timemlTense.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.timemlAspect is not None:
      oprot.writeFieldBegin('timemlAspect', TType.STRING, 56)
      oprot.writeString(self.timemlAspect.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.intensity is not None:
      oprot.writeFieldBegin('intensity', TType.DOUBLE, 100)
      oprot.writeDouble(self.intensity)
      oprot.writeFieldEnd()
    if self.polarity is not None:
      oprot.writeFieldBegin('polarity', TType.STRING, 101)
      oprot.writeString(self.polarity.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.confidence is not None:
      oprot.writeFieldBegin('confidence', TType.DOUBLE, 200)
      oprot.writeDouble(self.confidence)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.situationType is None:
      raise TProtocol.TProtocolException(message='Required field situationType is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SituationSet(object):
  """
  A theory about the set of situations that are present in a
  message. See also: Situation

  Attributes:
   - uuid: Unique identifier for this set.
   - metadata: Information about where this set came from.
   - situationList: List of mentions in this set.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'situationList', (TType.STRUCT,(Situation, Situation.thrift_spec)), None, ), # 3
  )

  def __init__(self, uuid=None, metadata=None, situationList=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.situationList = situationList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.situationList = []
          (_etype31, _size28) = iprot.readListBegin()
          for _i32 in xrange(_size28):
            _elem33 = Situation()
            _elem33.read(iprot)
            self.situationList.append(_elem33)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SituationSet')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.situationList is not None:
      oprot.writeFieldBegin('situationList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.situationList))
      for iter34 in self.situationList:
        iter34.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.situationList is None:
      raise TProtocol.TProtocolException(message='Required field situationList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class MentionArgument(object):
  """
  A "concrete" argument, that may be used by SituationMentions or EntityMentions
  to avoid conflicts where abstract Arguments were being used to support concrete Mentions.

  Attributes:
   - role: The relationship between this argument and the situation that
  owns it. The roles that a situation's arguments can take
  depend on the type of the situation (including subtype
  information, such as event_type).
   - entityMentionId: A pointer to the value of an EntityMention, if this is being used to support
  an EntityMention.
   - situationMentionId: A pointer to the value of this argument, if it is a SituationMention.
   - roleLabel: New roles should usually be added to the enum, but for use
  cases with many varied and possibly dynamic role names, this can be
  used. Presumably this would only be used in a prototype stage of an
  analytic, with roles eventually "hardening" and moving to the enum.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'role', None, None, ), # 1
    (2, TType.STRUCT, 'entityMentionId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'situationMentionId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 3
    (4, TType.STRING, 'roleLabel', None, None, ), # 4
  )

  def __init__(self, role=None, entityMentionId=None, situationMentionId=None, roleLabel=None,):
    self.role = role
    self.entityMentionId = entityMentionId
    self.situationMentionId = situationMentionId
    self.roleLabel = roleLabel

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.role = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.entityMentionId = concrete.uuid.ttypes.UUID()
          self.entityMentionId.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.situationMentionId = concrete.uuid.ttypes.UUID()
          self.situationMentionId.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.roleLabel = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('MentionArgument')
    if self.role is not None:
      oprot.writeFieldBegin('role', TType.STRING, 1)
      oprot.writeString(self.role.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.entityMentionId is not None:
      oprot.writeFieldBegin('entityMentionId', TType.STRUCT, 2)
      self.entityMentionId.write(oprot)
      oprot.writeFieldEnd()
    if self.situationMentionId is not None:
      oprot.writeFieldBegin('situationMentionId', TType.STRUCT, 3)
      self.situationMentionId.write(oprot)
      oprot.writeFieldEnd()
    if self.roleLabel is not None:
      oprot.writeFieldBegin('roleLabel', TType.STRING, 4)
      oprot.writeString(self.roleLabel.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SituationMention(object):
  """
  A concrete mention of a situation, where "situations" include
  events, relations, facts, sentiments, and beliefs. Each situation
  has a core type (such as EVENT or SENTIMENT), along with an
  optional subtype based on its core type (e.g.,
  event_type=CONTACT_MEET), and a set of zero or more unordered
  arguments.

  Attributes:
   - uuid: Unique identifier for this situation.
   - text: The text content of this situation mention. This field is
  often redundant with the 'tokens' field, and may not
  be generated by all analytics.
   - situationType: The core type of this situation (eg EVENT or SENTIMENT)
   - argumentList: The arguments for this situation mention. Each argument
  consists of a role and a value. It is possible for an situation
  to have multiple arguments with the same role. Arguments are
  unordered.
   - eventType: The event type for situations where situation_type=EVENT
   - stateType: The state type for situations where situation_type=STATE
   - situationKindLemma: This lemma represents a canonical lemma for the situation kind
  when the situation kind cannot be specified by a situation type subtype
  (ex, when using arbitrary verbs or nominalizations as events which do
  not appear in the event_type enumeration).
  If this kind is grounded in a token sequence from the original text, the
  SituationMention should have a reference to the token sequence.
   - intensity: An "intensity" rating for the situation, typically ranging from
  0-1. In the case of SENTIMENT situations, this is used to record
  the intensity of the sentiment.
   - polarity: The polarity of this situation. In the case of SENTIMENT
  situations, this is used to record the polarity of the
  sentiment.
   - tokens: An optional pointer to tokens that are (especially)
  relevant to this situation mention. It is left up to individual
  analytics to decide what tokens (if any) they wish to include in
  this field. In particular, it is not specified whether the
  arguments' tokens should be included.
   - confidence: A confidence score for this individual situation mention. You
  can also set a confidence score for an entire SituationMentionSet
  using the SituationMentionSet's metadata.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRING, 'text', None, None, ), # 2
    (3, TType.STRING, 'situationType', None, None, ), # 3
    (4, TType.LIST, 'argumentList', (TType.STRUCT,(MentionArgument, MentionArgument.thrift_spec)), None, ), # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    None, # 10
    None, # 11
    None, # 12
    None, # 13
    None, # 14
    None, # 15
    None, # 16
    None, # 17
    None, # 18
    None, # 19
    None, # 20
    None, # 21
    None, # 22
    None, # 23
    None, # 24
    None, # 25
    None, # 26
    None, # 27
    None, # 28
    None, # 29
    None, # 30
    None, # 31
    None, # 32
    None, # 33
    None, # 34
    None, # 35
    None, # 36
    None, # 37
    None, # 38
    None, # 39
    None, # 40
    None, # 41
    None, # 42
    None, # 43
    None, # 44
    None, # 45
    None, # 46
    None, # 47
    None, # 48
    None, # 49
    (50, TType.STRING, 'eventType', None, None, ), # 50
    (51, TType.STRING, 'stateType', None, None, ), # 51
    None, # 52
    (53, TType.STRING, 'situationKindLemma', None, None, ), # 53
    None, # 54
    None, # 55
    None, # 56
    None, # 57
    None, # 58
    None, # 59
    None, # 60
    None, # 61
    None, # 62
    None, # 63
    None, # 64
    None, # 65
    None, # 66
    None, # 67
    None, # 68
    None, # 69
    None, # 70
    None, # 71
    None, # 72
    None, # 73
    None, # 74
    None, # 75
    None, # 76
    None, # 77
    None, # 78
    None, # 79
    None, # 80
    None, # 81
    None, # 82
    None, # 83
    None, # 84
    None, # 85
    None, # 86
    None, # 87
    None, # 88
    None, # 89
    None, # 90
    None, # 91
    None, # 92
    None, # 93
    None, # 94
    None, # 95
    None, # 96
    None, # 97
    None, # 98
    None, # 99
    (100, TType.DOUBLE, 'intensity', None, None, ), # 100
    (101, TType.STRING, 'polarity', None, None, ), # 101
    None, # 102
    None, # 103
    None, # 104
    None, # 105
    None, # 106
    None, # 107
    None, # 108
    None, # 109
    None, # 110
    None, # 111
    None, # 112
    None, # 113
    None, # 114
    None, # 115
    None, # 116
    None, # 117
    None, # 118
    None, # 119
    None, # 120
    None, # 121
    None, # 122
    None, # 123
    None, # 124
    None, # 125
    None, # 126
    None, # 127
    None, # 128
    None, # 129
    None, # 130
    None, # 131
    None, # 132
    None, # 133
    None, # 134
    None, # 135
    None, # 136
    None, # 137
    None, # 138
    None, # 139
    None, # 140
    None, # 141
    None, # 142
    None, # 143
    None, # 144
    None, # 145
    None, # 146
    None, # 147
    None, # 148
    None, # 149
    (150, TType.STRUCT, 'tokens', (concrete.structure.ttypes.TokenRefSequence, concrete.structure.ttypes.TokenRefSequence.thrift_spec), None, ), # 150
    None, # 151
    None, # 152
    None, # 153
    None, # 154
    None, # 155
    None, # 156
    None, # 157
    None, # 158
    None, # 159
    None, # 160
    None, # 161
    None, # 162
    None, # 163
    None, # 164
    None, # 165
    None, # 166
    None, # 167
    None, # 168
    None, # 169
    None, # 170
    None, # 171
    None, # 172
    None, # 173
    None, # 174
    None, # 175
    None, # 176
    None, # 177
    None, # 178
    None, # 179
    None, # 180
    None, # 181
    None, # 182
    None, # 183
    None, # 184
    None, # 185
    None, # 186
    None, # 187
    None, # 188
    None, # 189
    None, # 190
    None, # 191
    None, # 192
    None, # 193
    None, # 194
    None, # 195
    None, # 196
    None, # 197
    None, # 198
    None, # 199
    (200, TType.DOUBLE, 'confidence', None, None, ), # 200
  )

  def __init__(self, uuid=None, text=None, situationType=None, argumentList=None, eventType=None, stateType=None, situationKindLemma=None, intensity=None, polarity=None, tokens=None, confidence=None,):
    self.uuid = uuid
    self.text = text
    self.situationType = situationType
    self.argumentList = argumentList
    self.eventType = eventType
    self.stateType = stateType
    self.situationKindLemma = situationKindLemma
    self.intensity = intensity
    self.polarity = polarity
    self.tokens = tokens
    self.confidence = confidence

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.text = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.situationType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.argumentList = []
          (_etype38, _size35) = iprot.readListBegin()
          for _i39 in xrange(_size35):
            _elem40 = MentionArgument()
            _elem40.read(iprot)
            self.argumentList.append(_elem40)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 50:
        if ftype == TType.STRING:
          self.eventType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 51:
        if ftype == TType.STRING:
          self.stateType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 53:
        if ftype == TType.STRING:
          self.situationKindLemma = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 100:
        if ftype == TType.DOUBLE:
          self.intensity = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 101:
        if ftype == TType.STRING:
          self.polarity = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 150:
        if ftype == TType.STRUCT:
          self.tokens = concrete.structure.ttypes.TokenRefSequence()
          self.tokens.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 200:
        if ftype == TType.DOUBLE:
          self.confidence = iprot.readDouble();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SituationMention')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.text is not None:
      oprot.writeFieldBegin('text', TType.STRING, 2)
      oprot.writeString(self.text.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.situationType is not None:
      oprot.writeFieldBegin('situationType', TType.STRING, 3)
      oprot.writeString(self.situationType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.argumentList is not None:
      oprot.writeFieldBegin('argumentList', TType.LIST, 4)
      oprot.writeListBegin(TType.STRUCT, len(self.argumentList))
      for iter41 in self.argumentList:
        iter41.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.eventType is not None:
      oprot.writeFieldBegin('eventType', TType.STRING, 50)
      oprot.writeString(self.eventType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.stateType is not None:
      oprot.writeFieldBegin('stateType', TType.STRING, 51)
      oprot.writeString(self.stateType.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.situationKindLemma is not None:
      oprot.writeFieldBegin('situationKindLemma', TType.STRING, 53)
      oprot.writeString(self.situationKindLemma.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.intensity is not None:
      oprot.writeFieldBegin('intensity', TType.DOUBLE, 100)
      oprot.writeDouble(self.intensity)
      oprot.writeFieldEnd()
    if self.polarity is not None:
      oprot.writeFieldBegin('polarity', TType.STRING, 101)
      oprot.writeString(self.polarity.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.tokens is not None:
      oprot.writeFieldBegin('tokens', TType.STRUCT, 150)
      self.tokens.write(oprot)
      oprot.writeFieldEnd()
    if self.confidence is not None:
      oprot.writeFieldBegin('confidence', TType.DOUBLE, 200)
      oprot.writeDouble(self.confidence)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.argumentList is None:
      raise TProtocol.TProtocolException(message='Required field argumentList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SituationMentionSet(object):
  """
  A theory about the set of situation mentions that are present in a
  message. See also: SituationMention

  Attributes:
   - uuid: Unique identifier for this set.
   - metadata: Information about where this set came from.
   - mentionList: List of mentions in this set.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'mentionList', (TType.STRUCT,(SituationMention, SituationMention.thrift_spec)), None, ), # 3
  )

  def __init__(self, uuid=None, metadata=None, mentionList=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.mentionList = mentionList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.mentionList = []
          (_etype45, _size42) = iprot.readListBegin()
          for _i46 in xrange(_size42):
            _elem47 = SituationMention()
            _elem47.read(iprot)
            self.mentionList.append(_elem47)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SituationMentionSet')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.mentionList is not None:
      oprot.writeFieldBegin('mentionList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.mentionList))
      for iter48 in self.mentionList:
        iter48.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.mentionList is None:
      raise TProtocol.TProtocolException(message='Required field mentionList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
