#
# Autogenerated by Thrift Compiler (1.0.0-dev)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style,utf8strings
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
import concrete.metadata.ttypes
import concrete.spans.ttypes
import concrete.uuid.ttypes


from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class TokenizationKind(object):
  """
  Enumerated types of Tokenizations
  """
  TOKEN_LIST = 1
  TOKEN_LATTICE = 2

  _VALUES_TO_NAMES = {
    1: "TOKEN_LIST",
    2: "TOKEN_LATTICE",
  }

  _NAMES_TO_VALUES = {
    "TOKEN_LIST": 1,
    "TOKEN_LATTICE": 2,
  }


class Token(object):
  """
  A single token (typically a word) in a communication. The exact
  definition of what counts as a token is left up to the tools that
  generate token sequences.

  Usually, each token will include at least a text string.

  Attributes:
   - tokenIndex: A tokenization-relative identifier for this token. Together
  with the UUID for a Tokenization, this can be used to define
  pointers to specific tokens. If a Tokenization object contains
  multiple Token objects with the same id (e.g., in different
  n-best lists), then all of their other fields *must* be
  identical as well.
   - text: The text associated with this token.
  Note - we may have a destructive tokenizer (e.g., Stanford rewriting)
  and as a result, we want to maintain this field.
   - textSpan: Location of this token in the original text. In cases where
  this token does not correspond directly with any text span in
  the original text (such as word insertion during MT), this field
  may be given a value indicating "approximately" where the token
  comes from. A span covering the entire sentence may be used if
  no more precise value seems appropriate.
   - audioSpan: Location of this token in the original audio.
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'tokenIndex', None, None, ), # 1
    (2, TType.STRING, 'text', None, None, ), # 2
    (3, TType.STRUCT, 'textSpan', (concrete.spans.ttypes.TextSpan, concrete.spans.ttypes.TextSpan.thrift_spec), None, ), # 3
    None, # 4
    (5, TType.STRUCT, 'audioSpan', (concrete.spans.ttypes.AudioSpan, concrete.spans.ttypes.AudioSpan.thrift_spec), None, ), # 5
  )

  def __init__(self, tokenIndex=None, text=None, textSpan=None, audioSpan=None,):
    self.tokenIndex = tokenIndex
    self.text = text
    self.textSpan = textSpan
    self.audioSpan = audioSpan

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.tokenIndex = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.text = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.textSpan = concrete.spans.ttypes.TextSpan()
          self.textSpan.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRUCT:
          self.audioSpan = concrete.spans.ttypes.AudioSpan()
          self.audioSpan.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Token')
    if self.tokenIndex is not None:
      oprot.writeFieldBegin('tokenIndex', TType.I32, 1)
      oprot.writeI32(self.tokenIndex)
      oprot.writeFieldEnd()
    if self.text is not None:
      oprot.writeFieldBegin('text', TType.STRING, 2)
      oprot.writeString(self.text.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.textSpan is not None:
      oprot.writeFieldBegin('textSpan', TType.STRUCT, 3)
      self.textSpan.write(oprot)
      oprot.writeFieldEnd()
    if self.audioSpan is not None:
      oprot.writeFieldBegin('audioSpan', TType.STRUCT, 5)
      self.audioSpan.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.tokenIndex is None:
      raise TProtocol.TProtocolException(message='Required field tokenIndex is unset!')
    if self.text is None:
      raise TProtocol.TProtocolException(message='Required field text is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TokenRefSequence(object):
  """
  A list of pointers to tokens that all belong to the same
  tokenization.

  Attributes:
   - tokenIndexList: The tokenization-relative identifiers for each token that is
  included in this sequence.
   - anchorTokenIndex: An optional field that can be used to describe
  the root of a sentence (if this sequence is a full sentence),
  the head of a constituent (if this sequence is a constituent),
  or some other form of "canonical" token in this sequence if,
  for instance, it is not easy to map this sequence to a another
  annotation that has a head.
   - tokenizationId: The UUID of the tokenization that contains the tokens.
   - textSpan: The text span associated with this TokenRefSequence.
   - audioSpan: The audio span associated with this TokenRefSequence.
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'tokenIndexList', (TType.I32,None), None, ), # 1
    (2, TType.I32, 'anchorTokenIndex', None, -1, ), # 2
    (3, TType.STRUCT, 'tokenizationId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'textSpan', (concrete.spans.ttypes.TextSpan, concrete.spans.ttypes.TextSpan.thrift_spec), None, ), # 4
    (5, TType.STRUCT, 'audioSpan', (concrete.spans.ttypes.AudioSpan, concrete.spans.ttypes.AudioSpan.thrift_spec), None, ), # 5
  )

  def __init__(self, tokenIndexList=None, anchorTokenIndex=thrift_spec[2][4], tokenizationId=None, textSpan=None, audioSpan=None,):
    self.tokenIndexList = tokenIndexList
    self.anchorTokenIndex = anchorTokenIndex
    self.tokenizationId = tokenizationId
    self.textSpan = textSpan
    self.audioSpan = audioSpan

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.tokenIndexList = []
          (_etype3, _size0) = iprot.readListBegin()
          for _i4 in xrange(_size0):
            _elem5 = iprot.readI32();
            self.tokenIndexList.append(_elem5)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.anchorTokenIndex = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.tokenizationId = concrete.uuid.ttypes.UUID()
          self.tokenizationId.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.textSpan = concrete.spans.ttypes.TextSpan()
          self.textSpan.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRUCT:
          self.audioSpan = concrete.spans.ttypes.AudioSpan()
          self.audioSpan.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TokenRefSequence')
    if self.tokenIndexList is not None:
      oprot.writeFieldBegin('tokenIndexList', TType.LIST, 1)
      oprot.writeListBegin(TType.I32, len(self.tokenIndexList))
      for iter6 in self.tokenIndexList:
        oprot.writeI32(iter6)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.anchorTokenIndex is not None:
      oprot.writeFieldBegin('anchorTokenIndex', TType.I32, 2)
      oprot.writeI32(self.anchorTokenIndex)
      oprot.writeFieldEnd()
    if self.tokenizationId is not None:
      oprot.writeFieldBegin('tokenizationId', TType.STRUCT, 3)
      self.tokenizationId.write(oprot)
      oprot.writeFieldEnd()
    if self.textSpan is not None:
      oprot.writeFieldBegin('textSpan', TType.STRUCT, 4)
      self.textSpan.write(oprot)
      oprot.writeFieldEnd()
    if self.audioSpan is not None:
      oprot.writeFieldBegin('audioSpan', TType.STRUCT, 5)
      self.audioSpan.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.tokenIndexList is None:
      raise TProtocol.TProtocolException(message='Required field tokenIndexList is unset!')
    if self.tokenizationId is None:
      raise TProtocol.TProtocolException(message='Required field tokenizationId is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TaggedToken(object):
  """
  Attributes:
   - tokenIndex: A pointer to the token being tagged.
   - tag: A string containing the annotation.
  If the tag set you are using is not case sensitive,
  then all part of speech tags should be normalized to upper case.
   - confidence: Confidence of the annotation.
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'tokenIndex', None, None, ), # 1
    (2, TType.STRING, 'tag', None, None, ), # 2
    (3, TType.DOUBLE, 'confidence', None, None, ), # 3
  )

  def __init__(self, tokenIndex=None, tag=None, confidence=None,):
    self.tokenIndex = tokenIndex
    self.tag = tag
    self.confidence = confidence

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.tokenIndex = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.tag = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.DOUBLE:
          self.confidence = iprot.readDouble();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TaggedToken')
    if self.tokenIndex is not None:
      oprot.writeFieldBegin('tokenIndex', TType.I32, 1)
      oprot.writeI32(self.tokenIndex)
      oprot.writeFieldEnd()
    if self.tag is not None:
      oprot.writeFieldBegin('tag', TType.STRING, 2)
      oprot.writeString(self.tag.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.confidence is not None:
      oprot.writeFieldBegin('confidence', TType.DOUBLE, 3)
      oprot.writeDouble(self.confidence)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TokenTagging(object):
  """
  A theory about some token-level annotation.
  The TokenTagging consists of a mapping from tokens
  (using token ids) to string tags (e.g. part-of-speech tags or lemmas).

  The mapping defined by a TokenTagging may be partial --
  i.e., some tokens may not be assigned any part of speech tags.

  For lattice tokenizations, you may need to create multiple
  part-of-speech taggings (for different paths through the lattice),
  since the appropriate tag for a given token may depend on the path
  taken. For example, you might define a separate
  TokenTagging for each of the top K paths, which leaves all
  tokens that are not part of the path unlabeled.

  Currently, we use strings to encode annotations. In
  the future, we may add fields for encoding specific tag sets
  (eg treebank tags), or for adding compound tags.

  Attributes:
   - uuid: The UUID of this TokenTagging object.
   - metadata: Information about where the annotation came from.
  This should be used to tell between gold-standard annotations
  and automatically-generated theories about the data
   - taggedTokenList: The mapping from tokens to annotations.
  This may be a partial mapping.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'taggedTokenList', (TType.STRUCT,(TaggedToken, TaggedToken.thrift_spec)), None, ), # 3
  )

  def __init__(self, uuid=None, metadata=None, taggedTokenList=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.taggedTokenList = taggedTokenList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.taggedTokenList = []
          (_etype10, _size7) = iprot.readListBegin()
          for _i11 in xrange(_size7):
            _elem12 = TaggedToken()
            _elem12.read(iprot)
            self.taggedTokenList.append(_elem12)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TokenTagging')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.taggedTokenList is not None:
      oprot.writeFieldBegin('taggedTokenList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.taggedTokenList))
      for iter13 in self.taggedTokenList:
        iter13.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.taggedTokenList is None:
      raise TProtocol.TProtocolException(message='Required field taggedTokenList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Dependency(object):
  """
  Attributes:
   - gov
   - dep
   - edgeType
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'gov', None, None, ), # 1
    (2, TType.I32, 'dep', None, None, ), # 2
    (3, TType.STRING, 'edgeType', None, None, ), # 3
  )

  def __init__(self, gov=None, dep=None, edgeType=None,):
    self.gov = gov
    self.dep = dep
    self.edgeType = edgeType

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.gov = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.dep = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.edgeType = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Dependency')
    if self.gov is not None:
      oprot.writeFieldBegin('gov', TType.I32, 1)
      oprot.writeI32(self.gov)
      oprot.writeFieldEnd()
    if self.dep is not None:
      oprot.writeFieldBegin('dep', TType.I32, 2)
      oprot.writeI32(self.dep)
      oprot.writeFieldEnd()
    if self.edgeType is not None:
      oprot.writeFieldBegin('edgeType', TType.STRING, 3)
      oprot.writeString(self.edgeType.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.dep is None:
      raise TProtocol.TProtocolException(message='Required field dep is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class DependencyParse(object):
  """
  Represents a dependency parse with typed edges.

  Attributes:
   - uuid
   - metadata
   - dependencyList
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'dependencyList', (TType.STRUCT,(Dependency, Dependency.thrift_spec)), None, ), # 3
  )

  def __init__(self, uuid=None, metadata=None, dependencyList=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.dependencyList = dependencyList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.dependencyList = []
          (_etype17, _size14) = iprot.readListBegin()
          for _i18 in xrange(_size14):
            _elem19 = Dependency()
            _elem19.read(iprot)
            self.dependencyList.append(_elem19)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('DependencyParse')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.dependencyList is not None:
      oprot.writeFieldBegin('dependencyList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.dependencyList))
      for iter20 in self.dependencyList:
        iter20.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.dependencyList is None:
      raise TProtocol.TProtocolException(message='Required field dependencyList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Constituent(object):
  """
  A single parse constituent (or "phrase").

  Attributes:
   - id: A parse-relative identifier for this consistuent. Together
  with the UUID for a Parse, this can be used to define
  pointers to specific constituents.
   - tag
   - childList
   - tokenSequence: The list of pointers to the tokens dominated by this
  constituent. Typically, this field will only be defined for
  leaf constituents (i.e., constituents with no children). For
  many parsers, len(tokens) will always be either 1 (for leaf
  constituents) or 0 (for non-leaf constituents).
   - headChildIndex: The index of the head child of this constituent. I.e., the
  head child of constituent <tt>c</tt> is
  <tt>c.children[c.head_child_index]</tt>. A value of -1
  indicates that no child head was identified.
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
    (2, TType.STRING, 'tag', None, None, ), # 2
    (3, TType.LIST, 'childList', (TType.I32,None), None, ), # 3
    (4, TType.STRUCT, 'tokenSequence', (TokenRefSequence, TokenRefSequence.thrift_spec), None, ), # 4
    (5, TType.I32, 'headChildIndex', None, -1, ), # 5
  )

  def __init__(self, id=None, tag=None, childList=None, tokenSequence=None, headChildIndex=thrift_spec[5][4],):
    self.id = id
    self.tag = tag
    self.childList = childList
    self.tokenSequence = tokenSequence
    self.headChildIndex = headChildIndex

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.tag = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.childList = []
          (_etype24, _size21) = iprot.readListBegin()
          for _i25 in xrange(_size21):
            _elem26 = iprot.readI32();
            self.childList.append(_elem26)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.tokenSequence = TokenRefSequence()
          self.tokenSequence.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.headChildIndex = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Constituent')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    if self.tag is not None:
      oprot.writeFieldBegin('tag', TType.STRING, 2)
      oprot.writeString(self.tag.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.childList is not None:
      oprot.writeFieldBegin('childList', TType.LIST, 3)
      oprot.writeListBegin(TType.I32, len(self.childList))
      for iter27 in self.childList:
        oprot.writeI32(iter27)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.tokenSequence is not None:
      oprot.writeFieldBegin('tokenSequence', TType.STRUCT, 4)
      self.tokenSequence.write(oprot)
      oprot.writeFieldEnd()
    if self.headChildIndex is not None:
      oprot.writeFieldBegin('headChildIndex', TType.I32, 5)
      oprot.writeI32(self.headChildIndex)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.id is None:
      raise TProtocol.TProtocolException(message='Required field id is unset!')
    if self.childList is None:
      raise TProtocol.TProtocolException(message='Required field childList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Parse(object):
  """
  A theory about the syntactic parse of a sentence.

  \note If we add support for parse forests in the future, then it
  will most likely be done by adding a new field (e.g.
  "<tt>forest_root</tt>") that uses a new struct type to encode the
  forest. A "<tt>kind</tt>" field might also be added (analogous to
  <tt>Tokenization.kind</tt>) to indicate whether a parse is encoded
  using a simple tree or a parse forest.

  Attributes:
   - uuid
   - metadata
   - constituentList
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'constituentList', (TType.STRUCT,(Constituent, Constituent.thrift_spec)), None, ), # 3
  )

  def __init__(self, uuid=None, metadata=None, constituentList=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.constituentList = constituentList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.constituentList = []
          (_etype31, _size28) = iprot.readListBegin()
          for _i32 in xrange(_size28):
            _elem33 = Constituent()
            _elem33.read(iprot)
            self.constituentList.append(_elem33)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Parse')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.constituentList is not None:
      oprot.writeFieldBegin('constituentList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.constituentList))
      for iter34 in self.constituentList:
        iter34.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.constituentList is None:
      raise TProtocol.TProtocolException(message='Required field constituentList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LatticePath(object):
  """
  Attributes:
   - weight
   - tokenList
  """

  thrift_spec = (
    None, # 0
    (1, TType.DOUBLE, 'weight', None, None, ), # 1
    (2, TType.LIST, 'tokenList', (TType.STRUCT,(Token, Token.thrift_spec)), None, ), # 2
  )

  def __init__(self, weight=None, tokenList=None,):
    self.weight = weight
    self.tokenList = tokenList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.DOUBLE:
          self.weight = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.tokenList = []
          (_etype38, _size35) = iprot.readListBegin()
          for _i39 in xrange(_size35):
            _elem40 = Token()
            _elem40.read(iprot)
            self.tokenList.append(_elem40)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LatticePath')
    if self.weight is not None:
      oprot.writeFieldBegin('weight', TType.DOUBLE, 1)
      oprot.writeDouble(self.weight)
      oprot.writeFieldEnd()
    if self.tokenList is not None:
      oprot.writeFieldBegin('tokenList', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.tokenList))
      for iter41 in self.tokenList:
        iter41.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.tokenList is None:
      raise TProtocol.TProtocolException(message='Required field tokenList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Arc(object):
  """
  Type for arcs. For epsilon edges, leave 'token' blank.

  Attributes:
   - src
   - dst
   - token
   - weight
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'src', None, None, ), # 1
    (2, TType.I32, 'dst', None, None, ), # 2
    (3, TType.STRUCT, 'token', (Token, Token.thrift_spec), None, ), # 3
    (4, TType.DOUBLE, 'weight', None, None, ), # 4
  )

  def __init__(self, src=None, dst=None, token=None, weight=None,):
    self.src = src
    self.dst = dst
    self.token = token
    self.weight = weight

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.src = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.dst = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.token = Token()
          self.token.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.DOUBLE:
          self.weight = iprot.readDouble();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Arc')
    if self.src is not None:
      oprot.writeFieldBegin('src', TType.I32, 1)
      oprot.writeI32(self.src)
      oprot.writeFieldEnd()
    if self.dst is not None:
      oprot.writeFieldBegin('dst', TType.I32, 2)
      oprot.writeI32(self.dst)
      oprot.writeFieldEnd()
    if self.token is not None:
      oprot.writeFieldBegin('token', TType.STRUCT, 3)
      self.token.write(oprot)
      oprot.writeFieldEnd()
    if self.weight is not None:
      oprot.writeFieldBegin('weight', TType.DOUBLE, 4)
      oprot.writeDouble(self.weight)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TokenLattice(object):
  """
  A lattice structure that assigns scores to a set of token
  sequences.  The lattice is encoded as an FSA, where states are
  identified by integers, and each arc is annotated with an
  optional tokens and a weight.  (Arcs with no tokens are
  "epsilon" arcs.)  The lattice has a single start state and a
  single end state.  (You can use epsilon edges to simulate
  multiple start states or multiple end states, if desired.)

  The score of a path through the lattice is the sum of the weights
  of the arcs that make up that path.  A path with a lower score
  is considered "better" than a path with a higher score.

  If possible, path scores should be negative log likelihoods
  (with base e -- e.g. if P=1, then weight=0; and if P=0.5, then
  weight=0.693).  Furthermore, if possible, the path scores should
  be globally normalized (i.e., they should encode probabilities).
  This will allow for them to be combined with other information
  in a reasonable way when determining confidences for system
  outputs.

  TokenLattices should never contain any paths with cycles.  Every
  arc in the lattice should be included in some path from the start
  state to the end state.

  Attributes:
   - startState
   - endState
   - arcList
   - cachedBestPath
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'startState', None, 0, ), # 1
    (2, TType.I32, 'endState', None, 0, ), # 2
    (3, TType.LIST, 'arcList', (TType.STRUCT,(Arc, Arc.thrift_spec)), None, ), # 3
    (4, TType.STRUCT, 'cachedBestPath', (LatticePath, LatticePath.thrift_spec), None, ), # 4
  )

  def __init__(self, startState=thrift_spec[1][4], endState=thrift_spec[2][4], arcList=None, cachedBestPath=None,):
    self.startState = startState
    self.endState = endState
    self.arcList = arcList
    self.cachedBestPath = cachedBestPath

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.startState = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.endState = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.arcList = []
          (_etype45, _size42) = iprot.readListBegin()
          for _i46 in xrange(_size42):
            _elem47 = Arc()
            _elem47.read(iprot)
            self.arcList.append(_elem47)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.cachedBestPath = LatticePath()
          self.cachedBestPath.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TokenLattice')
    if self.startState is not None:
      oprot.writeFieldBegin('startState', TType.I32, 1)
      oprot.writeI32(self.startState)
      oprot.writeFieldEnd()
    if self.endState is not None:
      oprot.writeFieldBegin('endState', TType.I32, 2)
      oprot.writeI32(self.endState)
      oprot.writeFieldEnd()
    if self.arcList is not None:
      oprot.writeFieldBegin('arcList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.arcList))
      for iter48 in self.arcList:
        iter48.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.cachedBestPath is not None:
      oprot.writeFieldBegin('cachedBestPath', TType.STRUCT, 4)
      self.cachedBestPath.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.arcList is None:
      raise TProtocol.TProtocolException(message='Required field arcList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Tokenization(object):
  """
  A theory (or set of alternative theories) about the sequence of
  tokens that make up a sentence.

  This message type is used to record the output of not just for
  tokenizers, but also for a wide variety of other tools, including
  machine translation systems, text normalizers, part-of-speech
  taggers, and stemmers.

  Each Tokenization is encoded using either a single list of tokens,
  or a TokenLattice. (If you want to encode an n-best list, then
  you should store it as n separate Tokenization objects.) The
  "kind" field is used to indicate whether this Tokenization contains
  a list of tokens or a TokenLattice.

  The confidence value for each sequence is determined by combining
  the confidence from the "metadata" field with confidence
  information from individual token sequences as follows:

  <ul>
  <li> For n-best lists:
  metadata.confidence </li>
  <li> For lattices:
  metadata.confidence * exp(-sum(arc.weight)) </li>
  </ul>

  Note: in some cases (such as the output of a machine translation
  tool), the order of the tokens in a token sequence may not
  correspond with the order of their original text span offsets.

  Attributes:
   - uuid
   - metadata: Information about where this tokenization came from.
   - tokenList: An ordered list of the tokens in this tokenization.  This field
  should only have a value if kind==TOKEN_LIST.
   - lattice: A lattice that compactly describes a set of token sequences that
  might make up this tokenization.  This field should only have a
  value if kind==LATTICE.
   - kind: Enumerated value indicating whether this tokenization is
  implemented using an n-best list or a lattice.
   - posTagList
   - nerTagList
   - lemmaList
   - langIdList
   - parse
   - dependencyParseList
   - sentenceId: A pointer to the sentence from which this Tokenization was generated.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'tokenList', (TType.STRUCT,(Token, Token.thrift_spec)), None, ), # 3
    (4, TType.STRUCT, 'lattice', (TokenLattice, TokenLattice.thrift_spec), None, ), # 4
    (5, TType.I32, 'kind', None, None, ), # 5
    (6, TType.STRUCT, 'posTagList', (TokenTagging, TokenTagging.thrift_spec), None, ), # 6
    (7, TType.STRUCT, 'nerTagList', (TokenTagging, TokenTagging.thrift_spec), None, ), # 7
    (8, TType.STRUCT, 'lemmaList', (TokenTagging, TokenTagging.thrift_spec), None, ), # 8
    (9, TType.STRUCT, 'langIdList', (TokenTagging, TokenTagging.thrift_spec), None, ), # 9
    (10, TType.STRUCT, 'parse', (Parse, Parse.thrift_spec), None, ), # 10
    (11, TType.LIST, 'dependencyParseList', (TType.STRUCT,(DependencyParse, DependencyParse.thrift_spec)), None, ), # 11
    (12, TType.STRUCT, 'sentenceId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 12
  )

  def __init__(self, uuid=None, metadata=None, tokenList=None, lattice=None, kind=None, posTagList=None, nerTagList=None, lemmaList=None, langIdList=None, parse=None, dependencyParseList=None, sentenceId=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.tokenList = tokenList
    self.lattice = lattice
    self.kind = kind
    self.posTagList = posTagList
    self.nerTagList = nerTagList
    self.lemmaList = lemmaList
    self.langIdList = langIdList
    self.parse = parse
    self.dependencyParseList = dependencyParseList
    self.sentenceId = sentenceId

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.tokenList = []
          (_etype52, _size49) = iprot.readListBegin()
          for _i53 in xrange(_size49):
            _elem54 = Token()
            _elem54.read(iprot)
            self.tokenList.append(_elem54)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.lattice = TokenLattice()
          self.lattice.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.kind = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRUCT:
          self.posTagList = TokenTagging()
          self.posTagList.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRUCT:
          self.nerTagList = TokenTagging()
          self.nerTagList.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRUCT:
          self.lemmaList = TokenTagging()
          self.lemmaList.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRUCT:
          self.langIdList = TokenTagging()
          self.langIdList.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.STRUCT:
          self.parse = Parse()
          self.parse.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.LIST:
          self.dependencyParseList = []
          (_etype58, _size55) = iprot.readListBegin()
          for _i59 in xrange(_size55):
            _elem60 = DependencyParse()
            _elem60.read(iprot)
            self.dependencyParseList.append(_elem60)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.STRUCT:
          self.sentenceId = concrete.uuid.ttypes.UUID()
          self.sentenceId.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Tokenization')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.tokenList is not None:
      oprot.writeFieldBegin('tokenList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.tokenList))
      for iter61 in self.tokenList:
        iter61.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.lattice is not None:
      oprot.writeFieldBegin('lattice', TType.STRUCT, 4)
      self.lattice.write(oprot)
      oprot.writeFieldEnd()
    if self.kind is not None:
      oprot.writeFieldBegin('kind', TType.I32, 5)
      oprot.writeI32(self.kind)
      oprot.writeFieldEnd()
    if self.posTagList is not None:
      oprot.writeFieldBegin('posTagList', TType.STRUCT, 6)
      self.posTagList.write(oprot)
      oprot.writeFieldEnd()
    if self.nerTagList is not None:
      oprot.writeFieldBegin('nerTagList', TType.STRUCT, 7)
      self.nerTagList.write(oprot)
      oprot.writeFieldEnd()
    if self.lemmaList is not None:
      oprot.writeFieldBegin('lemmaList', TType.STRUCT, 8)
      self.lemmaList.write(oprot)
      oprot.writeFieldEnd()
    if self.langIdList is not None:
      oprot.writeFieldBegin('langIdList', TType.STRUCT, 9)
      self.langIdList.write(oprot)
      oprot.writeFieldEnd()
    if self.parse is not None:
      oprot.writeFieldBegin('parse', TType.STRUCT, 10)
      self.parse.write(oprot)
      oprot.writeFieldEnd()
    if self.dependencyParseList is not None:
      oprot.writeFieldBegin('dependencyParseList', TType.LIST, 11)
      oprot.writeListBegin(TType.STRUCT, len(self.dependencyParseList))
      for iter62 in self.dependencyParseList:
        iter62.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.sentenceId is not None:
      oprot.writeFieldBegin('sentenceId', TType.STRUCT, 12)
      self.sentenceId.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.kind is None:
      raise TProtocol.TProtocolException(message='Required field kind is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TokenizationCollection(object):
  """
  Attributes:
   - metadata
   - tokenizationList
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 1
    (2, TType.LIST, 'tokenizationList', (TType.STRUCT,(Tokenization, Tokenization.thrift_spec)), None, ), # 2
  )

  def __init__(self, metadata=None, tokenizationList=None,):
    self.metadata = metadata
    self.tokenizationList = tokenizationList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.tokenizationList = []
          (_etype66, _size63) = iprot.readListBegin()
          for _i67 in xrange(_size63):
            _elem68 = Tokenization()
            _elem68.read(iprot)
            self.tokenizationList.append(_elem68)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TokenizationCollection')
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 1)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.tokenizationList is not None:
      oprot.writeFieldBegin('tokenizationList', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.tokenizationList))
      for iter69 in self.tokenizationList:
        iter69.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.metadata is None:
      raise TProtocol.TProtocolException(message='Required field metadata is unset!')
    if self.tokenizationList is None:
      raise TProtocol.TProtocolException(message='Required field tokenizationList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Sentence(object):
  """
  A single sentence or utterance in a communication.

  Attributes:
   - uuid
   - tokenizationList: Theories about the tokens that make up this sentence.  For text
  communications, these tokenizations will typically be generated
  by a tokenizer.  For audio communications, these tokenizations
  will typically be generated by an automatic speech recognizer.

  The "Tokenization" message type is also used to store the output
  of machine translation systems and text normalization
  systems.
   - textSpan: Location of this sentence in the original text.
   - audioSpan: Location of this sentence in the original audio.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.LIST, 'tokenizationList', (TType.STRUCT,(Tokenization, Tokenization.thrift_spec)), None, ), # 2
    (3, TType.STRUCT, 'textSpan', (concrete.spans.ttypes.TextSpan, concrete.spans.ttypes.TextSpan.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'audioSpan', (concrete.spans.ttypes.AudioSpan, concrete.spans.ttypes.AudioSpan.thrift_spec), None, ), # 4
  )

  def __init__(self, uuid=None, tokenizationList=None, textSpan=None, audioSpan=None,):
    self.uuid = uuid
    self.tokenizationList = tokenizationList
    self.textSpan = textSpan
    self.audioSpan = audioSpan

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.tokenizationList = []
          (_etype73, _size70) = iprot.readListBegin()
          for _i74 in xrange(_size70):
            _elem75 = Tokenization()
            _elem75.read(iprot)
            self.tokenizationList.append(_elem75)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.textSpan = concrete.spans.ttypes.TextSpan()
          self.textSpan.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.audioSpan = concrete.spans.ttypes.AudioSpan()
          self.audioSpan.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Sentence')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.tokenizationList is not None:
      oprot.writeFieldBegin('tokenizationList', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.tokenizationList))
      for iter76 in self.tokenizationList:
        iter76.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.textSpan is not None:
      oprot.writeFieldBegin('textSpan', TType.STRUCT, 3)
      self.textSpan.write(oprot)
      oprot.writeFieldEnd()
    if self.audioSpan is not None:
      oprot.writeFieldBegin('audioSpan', TType.STRUCT, 4)
      self.audioSpan.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SentenceSegmentation(object):
  """
  A theory about how a section of a communication is broken down
  into sentences (or utterances). The sentences in a
  SentenceSegmentation should be ordered and non-overlapping.

  Attributes:
   - uuid
   - metadata: Information about where this segmentation came from.
   - sentenceList: Theories about the tokens that make up this sentence.  For text
  communications, these tokenizations will typically be generated
  by a tokenizer.  For audio communications, these tokenizations
  will typically be generated by an automatic speech recognizer.

  The "Tokenization" message type is also used to store the output
  of machine translation systems and text normalization
  systems.
   - sectionId: A UUID pointer to the "parent" Section that this SentenceSegmentation
  is associated with.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'sentenceList', (TType.STRUCT,(Sentence, Sentence.thrift_spec)), None, ), # 3
    (4, TType.STRUCT, 'sectionId', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 4
  )

  def __init__(self, uuid=None, metadata=None, sentenceList=None, sectionId=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.sentenceList = sentenceList
    self.sectionId = sectionId

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.sentenceList = []
          (_etype80, _size77) = iprot.readListBegin()
          for _i81 in xrange(_size77):
            _elem82 = Sentence()
            _elem82.read(iprot)
            self.sentenceList.append(_elem82)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.sectionId = concrete.uuid.ttypes.UUID()
          self.sectionId.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SentenceSegmentation')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.sentenceList is not None:
      oprot.writeFieldBegin('sentenceList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.sentenceList))
      for iter83 in self.sentenceList:
        iter83.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.sectionId is not None:
      oprot.writeFieldBegin('sectionId', TType.STRUCT, 4)
      self.sectionId.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.sentenceList is None:
      raise TProtocol.TProtocolException(message='Required field sentenceList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SentenceSegmentationCollection(object):
  """
  A simple wrapper around a list of SentenceSegmentations, used by the API
  to better wrap up and merge results.

  Attributes:
   - metadata
   - sentSegList
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 1
    (2, TType.LIST, 'sentSegList', (TType.STRUCT,(SentenceSegmentation, SentenceSegmentation.thrift_spec)), None, ), # 2
  )

  def __init__(self, metadata=None, sentSegList=None,):
    self.metadata = metadata
    self.sentSegList = sentSegList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.sentSegList = []
          (_etype87, _size84) = iprot.readListBegin()
          for _i88 in xrange(_size84):
            _elem89 = SentenceSegmentation()
            _elem89.read(iprot)
            self.sentSegList.append(_elem89)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SentenceSegmentationCollection')
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 1)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.sentSegList is not None:
      oprot.writeFieldBegin('sentSegList', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.sentSegList))
      for iter90 in self.sentSegList:
        iter90.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.metadata is None:
      raise TProtocol.TProtocolException(message='Required field metadata is unset!')
    if self.sentSegList is None:
      raise TProtocol.TProtocolException(message='Required field sentSegList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Section(object):
  """
  A single "section" of a communication, such as a paragraph. Each
  section is defined using a text or audio span, and can optionally
  contain a list of sentences.

  Attributes:
   - uuid
   - sentenceSegmentation: Theories about how this section is divided into sentences.
   - textSpan: Location of this section in the original text.
   - audioSpan: Location of this section in the original audio.
   - kind: The type of this section.
   - label: The name of the section
   - number: Position within the communication with respect to other Sections:
  The section number, E.g., 3, or 3.1, or 3.1.2, etc. Aimed at
  Communications with content organized in a hierarchy, such as a Book
  with multiple chapters, then sections, then paragraphs. Or even a
  dense Wikipedia page with subsections. Sections should still be
  arranged linearly, where reading these numbers should not be required
  to get a start-to-finish enumeration of the Communication's content.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.LIST, 'sentenceSegmentation', (TType.STRUCT,(SentenceSegmentation, SentenceSegmentation.thrift_spec)), None, ), # 2
    (3, TType.STRUCT, 'textSpan', (concrete.spans.ttypes.TextSpan, concrete.spans.ttypes.TextSpan.thrift_spec), None, ), # 3
    (4, TType.STRING, 'kind', None, None, ), # 4
    (5, TType.STRING, 'label', None, None, ), # 5
    (6, TType.LIST, 'number', (TType.I32,None), None, ), # 6
    None, # 7
    None, # 8
    (9, TType.STRUCT, 'audioSpan', (concrete.spans.ttypes.AudioSpan, concrete.spans.ttypes.AudioSpan.thrift_spec), None, ), # 9
  )

  def __init__(self, uuid=None, sentenceSegmentation=None, textSpan=None, audioSpan=None, kind=None, label=None, number=None,):
    self.uuid = uuid
    self.sentenceSegmentation = sentenceSegmentation
    self.textSpan = textSpan
    self.audioSpan = audioSpan
    self.kind = kind
    self.label = label
    self.number = number

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.sentenceSegmentation = []
          (_etype94, _size91) = iprot.readListBegin()
          for _i95 in xrange(_size91):
            _elem96 = SentenceSegmentation()
            _elem96.read(iprot)
            self.sentenceSegmentation.append(_elem96)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.textSpan = concrete.spans.ttypes.TextSpan()
          self.textSpan.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRUCT:
          self.audioSpan = concrete.spans.ttypes.AudioSpan()
          self.audioSpan.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.kind = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.label = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.LIST:
          self.number = []
          (_etype100, _size97) = iprot.readListBegin()
          for _i101 in xrange(_size97):
            _elem102 = iprot.readI32();
            self.number.append(_elem102)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Section')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.sentenceSegmentation is not None:
      oprot.writeFieldBegin('sentenceSegmentation', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.sentenceSegmentation))
      for iter103 in self.sentenceSegmentation:
        iter103.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.textSpan is not None:
      oprot.writeFieldBegin('textSpan', TType.STRUCT, 3)
      self.textSpan.write(oprot)
      oprot.writeFieldEnd()
    if self.kind is not None:
      oprot.writeFieldBegin('kind', TType.STRING, 4)
      oprot.writeString(self.kind.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.label is not None:
      oprot.writeFieldBegin('label', TType.STRING, 5)
      oprot.writeString(self.label.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.number is not None:
      oprot.writeFieldBegin('number', TType.LIST, 6)
      oprot.writeListBegin(TType.I32, len(self.number))
      for iter104 in self.number:
        oprot.writeI32(iter104)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.audioSpan is not None:
      oprot.writeFieldBegin('audioSpan', TType.STRUCT, 9)
      self.audioSpan.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.kind is None:
      raise TProtocol.TProtocolException(message='Required field kind is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SectionSegmentation(object):
  """
  A theory about how a communication is broken down into smaller
  sections (such as paragraphs). The sections should be ordered
  and non-overlapping.

  Attributes:
   - uuid: Unique identifier for this segmentation.
   - metadata: Information about where this segmentation came from.
   - sectionList: Ordered list of sections in this segmentation.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'uuid', (concrete.uuid.ttypes.UUID, concrete.uuid.ttypes.UUID.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'metadata', (concrete.metadata.ttypes.AnnotationMetadata, concrete.metadata.ttypes.AnnotationMetadata.thrift_spec), None, ), # 2
    (3, TType.LIST, 'sectionList', (TType.STRUCT,(Section, Section.thrift_spec)), None, ), # 3
  )

  def __init__(self, uuid=None, metadata=None, sectionList=None,):
    self.uuid = uuid
    self.metadata = metadata
    self.sectionList = sectionList

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.uuid = concrete.uuid.ttypes.UUID()
          self.uuid.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.metadata = concrete.metadata.ttypes.AnnotationMetadata()
          self.metadata.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.sectionList = []
          (_etype108, _size105) = iprot.readListBegin()
          for _i109 in xrange(_size105):
            _elem110 = Section()
            _elem110.read(iprot)
            self.sectionList.append(_elem110)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SectionSegmentation')
    if self.uuid is not None:
      oprot.writeFieldBegin('uuid', TType.STRUCT, 1)
      self.uuid.write(oprot)
      oprot.writeFieldEnd()
    if self.metadata is not None:
      oprot.writeFieldBegin('metadata', TType.STRUCT, 2)
      self.metadata.write(oprot)
      oprot.writeFieldEnd()
    if self.sectionList is not None:
      oprot.writeFieldBegin('sectionList', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.sectionList))
      for iter111 in self.sectionList:
        iter111.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.uuid is None:
      raise TProtocol.TProtocolException(message='Required field uuid is unset!')
    if self.sectionList is None:
      raise TProtocol.TProtocolException(message='Required field sectionList is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
